/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.util;

import java.io.PrintStream;
import org.apache.commons.lang.StringUtils;

public class PluginLogger {
    private final String pluginName;
    private PrintStream logger;

    public PluginLogger(PrintStream logger, String pluginName) {
        this.logger = logger;
        this.pluginName = pluginName;
    }

    protected PluginLogger(String pluginName) {
        this.pluginName = pluginName.contains("[") ? pluginName : "[" + pluginName + "] ";
    }

    protected void setLogger(PrintStream logger) {
        this.logger = logger;
    }

    public void log(String message) {
        this.logger.println(StringUtils.defaultString((String)this.pluginName) + message);
    }

    public void log(Throwable throwable) {
        this.logger.println(StringUtils.defaultString((String)this.pluginName) + throwable.getMessage());
    }

    public void printStackTrace(Throwable throwable) {
        throwable.printStackTrace(this.logger);
    }

    public void logLines(String lines) {
        this.logger.print(lines);
    }
}

