/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.util;

import hudson.plugins.analysis.Messages;
import hudson.plugins.analysis.util.Validator;
import hudson.util.FormValidation;
import org.apache.commons.lang.StringUtils;

public class ThresholdValidator
implements Validator {
    @Override
    public FormValidation check(String value) throws FormValidation {
        if (!StringUtils.isEmpty((String)value)) {
            try {
                int integer = Integer.parseInt(value);
                if (integer < 0) {
                    throw FormValidation.error((String)Messages.FieldValidator_Error_Threshold());
                }
            }
            catch (NumberFormatException exception) {
                throw FormValidation.error((String)Messages.FieldValidator_Error_Threshold());
            }
        }
        return FormValidation.ok();
    }

    public static boolean isValid(String threshold) {
        if (StringUtils.isNotBlank((String)threshold)) {
            try {
                return Integer.valueOf(threshold) >= 0;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public static int convert(String threshold) {
        if (ThresholdValidator.isValid(threshold) && StringUtils.isNotBlank((String)threshold)) {
            try {
                return Integer.valueOf(threshold);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("Not a parsable integer value >= 0: " + threshold);
    }
}

