/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.plugins.analysis.util.TreeString;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@SuppressFBWarnings(value={""})
public class TreeStringBuilder {
    Child root = new Child(new TreeString());
    private static final Map<String, Child> NO_CHILDREN = Collections.emptyMap();

    public TreeString intern(String s) {
        if (s == null) {
            return null;
        }
        return this.root.intern(s).node;
    }

    public TreeString intern(TreeString s) {
        if (s == null) {
            return null;
        }
        return this.root.intern(s.toString()).node;
    }

    public void dedup() {
        this.root.dedup(new HashMap());
    }

    private static class Child {
        private final TreeString node;
        private Map<String, Child> children = TreeStringBuilder.access$100();

        private Child(TreeString node) {
            this.node = node;
        }

        public Child intern(String s) {
            if (s.length() == 0) {
                return this;
            }
            this.makeWritable();
            for (Map.Entry<String, Child> e : this.children.entrySet()) {
                int plen = this.commonPrefix(e.getKey(), s);
                if (plen <= 0) continue;
                if (plen < e.getKey().length()) {
                    Child c = e.getValue();
                    String prefix = s.substring(0, plen);
                    Child middle = c.split(prefix);
                    this.children.remove(e.getKey());
                    this.children.put(prefix, middle);
                    return middle.intern(s.substring(plen));
                }
                return e.getValue().intern(s.substring(plen));
            }
            Child t = this.children.get(s);
            if (t == null) {
                t = new Child(new TreeString(this.node, s));
                this.children.put(s, t);
            }
            return t;
        }

        private void makeWritable() {
            if (this.children == NO_CHILDREN) {
                this.children = new HashMap<String, Child>();
            }
        }

        private Child split(String prefix) {
            String suffix = this.node.getLabel().substring(prefix.length());
            Child middle = new Child(this.node.split(prefix));
            middle.makeWritable();
            middle.children.put(suffix, this);
            return middle;
        }

        private int commonPrefix(String a, String b) {
            int m = Math.min(a.length(), b.length());
            for (int i = 0; i < m; ++i) {
                if (a.charAt(i) == b.charAt(i)) continue;
                return i;
            }
            return m;
        }

        private void dedup(Map<String, char[]> table) {
            this.node.dedup(table);
            for (Child child : this.children.values()) {
                child.dedup(table);
            }
        }
    }
}

