/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.util;

import hudson.plugins.analysis.Messages;
import hudson.plugins.analysis.util.Validator;
import hudson.util.FormValidation;
import org.apache.commons.lang.StringUtils;

public class TrendReportHeightValidator
implements Validator {
    private static final int HEIGHT = 200;
    private static final int MINIMUM_HEIGHT = 50;

    public static int defaultHeight(String height) {
        int actualHeight = 200;
        if (!StringUtils.isEmpty((String)height)) {
            try {
                actualHeight = Math.max(50, Integer.valueOf(height));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return actualHeight;
    }

    @Override
    public FormValidation check(String value) throws FormValidation {
        if (!StringUtils.isEmpty((String)value)) {
            try {
                int integer = Integer.parseInt(value);
                if (integer < 50) {
                    throw FormValidation.error((String)Messages.FieldValidator_Error_TrendHeight(50));
                }
            }
            catch (NumberFormatException exception) {
                throw FormValidation.error((String)Messages.FieldValidator_Error_TrendHeight(50));
            }
        }
        return FormValidation.ok();
    }
}

