/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.util.model;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.AbstractBuild;
import hudson.model.Item;
import hudson.model.Run;
import hudson.plugins.analysis.Messages;
import hudson.plugins.analysis.util.TreeString;
import hudson.plugins.analysis.util.TreeStringBuilder;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.analysis.util.model.LineRange;
import hudson.plugins.analysis.util.model.LineRangeList;
import hudson.plugins.analysis.util.model.Priority;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;
import javax.annotation.Nonnull;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public abstract class AbstractAnnotation
implements FileAnnotation,
Serializable {
    private static final String DEFAULT_PACKAGE = "Default Package";
    private static final String SLASH = "/";
    public static final String WORKSPACE_FILES = "workspace-files";
    private static final long serialVersionUID = -1092014926477547148L;
    public static final String DEFAULT_CATEGORY = "-";
    private static long currentKey = new Random().nextLong();
    private TreeString message;
    private Priority priority;
    private final long key;
    private final LineRangeList lineRanges;
    private final int primaryLineNumber;
    private TreeString fileName;
    private TreeString moduleName;
    private TreeString packageName;
    private TreeString overridePackageCategoryName;
    private String category;
    private String type;
    private long contextHashCode;
    private String origin;
    private TreeString pathName;
    private int primaryColumnStart;
    private int primaryColumnEnd;
    private int build;
    private String authorName;
    private String authorEmail;
    private String commitId;

    @SuppressFBWarnings(value={"ST"})
    public AbstractAnnotation(String message, int start, int end, String category, String type) {
        this.message = TreeString.of(StringUtils.strip((String)message));
        this.category = AbstractAnnotation.defaultString(category);
        this.type = AbstractAnnotation.defaultString(type);
        this.key = currentKey++;
        this.lineRanges = new LineRangeList();
        this.lineRanges.add(new LineRange(start, end));
        this.primaryLineNumber = start;
        this.contextHashCode = currentKey;
    }

    private static String defaultString(String value) {
        return (String)StringUtils.defaultIfBlank((CharSequence)value, (CharSequence)DEFAULT_CATEGORY);
    }

    public AbstractAnnotation(Priority priority, String message, int start, int end, String category, String type) {
        this(message, start, end, category, type);
        this.priority = priority;
    }

    @SuppressFBWarnings(value={"ST"})
    public AbstractAnnotation(FileAnnotation copy) {
        this.key = currentKey++;
        this.message = TreeString.of(copy.getMessage());
        this.priority = copy.getPriority();
        this.primaryLineNumber = copy.getPrimaryLineNumber();
        this.lineRanges = new LineRangeList(copy.getLineRanges());
        this.contextHashCode = copy.getContextHashCode();
        this.fileName = TreeString.of(copy.getFileName());
        this.category = copy.getCategory();
        this.type = copy.getType();
        this.moduleName = TreeString.of(copy.getModuleName());
        this.packageName = TreeString.of(copy.getPackageName());
        this.authorName = copy.getAuthorName();
        this.authorEmail = copy.getAuthorEmail();
        this.commitId = copy.getCommitId();
        this.overridePackageCategoryName = TreeString.of(copy.getOverridePackageCategoryName());
    }

    @SuppressFBWarnings(value={"SE"})
    private Object readResolve() {
        if (this.origin != null) {
            this.origin = this.origin.intern();
        }
        if (this.category != null) {
            this.category = this.category.intern();
        }
        if (this.type != null) {
            this.type = this.type.intern();
        }
        if (this.authorName != null) {
            this.authorName = this.authorName.intern();
        }
        if (this.authorEmail != null) {
            this.authorEmail = this.authorEmail.intern();
        }
        if (this.commitId != null) {
            this.commitId = this.commitId.intern();
        }
        return this;
    }

    protected void superReadResolve() {
        this.readResolve();
    }

    public void intern(TreeStringBuilder builder) {
        this.lineRanges.trim();
        this.message = builder.intern(this.message);
        this.fileName = builder.intern(this.fileName);
        this.moduleName = builder.intern(this.moduleName);
        this.packageName = builder.intern(this.packageName);
        this.readResolve();
    }

    public static Collection<FileAnnotation> intern(Collection<FileAnnotation> annotations) {
        TreeStringBuilder stringPool = new TreeStringBuilder();
        for (FileAnnotation annotation : annotations) {
            if (!(annotation instanceof AbstractAnnotation)) continue;
            AbstractAnnotation aa = (AbstractAnnotation)annotation;
            aa.intern(stringPool);
        }
        stringPool.dedup();
        return annotations;
    }

    public void setColumnPosition(int column) {
        this.setColumnPosition(column, column);
    }

    public void setColumnPosition(int columnStart, int columnEnd) {
        this.primaryColumnStart = columnStart;
        this.primaryColumnEnd = columnEnd;
    }

    @Override
    public String getLinkName() {
        if (this.hasPackageName()) {
            return this.getPackageName() + "." + FilenameUtils.getBaseName((String)this.getFileName());
        }
        if (this.pathName == null || this.pathName.isBlank()) {
            return this.getFileName();
        }
        return this.pathName + SLASH + this.getShortFileName();
    }

    @Override
    public boolean hasPackageName() {
        String actualPackageName = StringUtils.trim((String)TreeString.toString(this.packageName));
        return StringUtils.isNotBlank((CharSequence)actualPackageName) && !StringUtils.equals((CharSequence)actualPackageName, (CharSequence)DEFAULT_CATEGORY);
    }

    @Override
    public boolean hasOverridePackageCategoryName() {
        String actualPackageCategoryName = StringUtils.trim((String)TreeString.toString(this.overridePackageCategoryName));
        return StringUtils.isNotBlank((CharSequence)actualPackageCategoryName);
    }

    @Override
    public boolean hasOverridePackageCategoryTitle() {
        return this.hasOverridePackageCategoryName();
    }

    @Override
    public void setPathName(String workspacePath) {
        String normalized = workspacePath.replace('\\', '/');
        String s = StringUtils.removeStart((String)this.getFileName(), (String)normalized);
        s = StringUtils.remove((String)s, (String)FilenameUtils.getName((String)this.getFileName()));
        s = StringUtils.removeStart((String)s, (String)SLASH);
        s = StringUtils.removeEnd((String)s, (String)SLASH);
        this.pathName = TreeString.of(s);
    }

    @Override
    public String getPathName() {
        return TreeString.toString(this.pathName);
    }

    @Override
    public String getOrigin() {
        return StringUtils.defaultString((String)this.origin);
    }

    @Override
    public int getColumnEnd() {
        return this.primaryColumnEnd;
    }

    @Override
    public int getColumnStart() {
        return this.primaryColumnStart;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    @Override
    @Exported
    public String getMessage() {
        return TreeString.toString(this.message);
    }

    @Override
    @Exported
    public Priority getPriority() {
        return this.priority;
    }

    @Override
    @Exported
    public final long getKey() {
        return this.key;
    }

    @Override
    @Exported
    public final String getFileName() {
        return TreeString.toString(this.fileName);
    }

    @Override
    public String getTempName(@Nonnull Run<?, ?> owner) {
        if (this.fileName != null) {
            return owner.getRootDir().getAbsolutePath() + SLASH + WORKSPACE_FILES + SLASH + Integer.toHexString(this.fileName.hashCode()) + ".tmp";
        }
        return "";
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public final void setFileName(String fileName) {
        this.fileName = TreeString.of(StringUtils.strip((String)fileName).replace('\\', '/'));
    }

    @Override
    @Exported
    public final String getModuleName() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)TreeString.toString(this.moduleName), (CharSequence)"Default Module");
    }

    @Override
    public final void setModuleName(String moduleName) {
        this.moduleName = TreeString.of(moduleName);
    }

    @Override
    @Exported
    public final String getPackageName() {
        if (this.hasPackageName()) {
            return TreeString.toString(this.packageName);
        }
        return (String)StringUtils.defaultIfEmpty((CharSequence)TreeString.toString(this.pathName), (CharSequence)StringUtils.defaultIfEmpty((CharSequence)TreeString.toString(this.packageName), (CharSequence)DEFAULT_PACKAGE));
    }

    @Override
    @Exported
    public final String getOverridePackageCategoryName() {
        return TreeString.toString(this.overridePackageCategoryName);
    }

    @Override
    @Exported
    public final String getOverridePackageCategoryTitle() {
        return TreeString.toString(this.overridePackageCategoryName) + "s";
    }

    public final void setPackageName(String packageName) {
        this.packageName = TreeString.of(packageName);
    }

    public final void setOverridePackageCategoryName(String packageCategoryName) {
        this.overridePackageCategoryName = TreeString.of(packageCategoryName);
    }

    @Override
    public final Collection<LineRange> getLineRanges() {
        return Collections.unmodifiableCollection(this.lineRanges);
    }

    @Override
    public String getAuthor() {
        return StringUtils.defaultString((String)this.getAuthorName(), (String)this.getAuthorEmail());
    }

    @Override
    @Exported
    public String getAuthorDetails() {
        if (StringUtils.isBlank((CharSequence)this.authorName) && StringUtils.isBlank((CharSequence)this.authorEmail)) {
            return Messages.Author_NoResult();
        }
        if (StringUtils.isBlank((CharSequence)this.authorName)) {
            return this.authorEmail;
        }
        if (StringUtils.isBlank((CharSequence)this.authorEmail)) {
            return this.authorName;
        }
        return String.format("%s <%s>", this.authorName, this.authorEmail);
    }

    @Override
    public String getAuthorName() {
        return AbstractAnnotation.defaultString(this.authorName);
    }

    @Override
    public void setAuthorName(String authorName) {
        this.authorName = authorName;
    }

    @Override
    public String getAuthorEmail() {
        return AbstractAnnotation.defaultString(this.authorEmail);
    }

    @Override
    public void setAuthorEmail(String authorEmail) {
        this.authorEmail = authorEmail;
    }

    @Override
    public String getCommitId() {
        return AbstractAnnotation.defaultString(this.commitId);
    }

    @Override
    public String getCommitDetails() {
        return StringUtils.substring((String)AbstractAnnotation.defaultString(this.commitId), (int)0, (int)6);
    }

    @Override
    public void setCommitId(String commitId) {
        this.commitId = commitId;
    }

    @Override
    @Exported
    public final int getPrimaryLineNumber() {
        return this.primaryLineNumber;
    }

    public final int getLinkLineNumber() {
        return Math.max(1, this.primaryLineNumber - 10);
    }

    public void addLineRange(LineRange lineRange) {
        if (!this.lineRanges.contains(lineRange)) {
            this.lineRanges.add(lineRange);
        }
    }

    @Override
    public long getContextHashCode() {
        return this.contextHashCode;
    }

    @Override
    public void setContextHashCode(long contextHashCode) {
        this.contextHashCode = contextHashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractAnnotation that = (AbstractAnnotation)o;
        if (this.primaryLineNumber != that.primaryLineNumber) {
            return false;
        }
        if (this.primaryColumnStart != that.primaryColumnStart) {
            return false;
        }
        if (this.primaryColumnEnd != that.primaryColumnEnd) {
            return false;
        }
        if (this.message != null) {
            if (that.message == null) {
                return false;
            }
            if (!this.message.toString().equals(that.message.toString())) {
                return false;
            }
        } else if (that.message != null) {
            return false;
        }
        if (this.priority != that.priority) {
            return false;
        }
        if (this.lineRanges != null ? !this.lineRanges.equals(that.lineRanges) : that.lineRanges != null) {
            return false;
        }
        if (this.fileName != null) {
            if (that.fileName == null) {
                return false;
            }
            if (!this.fileName.toString().equals(that.fileName.toString())) {
                return false;
            }
        } else if (that.fileName != null) {
            return false;
        }
        if (this.moduleName != null) {
            if (that.moduleName == null) {
                return false;
            }
            if (!this.moduleName.toString().equals(that.moduleName.toString())) {
                return false;
            }
        } else if (that.moduleName != null) {
            return false;
        }
        if (this.packageName != null) {
            if (that.packageName == null) {
                return false;
            }
            if (!this.packageName.toString().equals(that.packageName.toString())) {
                return false;
            }
        } else if (that.packageName != null) {
            return false;
        }
        if (this.category != null ? !this.category.equals(that.category) : that.category != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.origin != null ? !this.origin.equals(that.origin) : that.origin != null) {
            return false;
        }
        return !(this.pathName != null ? !this.pathName.equals(that.pathName) : that.pathName != null);
    }

    public int hashCode() {
        int result = this.message != null ? this.message.hashCode() : 0;
        result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
        result = 31 * result + (this.lineRanges != null ? this.lineRanges.hashCode() : 0);
        result = 31 * result + this.primaryLineNumber;
        result = 31 * result + (this.fileName != null ? this.fileName.hashCode() : 0);
        result = 31 * result + (this.moduleName != null ? this.moduleName.hashCode() : 0);
        result = 31 * result + (this.packageName != null ? this.packageName.hashCode() : 0);
        result = 31 * result + (this.category != null ? this.category.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.origin != null ? this.origin.hashCode() : 0);
        result = 31 * result + (this.pathName != null ? this.pathName.hashCode() : 0);
        result = 31 * result + this.primaryColumnStart;
        result = 31 * result + this.primaryColumnEnd;
        return result;
    }

    @Override
    public String getShortFileName() {
        if (this.isInConsoleLog()) {
            return Messages.ConsoleLog_Name();
        }
        return FilenameUtils.getName((String)TreeString.toString(this.fileName));
    }

    @Override
    public final boolean canDisplayFile(Run<?, ?> owner) {
        if (owner.hasPermission(Item.WORKSPACE)) {
            return this.isInConsoleLog() || new File(this.getFileName()).exists() || new File(this.getTempName(owner)).exists();
        }
        return false;
    }

    @Override
    public int compareTo(FileAnnotation other) {
        int result = this.getFileName().compareTo(other.getFileName());
        if (result != 0) {
            return result;
        }
        result = this.getPrimaryLineNumber() - other.getPrimaryLineNumber();
        if (result != 0) {
            return result;
        }
        result = this.getColumnStart() - other.getColumnStart();
        if (result != 0) {
            return result;
        }
        return this.hashCode() - other.hashCode();
    }

    public String toString() {
        return String.format("%s(%s):%s,%s,%s:%s", new Object[]{this.getFileName(), this.primaryLineNumber, this.priority, this.getCategory(), this.getType(), this.getMessage()});
    }

    @Override
    public boolean isInConsoleLog() {
        return this.fileName == null || StringUtils.isBlank((CharSequence)this.fileName.toString());
    }

    @Override
    public void setBuild(int build) {
        this.build = build;
    }

    @Override
    public int getBuild() {
        return this.build;
    }

    @Deprecated
    public String getTempName(AbstractBuild<?, ?> owner) {
        return this.getTempName((Run<?, ?>)owner);
    }
}

