/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.util.model;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.plugins.analysis.Messages;
import hudson.plugins.analysis.util.model.AnnotationProvider;
import hudson.plugins.analysis.util.model.AnnotationsLabelProvider;
import hudson.plugins.analysis.util.model.Author;
import hudson.plugins.analysis.util.model.DefaultAnnotationContainer;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.analysis.util.model.JavaPackage;
import hudson.plugins.analysis.util.model.MavenModule;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.analysis.util.model.WorkspaceFile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;

public abstract class AnnotationContainer
implements AnnotationProvider,
Serializable,
Comparable<AnnotationContainer> {
    private static final long serialVersionUID = 855696821788264261L;
    @SuppressWarnings(value={"Se"})
    private final Map<Long, FileAnnotation> annotations = new HashMap<Long, FileAnnotation>();
    private transient Map<Priority, Set<FileAnnotation>> annotationsByPriority;
    private transient Map<String, Set<FileAnnotation>> annotationsByCategory;
    private transient Map<String, Set<FileAnnotation>> annotationsByType;
    private transient Map<String, WorkspaceFile> filesByName;
    private transient Map<String, JavaPackage> packagesByName;
    private transient Map<String, MavenModule> modulesByName;
    private transient Map<String, Author> authorsByName;
    private transient Map<Integer, WorkspaceFile> filesByHashCode;
    private transient Map<Integer, JavaPackage> packagesByHashCode;
    private transient Map<Integer, MavenModule> modulesByHashCode;
    private transient Map<Integer, Set<FileAnnotation>> categoriesByHashCode;
    private transient Map<Integer, Set<FileAnnotation>> typesByHashCode;
    private transient Map<Integer, Author> authorsByHashCode;
    private boolean handleFiles;
    private AnnotationsLabelProvider labelProvider;
    private String name;
    private Hierarchy hierarchy;

    public AnnotationContainer(Hierarchy hierarchy) {
        this("", hierarchy);
    }

    public AnnotationContainer getContainer() {
        return this;
    }

    public AnnotationsLabelProvider getLabelProvider() {
        return (AnnotationsLabelProvider)Objects.firstNonNull((Object)this.labelProvider, (Object)new AnnotationsLabelProvider(this.getPackageCategoryTitle()));
    }

    public void setLabelProvider(AnnotationsLabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public int getUpperBound(Collection<? extends AnnotationContainer> containers) {
        int maximum = 0;
        for (AnnotationContainer annotationContainer : containers) {
            maximum = Math.max(maximum, annotationContainer.getNumberOfAnnotations());
        }
        return maximum;
    }

    protected AnnotationContainer(String name, Hierarchy hierarchy) {
        this.initialize();
        this.name = name;
        this.hierarchy = hierarchy;
    }

    protected void setHierarchy(Hierarchy hierarchy) {
        this.hierarchy = hierarchy;
    }

    public Hierarchy getHierarchy() {
        return this.hierarchy;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    private void initialize() {
        this.annotationsByPriority = new EnumMap<Priority, Set<FileAnnotation>>(Priority.class);
        for (Priority priority : Priority.values()) {
            this.annotationsByPriority.put(priority, new HashSet());
        }
        this.annotationsByCategory = new HashMap<String, Set<FileAnnotation>>();
        this.annotationsByType = new HashMap<String, Set<FileAnnotation>>();
        this.authorsByName = new HashMap<String, Author>();
        this.filesByName = new HashMap<String, WorkspaceFile>();
        this.packagesByName = new HashMap<String, JavaPackage>();
        this.modulesByName = new HashMap<String, MavenModule>();
        this.filesByHashCode = new HashMap<Integer, WorkspaceFile>();
        this.packagesByHashCode = new HashMap<Integer, JavaPackage>();
        this.modulesByHashCode = new HashMap<Integer, MavenModule>();
        this.authorsByHashCode = new HashMap<Integer, Author>();
        this.categoriesByHashCode = new HashMap<Integer, Set<FileAnnotation>>();
        this.typesByHashCode = new HashMap<Integer, Set<FileAnnotation>>();
    }

    @SuppressWarnings(value={"Se"})
    private Object readResolve() {
        this.rebuildMappings();
        return this;
    }

    protected void rebuildMappings() {
        this.initialize();
        for (FileAnnotation annotation : this.getAnnotations()) {
            this.updateMappings(annotation);
        }
    }

    @SuppressWarnings(value={"SF_SWITCH_FALLTHROUGH"})
    private void updateMappings(FileAnnotation annotation) {
        this.annotationsByPriority.get((Object)annotation.getPriority()).add(annotation);
        if (StringUtils.isNotBlank((String)annotation.getCategory())) {
            this.addCategory(annotation);
        }
        if (StringUtils.isNotBlank((String)annotation.getType())) {
            this.addType(annotation);
        }
        if (this.hierarchy == Hierarchy.PROJECT) {
            this.addModule(annotation);
        }
        if (this.hierarchy == Hierarchy.PROJECT || this.hierarchy == Hierarchy.MODULE) {
            this.addPackage(annotation);
        }
        if (this.hierarchy == Hierarchy.PROJECT || this.hierarchy == Hierarchy.MODULE || this.hierarchy == Hierarchy.PACKAGE) {
            this.addFile(annotation);
        }
        if (this.hierarchy == Hierarchy.PROJECT || this.hierarchy == Hierarchy.MODULE || this.hierarchy == Hierarchy.PACKAGE || this.hierarchy == Hierarchy.FILE) {
            this.addAuthorName(annotation);
        }
    }

    private void addCategory(FileAnnotation annotation) {
        String category = annotation.getCategory();
        if (!this.annotationsByCategory.containsKey(category)) {
            HashSet container = new HashSet();
            this.annotationsByCategory.put(category, container);
            this.categoriesByHashCode.put(category.hashCode(), container);
        }
        this.annotationsByCategory.get(category).add(annotation);
    }

    private void addType(FileAnnotation annotation) {
        String type = annotation.getType();
        if (!this.annotationsByType.containsKey(type)) {
            HashSet container = new HashSet();
            this.annotationsByType.put(type, container);
            this.typesByHashCode.put(type.hashCode(), container);
        }
        this.annotationsByType.get(type).add(annotation);
    }

    private void addModule(FileAnnotation annotation) {
        String moduleName = annotation.getModuleName();
        if (!this.modulesByName.containsKey(moduleName)) {
            MavenModule module = new MavenModule(moduleName);
            this.modulesByName.put(moduleName, module);
            this.modulesByHashCode.put(moduleName.hashCode(), module);
        }
        this.modulesByName.get(moduleName).addAnnotation(annotation);
    }

    private void addPackage(FileAnnotation annotation) {
        String packageName = annotation.getPackageName();
        if (StringUtils.isBlank((String)packageName)) {
            packageName = "-";
        }
        if (!this.packagesByName.containsKey(packageName)) {
            JavaPackage javaPackage = new JavaPackage(packageName);
            this.packagesByName.put(packageName, javaPackage);
            this.packagesByHashCode.put(packageName.hashCode(), javaPackage);
        }
        this.packagesByName.get(packageName).addAnnotation(annotation);
    }

    private void addFile(FileAnnotation annotation) {
        String fileName = annotation.getFileName();
        if (!this.filesByName.containsKey(fileName)) {
            WorkspaceFile file = new WorkspaceFile(fileName);
            this.filesByName.put(fileName, file);
            this.filesByHashCode.put(file.getName().hashCode(), file);
        }
        this.filesByName.get(fileName).addAnnotation(annotation);
    }

    public final void addAnnotation(FileAnnotation annotation) {
        this.annotations.put(annotation.getKey(), annotation);
        this.updateMappings(annotation);
    }

    public final void addAnnotations(Collection<? extends FileAnnotation> newAnnotations) {
        for (FileAnnotation fileAnnotation : newAnnotations) {
            this.addAnnotation(fileAnnotation);
        }
    }

    private void addAuthorName(FileAnnotation annotation) {
        String key = annotation.getAuthor();
        if (!this.authorsByName.containsKey(key)) {
            Author container = new Author(key, annotation.getAuthorDetails(), annotation.getAuthorName(), annotation.getAuthorEmail(), Hierarchy.USER);
            this.authorsByName.put(key, container);
            this.authorsByHashCode.put(key.hashCode(), container);
        }
        this.authorsByName.get(key).addAnnotation(annotation);
    }

    public final void addAnnotations(FileAnnotation[] newAnnotations) {
        this.addAnnotations(Arrays.asList(newAnnotations));
    }

    public final SortedSet<FileAnnotation> getSortedAnnotations() {
        return ImmutableSortedSet.copyOf(this.annotations.values());
    }

    @Override
    public final Set<FileAnnotation> getAnnotations() {
        return ImmutableSet.copyOf(this.annotations.values());
    }

    @Override
    public final Set<FileAnnotation> getAnnotations(Priority priority) {
        return ImmutableSortedSet.copyOf((Collection)this.annotationsByPriority.get((Object)priority));
    }

    public final Set<FileAnnotation> getHighAnnotations() {
        return this.getAnnotations(Priority.HIGH);
    }

    public DefaultAnnotationContainer getHigh() {
        return new DefaultAnnotationContainer(Priority.HIGH.getLocalizedString(), this.getHighAnnotations());
    }

    public final Set<FileAnnotation> getNormalAnnotations() {
        return this.getAnnotations(Priority.NORMAL);
    }

    public DefaultAnnotationContainer getNormal() {
        return new DefaultAnnotationContainer(Priority.NORMAL.getLocalizedString(), this.getNormalAnnotations());
    }

    public final Set<FileAnnotation> getLowAnnotations() {
        return this.getAnnotations(Priority.LOW);
    }

    public DefaultAnnotationContainer getLow() {
        return new DefaultAnnotationContainer(Priority.LOW.getLocalizedString(), this.getLowAnnotations());
    }

    @Override
    public final Set<FileAnnotation> getAnnotations(String priority) {
        return this.getAnnotations(this.getPriority(priority));
    }

    private Priority getPriority(String priority) {
        return Priority.fromString(priority);
    }

    @Override
    public int getNumberOfAnnotations() {
        return this.annotations.size();
    }

    public int getNumberOfLowAnnotations() {
        return this.getLowAnnotations().size();
    }

    public int getNumberOfNormalAnnotations() {
        return this.getNormalAnnotations().size();
    }

    public int getNumberOfHighAnnotations() {
        return this.getHighAnnotations().size();
    }

    @Override
    public int getNumberOfAnnotations(Priority priority) {
        return this.annotationsByPriority.get((Object)priority).size();
    }

    @Override
    public final int getNumberOfAnnotations(String priority) {
        return this.getNumberOfAnnotations(this.getPriority(priority));
    }

    @Override
    public final boolean hasAnnotations() {
        return !this.hasNoAnnotations();
    }

    @Override
    public final boolean hasAnnotations(Priority priority) {
        return !this.hasNoAnnotations(priority);
    }

    @Override
    public final boolean hasAnnotations(String priority) {
        return !this.hasNoAnnotations(priority);
    }

    @Override
    public final boolean hasNoAnnotations() {
        return this.annotations.isEmpty();
    }

    @Override
    public final boolean hasNoAnnotations(Priority priority) {
        return this.annotationsByPriority.get((Object)priority).isEmpty();
    }

    @Override
    public final boolean hasNoAnnotations(String priority) {
        return this.hasNoAnnotations(this.getPriority(priority));
    }

    @Override
    public final FileAnnotation getAnnotation(long key) {
        FileAnnotation annotation = this.annotations.get(key);
        if (annotation != null) {
            return annotation;
        }
        throw new NoSuchElementException("Annotation not found: key=" + key);
    }

    @Override
    public final FileAnnotation getAnnotation(String key) {
        return this.getAnnotation(Long.parseLong(key));
    }

    public String getToolTip() {
        StringBuilder message = new StringBuilder();
        String separator = " - ";
        for (Priority priority : Priority.values()) {
            if (!this.hasAnnotations(priority)) continue;
            message.append(priority.getLocalizedString());
            message.append(':');
            message.append(this.getNumberOfAnnotations(priority));
            message.append(separator);
        }
        return StringUtils.removeEnd((String)message.toString(), (String)separator);
    }

    public final String getPackageCategoryName() {
        if (this.hasAnnotations()) {
            FileAnnotation annotation = this.getAnnotations().iterator().next();
            String fileName = annotation.getFileName();
            if (fileName.endsWith(".cs")) {
                return Messages.NamespaceDetail_header();
            }
            if (annotation.hasPackageName()) {
                if (annotation.hasOverridePackageCategoryName()) {
                    return annotation.getOverridePackageCategoryName();
                }
                return Messages.PackageDetail_header();
            }
            return Messages.PathDetail_header();
        }
        return Messages.PackageDetail_header();
    }

    public final String getPackageCategoryTitle() {
        if (this.hasAnnotations()) {
            FileAnnotation annotation = this.getAnnotations().iterator().next();
            String fileName = annotation.getFileName();
            if (fileName.endsWith(".cs")) {
                return Messages.NamespaceDetail_title();
            }
            if (annotation.hasPackageName()) {
                if (annotation.hasOverridePackageCategoryTitle()) {
                    return annotation.getOverridePackageCategoryTitle();
                }
                return Messages.PackageDetail_title();
            }
            return Messages.PathDetail_title();
        }
        return Messages.PackageDetail_title();
    }

    public Collection<MavenModule> getModules() {
        ArrayList<MavenModule> modules = new ArrayList<MavenModule>(this.modulesByName.values());
        Collections.sort(modules);
        return Collections.unmodifiableCollection(modules);
    }

    public boolean containsModule(String moduleName) {
        return this.modulesByName.containsKey(moduleName);
    }

    public MavenModule getModule(String moduleName) {
        if (this.modulesByName.containsKey(moduleName)) {
            return this.modulesByName.get(moduleName);
        }
        throw new NoSuchElementException("Module not found: " + moduleName);
    }

    public MavenModule getModule(int hashCode) {
        if (this.modulesByHashCode.containsKey(hashCode)) {
            return this.modulesByHashCode.get(hashCode);
        }
        throw new NoSuchElementException("Module by hashcode not found: " + hashCode);
    }

    public Collection<JavaPackage> getPackages() {
        ArrayList<JavaPackage> packages = new ArrayList<JavaPackage>(this.packagesByName.values());
        Collections.sort(packages);
        return Collections.unmodifiableCollection(packages);
    }

    public boolean containsPackage(String packageName) {
        return this.packagesByName.containsKey(packageName);
    }

    public JavaPackage getPackage(String packageName) {
        if (this.packagesByName.containsKey(packageName)) {
            return this.packagesByName.get(packageName);
        }
        throw new NoSuchElementException("Package not found: " + packageName);
    }

    public JavaPackage getPackage(int hashCode) {
        if (this.packagesByHashCode.containsKey(hashCode)) {
            return this.packagesByHashCode.get(hashCode);
        }
        throw new NoSuchElementException("Package by hashcode not found: " + hashCode);
    }

    public Collection<WorkspaceFile> getFiles() {
        ArrayList<WorkspaceFile> files = new ArrayList<WorkspaceFile>(this.filesByName.values());
        Collections.sort(files);
        return Collections.unmodifiableCollection(files);
    }

    public boolean containsFile(String fileName) {
        return this.filesByName.containsKey(fileName);
    }

    public WorkspaceFile getFile(String fileName) {
        if (this.filesByName.containsKey(fileName)) {
            return this.filesByName.get(fileName);
        }
        throw new NoSuchElementException("File not found: " + fileName);
    }

    public WorkspaceFile getFile(int hashCode) {
        if (this.filesByHashCode.containsKey(hashCode)) {
            return this.filesByHashCode.get(hashCode);
        }
        throw new NoSuchElementException("File by hashcode not found: " + hashCode);
    }

    public Collection<AnnotationContainer> getCategories() {
        ArrayList<AnnotationContainer> categories = new ArrayList<AnnotationContainer>();
        for (String category : this.annotationsByCategory.keySet()) {
            categories.add(this.getCategory(category));
        }
        Collections.sort(categories);
        return categories;
    }

    public boolean containsCategory(String category) {
        return this.annotationsByCategory.containsKey(category);
    }

    public DefaultAnnotationContainer getCategory(String category) {
        if (this.annotationsByCategory.containsKey(category)) {
            return new DefaultAnnotationContainer(category, (Collection<FileAnnotation>)this.annotationsByCategory.get(category));
        }
        throw new NoSuchElementException("Category not found: " + category);
    }

    public DefaultAnnotationContainer getCategory(int hashCode) {
        if (this.categoriesByHashCode.containsKey(hashCode)) {
            Set<FileAnnotation> container = this.categoriesByHashCode.get(hashCode);
            FileAnnotation fileAnnotation = container.iterator().next();
            return new DefaultAnnotationContainer(fileAnnotation.getCategory(), container);
        }
        throw new NoSuchElementException("Category by hashCode not found: " + hashCode);
    }

    public Collection<Author> getAuthors() {
        ArrayList<Author> authors = new ArrayList<Author>(this.authorsByName.values());
        Collections.sort(authors);
        return Collections.unmodifiableCollection(authors);
    }

    public Author getAuthor(String key) {
        if (this.authorsByName.containsKey(key)) {
            return this.authorsByName.get(key);
        }
        throw new NoSuchElementException("Author not found: " + key);
    }

    public Author getAuthor(int hashCode) {
        if (this.authorsByHashCode.containsKey(hashCode)) {
            return this.authorsByHashCode.get(hashCode);
        }
        throw new NoSuchElementException("Author hashcode not found: " + hashCode);
    }

    public Collection<AnnotationContainer> getTypes() {
        ArrayList<AnnotationContainer> types = new ArrayList<AnnotationContainer>();
        for (String type : this.annotationsByType.keySet()) {
            types.add(this.getType(type));
        }
        Collections.sort(types);
        return types;
    }

    public boolean containsType(String type) {
        return this.annotationsByType.containsKey(type);
    }

    public DefaultAnnotationContainer getType(String type) {
        if (this.annotationsByType.containsKey(type)) {
            return new DefaultAnnotationContainer(type, (Collection<FileAnnotation>)this.annotationsByType.get(type));
        }
        throw new NoSuchElementException("Type not found: " + type);
    }

    public DefaultAnnotationContainer getType(int hashCode) {
        if (this.typesByHashCode.containsKey(hashCode)) {
            Set<FileAnnotation> container = this.typesByHashCode.get(hashCode);
            FileAnnotation fileAnnotation = container.iterator().next();
            return new DefaultAnnotationContainer(fileAnnotation.getType(), container);
        }
        throw new NoSuchElementException("Type by hashcode not found: " + hashCode);
    }

    public Priority getHighPriority() {
        return Priority.HIGH;
    }

    public Priority getNormalPriority() {
        return Priority.NORMAL;
    }

    public Priority getLowPriority() {
        return Priority.LOW;
    }

    @Override
    public int compareTo(AnnotationContainer other) {
        return this.getName().compareTo(other.getName());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnnotationContainer other = (AnnotationContainer)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String escape(String text) {
        return StringEscapeUtils.escapeHtml4((String)text);
    }

    public String toString() {
        return this.getName() + ": " + this.getNumberOfAnnotations() + " annotations";
    }

    public static enum Hierarchy {
        PROJECT,
        MODULE,
        PACKAGE,
        FILE,
        USER;

    }
}

