/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.util.model;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import hudson.plugins.analysis.util.model.LineRange;
import hudson.util.RobustCollectionConverter;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;

public class LineRangeList
extends AbstractList<LineRange>
implements Serializable {
    private static final long serialVersionUID = -1123973098942984623L;
    private byte[] data;
    private int len;

    public LineRangeList() {
        this(16);
    }

    public LineRangeList(int capacity) {
        this.data = new byte[capacity];
        this.len = 0;
    }

    public LineRangeList(Collection<LineRange> copy) {
        this.data = new byte[copy.size() * 4];
        for (LineRange lr : copy) {
            this.add(lr);
        }
    }

    private void ensure(int n) {
        if (this.data.length < n) {
            byte[] buf = new byte[Math.max(n, this.data.length * 2)];
            System.arraycopy(this.data, 0, buf, 0, this.len);
            this.data = buf;
        }
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof LineRange) {
            LineRange lr = (LineRange)o;
            Cursor c = new Cursor();
            while (c.hasNext()) {
                if (!c.compare(lr)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public LineRange get(int index) {
        return new Cursor().skip(index).next();
    }

    @Override
    public int size() {
        return new Cursor().count();
    }

    @Override
    public LineRange set(int index, LineRange element) {
        return new Cursor().skip(index)._set(element);
    }

    @Override
    public void add(int index, LineRange element) {
        new Cursor().skip(index).add(element);
    }

    @Override
    public LineRange remove(int index) {
        return new Cursor().skip(index).delete();
    }

    @Override
    public boolean add(LineRange lr) {
        new Cursor(this.len).add(lr);
        return true;
    }

    @Override
    public void clear() {
        this.len = 0;
    }

    @Override
    public Iterator<LineRange> iterator() {
        return new Cursor();
    }

    @Override
    public ListIterator<LineRange> listIterator() {
        return new Cursor();
    }

    @Override
    public ListIterator<LineRange> listIterator(int index) {
        return new Cursor().skip(index);
    }

    public void trim() {
        if (this.len != this.data.length) {
            byte[] small = new byte[this.len];
            System.arraycopy(this.data, 0, small, 0, this.len);
            this.data = small;
        }
    }

    public static final class ConverterImpl
    extends RobustCollectionConverter {
        public ConverterImpl(XStream xs) {
            super(xs);
        }

        public boolean canConvert(Class type) {
            return type == LineRangeList.class;
        }

        protected void populateCollection(HierarchicalStreamReader reader, UnmarshallingContext context, Collection collection) {
            super.populateCollection(reader, context, collection);
            ((LineRangeList)collection).trim();
        }

        protected Object createCollection(Class type) {
            return new LineRangeList();
        }
    }

    private class Cursor
    implements ListIterator<LineRange> {
        int pos = 0;

        private Cursor(int pos) {
            this.pos = pos;
        }

        private Cursor() {
        }

        private void prev() {
            if (this.pos == 0) {
                throw new IllegalArgumentException();
            }
            do {
                --this.pos;
            } while (this.pos > 0 && (LineRangeList.this.data[this.pos - 1] & 0x80) == 0);
        }

        @Override
        public LineRange next() {
            int s = this.read();
            int d = this.read();
            return new LineRange(s, s + d);
        }

        @Override
        public LineRange previous() {
            this.prev();
            this.prev();
            return this.copy().next();
        }

        @Override
        public void remove() {
            this.prev();
            this.prev();
            this.delete();
        }

        @Override
        public boolean hasNext() {
            return this.pos < LineRangeList.this.len;
        }

        @Override
        public boolean hasPrevious() {
            return this.pos > 0;
        }

        private int read() {
            if (LineRangeList.this.len <= this.pos) {
                throw new IndexOutOfBoundsException();
            }
            int i = 0;
            int v = 0;
            do {
                v += (LineRangeList.this.data[this.pos] & 0x7F) << i++ * 7;
            } while ((LineRangeList.this.data[this.pos++] & 0x80) == 0);
            return v;
        }

        private void write(int i) {
            boolean last;
            do {
                last = i < 128;
                ((LineRangeList)LineRangeList.this).data[this.pos++] = (byte)(i & 0x7F | (last ? 128 : 0));
                i /= 128;
            } while (!last);
        }

        private void write(LineRange r) {
            this.write(r.getStart());
            this.write(r.getEnd() - r.getStart());
        }

        public boolean compare(LineRange lr) {
            int s = this.read();
            int d = this.read();
            return lr.getStart() == s && lr.getEnd() == s + d;
        }

        private Cursor skip(int n) {
            while (n > 0) {
                this.read();
                this.read();
                --n;
            }
            return this;
        }

        private int count() {
            int n = 0;
            while (this.pos < LineRangeList.this.len) {
                this.read();
                this.read();
                ++n;
            }
            return n;
        }

        @Override
        public int nextIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int previousIndex() {
            throw new UnsupportedOperationException();
        }

        public Cursor copy() {
            return new Cursor(this.pos);
        }

        private void adjust(int diff) {
            LineRangeList.this.ensure(LineRangeList.this.len + diff);
            if (diff > 0) {
                System.arraycopy(LineRangeList.this.data, this.pos, LineRangeList.this.data, this.pos + diff, LineRangeList.this.len - this.pos);
            } else {
                System.arraycopy(LineRangeList.this.data, this.pos - diff, LineRangeList.this.data, this.pos, LineRangeList.this.len - this.pos + diff);
            }
            LineRangeList.this.len = LineRangeList.this.len + diff;
        }

        public LineRange _set(LineRange v) {
            Cursor c = this.copy();
            LineRange old = c.next();
            int oldSize = c.pos - this.pos;
            int newSize = this.sizeOf(v);
            this.adjust(newSize - oldSize);
            this.write(v);
            return old;
        }

        @Override
        public void set(LineRange v) {
            this._set(v);
        }

        @Override
        public void add(LineRange v) {
            int newSize = this.sizeOf(v);
            this.adjust(newSize);
            this.write(v);
        }

        public LineRange delete() {
            Cursor c = this.copy();
            LineRange old = c.next();
            this.adjust(this.pos - c.pos);
            return old;
        }

        private int sizeOf(LineRange v) {
            return this.sizeOf(v.getStart()) + this.sizeOf(v.getEnd() - v.getStart());
        }

        private int sizeOf(int i) {
            int n = 0;
            do {
                ++n;
            } while ((i /= 128) > 0);
            return n;
        }
    }
}

