/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.util.model;

import hudson.plugins.analysis.util.model.AnnotationContainer;
import org.apache.commons.lang.StringUtils;

public class WorkspaceFile
extends AnnotationContainer {
    private static final String UNIX_SLASH = "/";
    private static final long serialVersionUID = 601361940925156719L;
    private String name;

    public WorkspaceFile(String fileName) {
        super(fileName.replace('\\', '/'), AnnotationContainer.Hierarchy.FILE);
    }

    public String getShortName() {
        if (this.getName().contains(UNIX_SLASH)) {
            return StringUtils.substringAfterLast((String)this.getName(), (String)UNIX_SLASH);
        }
        return this.getName();
    }

    private Object readResolve() {
        this.setHierarchy(AnnotationContainer.Hierarchy.FILE);
        this.rebuildMappings();
        if (this.name != null) {
            this.setName(this.name);
        }
        return this;
    }

    public String getTempName() {
        return Integer.toHexString(this.getName().hashCode()) + ".tmp";
    }

    @Override
    public int compareTo(AnnotationContainer other) {
        if (other instanceof WorkspaceFile) {
            return this.getShortName().compareTo(((WorkspaceFile)other).getShortName());
        }
        return super.compareTo(other);
    }
}

