/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.views;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import hudson.markup.MarkupFormatter;
import hudson.markup.RawHtmlMarkupFormatter;
import hudson.model.AbstractBuild;
import hudson.model.ModelObject;
import hudson.model.Run;
import hudson.plugins.analysis.core.GlobalSettings;
import hudson.plugins.analysis.util.model.AnnotationContainer;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.analysis.views.DetailFactory;
import java.io.IOException;
import java.util.Collection;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@BridgeMethodsAdded
public abstract class AbstractAnnotationsDetail
extends AnnotationContainer
implements ModelObject {
    private static final long serialVersionUID = 1750266351592937774L;
    private final Run<?, ?> owner;
    private final String defaultEncoding;
    private final DetailFactory detailFactory;
    private final MarkupFormatter sanitizer = new RawHtmlMarkupFormatter(true);

    public AbstractAnnotationsDetail(Run<?, ?> owner, DetailFactory detailFactory, Collection<FileAnnotation> annotations, String defaultEncoding, String name, AnnotationContainer.Hierarchy hierarchy) {
        super(name, hierarchy);
        this.owner = owner;
        this.detailFactory = detailFactory;
        this.defaultEncoding = defaultEncoding;
        this.addAnnotations(annotations);
    }

    public boolean useAuthors() {
        return GlobalSettings.instance().getNoAuthors() == false;
    }

    public String sanitize(String html) {
        try {
            return this.sanitizer.translate(html);
        }
        catch (IOException e) {
            return "";
        }
    }

    public String getBuildUrl(int buildNumber) {
        int backward = StringUtils.countMatches((CharSequence)this.getUrl(), (CharSequence)"/");
        return StringUtils.repeat((String)"../", (int)(backward + 2)) + buildNumber;
    }

    public int getAge(int buildNumber) {
        return this.getOwner().getNumber() - buildNumber + 1;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public String getHeader() {
        return this.getName() + " - " + this.getDisplayName();
    }

    @WithBridgeMethods(value={AbstractBuild.class}, adapterMethod="getAbstractBuild")
    public final Run<?, ?> getOwner() {
        return this.owner;
    }

    @Deprecated
    private final Object getAbstractBuild(Run owner, Class targetClass) {
        return owner instanceof AbstractBuild ? (AbstractBuild)owner : null;
    }

    public final boolean isCurrent() {
        return this.owner.getParent().getLastBuild().number == this.owner.number;
    }

    public String getLocalizedPriority(String priorityName) {
        return Priority.fromString(priorityName).getLongLocalizedString();
    }

    public Object getDynamic(String link, StaplerRequest request, StaplerResponse response) {
        try {
            return this.detailFactory.createDetails(link, this.owner, this.getContainer(), this.defaultEncoding, this.getDisplayName());
        }
        catch (NoSuchElementException exception) {
            try {
                response.sendRedirect2("../");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this;
        }
    }

    public Priority[] getPriorities() {
        return Priority.values();
    }

    @Deprecated
    public AbstractAnnotationsDetail(AbstractBuild<?, ?> owner, DetailFactory detailFactory, Collection<FileAnnotation> annotations, String defaultEncoding, String name, AnnotationContainer.Hierarchy hierarchy) {
        this((Run<?, ?>)owner, detailFactory, annotations, defaultEncoding, name, hierarchy);
    }

    public String getUrl() {
        return "";
    }
}

