/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.views;

import hudson.model.Run;
import hudson.model.User;
import hudson.plugins.analysis.util.model.Author;
import hudson.plugins.analysis.views.AbstractAnnotationsDetail;
import hudson.plugins.analysis.views.DetailFactory;
import java.util.Collections;

public class AuthorDetail
extends AbstractAnnotationsDetail {
    private static final long serialVersionUID = -5907296989102083012L;
    private final String authorName;
    private final String authorEmail;
    private transient boolean userAttempted;
    private transient User user;

    public AuthorDetail(Run<?, ?> owner, DetailFactory detailFactory, Author authorContainer, String defaultEncoding, String header) {
        super(owner, detailFactory, authorContainer.getAnnotations(), defaultEncoding, header, authorContainer.getHierarchy());
        this.authorName = authorContainer.getFullName();
        this.authorEmail = authorContainer.getEmail();
    }

    public String getDisplayName() {
        return this.authorName;
    }

    public User getUser() {
        if (this.userAttempted) {
            return this.user;
        }
        this.userAttempted = true;
        this.user = User.get((String)this.authorEmail, (boolean)false, Collections.emptyMap());
        if (this.user == null) {
            this.user = User.get((String)this.authorName, (boolean)false, Collections.emptyMap());
            if (this.user == null) {
                this.user = User.getUnknown();
            }
        }
        return this.user;
    }
}

