/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.views;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import hudson.console.ConsoleNote;
import hudson.model.AbstractBuild;
import hudson.model.ModelObject;
import hudson.model.Run;
import hudson.plugins.analysis.Messages;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;

@BridgeMethodsAdded
public class ConsoleDetail
implements ModelObject {
    public static final String CONSOLE_LOG_FILENAME = "Console Log";
    private final Run<?, ?> owner;
    private String sourceCode = "";
    private final int from;
    private final int to;
    private final int end;
    private final int start;

    public ConsoleDetail(Run<?, ?> owner, int from, int to) {
        this.owner = owner;
        this.from = from;
        this.to = to;
        this.start = Math.max(0, from - 10);
        this.end = to + 10;
        this.readConsole();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readConsole() {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.owner.getLogFile()), "UTF8"));
            StringBuilder console = new StringBuilder(1024);
            console.append("<table>\n");
            String line = reader.readLine();
            for (int lineCount = 0; line != null && lineCount <= this.end; ++lineCount) {
                if (lineCount >= this.start) {
                    console.append("<tr><td ");
                    if (lineCount >= this.from && lineCount <= this.to) {
                        console.append("style=\"background-color:#FCAF3E\"");
                    }
                    console.append(">\n");
                    console.append(StringEscapeUtils.escapeHtml((String)line));
                    console.append("</td></tr>\n");
                }
                line = reader.readLine();
            }
            console.append("</table>\n");
            this.sourceCode = ConsoleNote.removeNotes((String)console.toString());
        }
        catch (IOException exception) {
            try {
                this.sourceCode = this.sourceCode + exception.getLocalizedMessage();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)reader);
        }
        IOUtils.closeQuietly((Reader)reader);
    }

    public String getDisplayName() {
        return Messages.ConsoleLog_Title(this.start, this.end);
    }

    public String getFileName() {
        return this.getDisplayName();
    }

    @WithBridgeMethods(value={AbstractBuild.class}, adapterMethod="getAbstractBuild")
    public Run<?, ?> getOwner() {
        return this.owner;
    }

    @Deprecated
    private final Object getAbstractBuild(Run owner, Class targetClass) {
        return owner instanceof AbstractBuild ? (AbstractBuild)owner : null;
    }

    public String getSourceCode() {
        return this.sourceCode;
    }

    @Deprecated
    public ConsoleDetail(AbstractBuild<?, ?> owner, int from, int to) {
        this((Run<?, ?>)owner, from, to);
    }
}

