/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.views;

import com.google.common.collect.Maps;
import hudson.model.AbstractBuild;
import hudson.model.Item;
import hudson.model.Run;
import hudson.plugins.analysis.Messages;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.ResultAction;
import hudson.plugins.analysis.util.Compatibility;
import hudson.plugins.analysis.util.model.AnnotationContainer;
import hudson.plugins.analysis.util.model.AnnotationsLabelProvider;
import hudson.plugins.analysis.util.model.DefaultAnnotationContainer;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.analysis.util.model.LineRange;
import hudson.plugins.analysis.views.AbstractAnnotationsDetail;
import hudson.plugins.analysis.views.AttributeDetail;
import hudson.plugins.analysis.views.AuthorDetail;
import hudson.plugins.analysis.views.ConsoleDetail;
import hudson.plugins.analysis.views.ErrorDetail;
import hudson.plugins.analysis.views.FileDetail;
import hudson.plugins.analysis.views.FixedWarningsDetail;
import hudson.plugins.analysis.views.ModuleDetail;
import hudson.plugins.analysis.views.NewWarningsDetail;
import hudson.plugins.analysis.views.PackageDetail;
import hudson.plugins.analysis.views.PriorityDetailFactory;
import hudson.plugins.analysis.views.SourceDetail;
import hudson.plugins.analysis.views.TabDetail;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class DetailFactory {
    private static final DetailFactory DEFAULT_DETAIL_BUILDER = new DetailFactory();
    private static Map<Class<? extends ResultAction<? extends BuildResult>>, DetailFactory> factories = Maps.newHashMap();

    public static DetailFactory create(Class<? extends ResultAction<? extends BuildResult>> actionType) {
        if (factories.containsKey(actionType)) {
            return factories.get(actionType);
        }
        return DEFAULT_DETAIL_BUILDER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDetailBuilder(Class<? extends ResultAction<? extends BuildResult>> actionType, DetailFactory detailBuilder) {
        Map<Class<? extends ResultAction<? extends BuildResult>>, DetailFactory> map = factories;
        synchronized (map) {
            factories.put(actionType, detailBuilder);
        }
    }

    public Object createTrendDetails(String link, @Nonnull Run<?, ?> owner, AnnotationContainer container, Collection<FileAnnotation> fixedAnnotations, Collection<FileAnnotation> newAnnotations, Collection<String> errors, String defaultEncoding, String displayName) {
        AbstractAnnotationsDetail detail;
        if (owner instanceof AbstractBuild && Compatibility.isOverridden(DetailFactory.class, this.getClass(), "createTrendDetails", String.class, AbstractBuild.class, AnnotationContainer.class, Collection.class, Collection.class, Collection.class, String.class, String.class)) {
            return this.createTrendDetails(link, (AbstractBuild)owner, container, fixedAnnotations, newAnnotations, errors, defaultEncoding, displayName);
        }
        if ("fixed".equals(link)) {
            detail = this.createFixedWarningsDetail(owner, fixedAnnotations, defaultEncoding, displayName);
        } else if ("new".equals(link)) {
            detail = new NewWarningsDetail(owner, this, newAnnotations, defaultEncoding, displayName);
        } else {
            if ("error".equals(link)) {
                return new ErrorDetail(owner, errors);
            }
            if (link.startsWith("tab.new")) {
                detail = this.createTabDetail(owner, newAnnotations, this.createGenericTabUrl(link), defaultEncoding);
            } else if (link.startsWith("tab.fixed")) {
                detail = this.createTabDetail(owner, fixedAnnotations, this.createGenericTabUrl(link), defaultEncoding);
            } else {
                return this.createDetails(link, owner, container, defaultEncoding, displayName);
            }
        }
        this.attachLabelProvider(detail);
        return detail;
    }

    protected void attachLabelProvider(AnnotationContainer container) {
        container.setLabelProvider(new AnnotationsLabelProvider(container.getPackageCategoryTitle()));
    }

    public Object createDetails(String link, @Nonnull Run<?, ?> owner, AnnotationContainer container, String defaultEncoding, String displayName) {
        if (owner instanceof AbstractBuild && Compatibility.isOverridden(DetailFactory.class, this.getClass(), "createDetails", String.class, AbstractBuild.class, AnnotationContainer.class, String.class, String.class)) {
            return this.createDetails(link, (AbstractBuild)owner, container, defaultEncoding, displayName);
        }
        PriorityDetailFactory factory = new PriorityDetailFactory(this);
        AbstractAnnotationsDetail detail = null;
        if (factory.isPriority(link)) {
            detail = factory.create(link, owner, container, defaultEncoding, displayName);
        } else if (link.startsWith("module.")) {
            detail = new ModuleDetail(owner, this, container.getModule(this.createHashCode(link, "module.")), defaultEncoding, displayName);
        } else if (link.startsWith("package.")) {
            detail = new PackageDetail(owner, this, container.getPackage(this.createHashCode(link, "package.")), defaultEncoding, displayName);
        } else if (link.startsWith("file.")) {
            detail = new FileDetail(owner, this, container.getFile(this.createHashCode(link, "file.")), defaultEncoding, displayName);
        } else if (link.startsWith("tab.")) {
            detail = this.createTabDetail(owner, container.getAnnotations(), this.createGenericTabUrl(link), defaultEncoding);
        } else {
            if (link.startsWith("source.")) {
                owner.checkPermission(Item.WORKSPACE);
                FileAnnotation annotation = container.getAnnotation(StringUtils.substringAfter((String)link, (String)"source."));
                if (annotation.isInConsoleLog()) {
                    LineRange lines = annotation.getLineRanges().iterator().next();
                    return new ConsoleDetail(owner, lines.getStart(), lines.getEnd());
                }
                return new SourceDetail(owner, annotation, defaultEncoding);
            }
            if (link.startsWith("category.")) {
                DefaultAnnotationContainer category = container.getCategory(this.createHashCode(link, "category."));
                detail = this.createAttributeDetail(owner, category, displayName, Messages.CategoryDetail_header(), defaultEncoding);
            } else if (link.startsWith("type.")) {
                DefaultAnnotationContainer type = container.getType(this.createHashCode(link, "type."));
                detail = this.createAttributeDetail(owner, type, displayName, Messages.TypeDetail_header(), defaultEncoding);
            } else if (link.startsWith("author.")) {
                detail = new AuthorDetail(owner, this, container.getAuthor(this.createHashCode(link, "author.")), defaultEncoding, displayName);
            }
        }
        if (detail != null) {
            this.attachLabelProvider(detail);
        }
        return detail;
    }

    protected AttributeDetail createAttributeDetail(@Nonnull Run<?, ?> owner, DefaultAnnotationContainer annotations, String displayName, String header, String defaultEncoding) {
        if (owner instanceof AbstractBuild && Compatibility.isOverridden(DetailFactory.class, this.getClass(), "createAttributeDetail", AbstractBuild.class, DefaultAnnotationContainer.class, String.class, String.class, String.class)) {
            return this.createAttributeDetail((AbstractBuild)owner, annotations, displayName, header, defaultEncoding);
        }
        return new AttributeDetail(owner, this, annotations.getAnnotations(), defaultEncoding, displayName, header + " " + annotations.getName());
    }

    protected TabDetail createTabDetail(@Nonnull Run<?, ?> owner, Collection<FileAnnotation> annotations, String url, String defaultEncoding) {
        if (owner instanceof AbstractBuild && Compatibility.isOverridden(DetailFactory.class, this.getClass(), "createTabDetail", AbstractBuild.class, Collection.class, String.class, String.class)) {
            return this.createTabDetail((AbstractBuild)owner, annotations, url, defaultEncoding);
        }
        return new TabDetail(owner, this, annotations, url, defaultEncoding);
    }

    protected FixedWarningsDetail createFixedWarningsDetail(@Nonnull Run<?, ?> owner, Collection<FileAnnotation> fixedAnnotations, String defaultEncoding, String displayName) {
        if (owner instanceof AbstractBuild && Compatibility.isOverridden(DetailFactory.class, this.getClass(), "createFixedWarningsDetail", AbstractBuild.class, Collection.class, String.class, String.class)) {
            return this.createFixedWarningsDetail((AbstractBuild)owner, fixedAnnotations, defaultEncoding, displayName);
        }
        return new FixedWarningsDetail(owner, this, fixedAnnotations, defaultEncoding, displayName);
    }

    private String createGenericTabUrl(String link) {
        return StringUtils.substringAfter((String)link, (String)"tab.") + ".jelly";
    }

    private int createHashCode(String link, String prefix) {
        try {
            return Integer.parseInt(StringUtils.substringAfter((String)link, (String)prefix));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    @Deprecated
    protected TabDetail createTabDetail(AbstractBuild<?, ?> owner, Collection<FileAnnotation> annotations, String url, String defaultEncoding) {
        return new TabDetail(owner, this, annotations, url, defaultEncoding);
    }

    @Deprecated
    protected FixedWarningsDetail createFixedWarningsDetail(AbstractBuild<?, ?> owner, Collection<FileAnnotation> fixedAnnotations, String defaultEncoding, String displayName) {
        return new FixedWarningsDetail(owner, this, fixedAnnotations, defaultEncoding, displayName);
    }

    @Deprecated
    protected AttributeDetail createAttributeDetail(AbstractBuild<?, ?> owner, DefaultAnnotationContainer annotations, String displayName, String header, String defaultEncoding) {
        return new AttributeDetail(owner, this, annotations.getAnnotations(), defaultEncoding, displayName, header + " " + annotations.getName());
    }

    @Deprecated
    public Object createTrendDetails(String link, AbstractBuild<?, ?> owner, AnnotationContainer container, Collection<FileAnnotation> fixedAnnotations, Collection<FileAnnotation> newAnnotations, Collection<String> errors, String defaultEncoding, String displayName) {
        AbstractAnnotationsDetail detail;
        if ("fixed".equals(link)) {
            detail = this.createFixedWarningsDetail(owner, fixedAnnotations, defaultEncoding, displayName);
        } else if ("new".equals(link)) {
            detail = new NewWarningsDetail(owner, this, newAnnotations, defaultEncoding, displayName);
        } else {
            if ("error".equals(link)) {
                return new ErrorDetail(owner, errors);
            }
            if (link.startsWith("tab.new")) {
                detail = this.createTabDetail(owner, newAnnotations, this.createGenericTabUrl(link), defaultEncoding);
            } else if (link.startsWith("tab.fixed")) {
                detail = this.createTabDetail(owner, fixedAnnotations, this.createGenericTabUrl(link), defaultEncoding);
            } else {
                return this.createDetails(link, owner, container, defaultEncoding, displayName);
            }
        }
        this.attachLabelProvider(detail);
        return detail;
    }

    @Deprecated
    public Object createDetails(String link, AbstractBuild<?, ?> owner, AnnotationContainer container, String defaultEncoding, String displayName) {
        PriorityDetailFactory factory = new PriorityDetailFactory(this);
        AbstractAnnotationsDetail detail = null;
        if (factory.isPriority(link)) {
            detail = factory.create(link, owner, container, defaultEncoding, displayName);
        } else if (link.startsWith("module.")) {
            detail = new ModuleDetail(owner, this, container.getModule(this.createHashCode(link, "module.")), defaultEncoding, displayName);
        } else if (link.startsWith("package.")) {
            detail = new PackageDetail(owner, this, container.getPackage(this.createHashCode(link, "package.")), defaultEncoding, displayName);
        } else if (link.startsWith("file.")) {
            detail = new FileDetail(owner, this, container.getFile(this.createHashCode(link, "file.")), defaultEncoding, displayName);
        } else if (link.startsWith("tab.")) {
            detail = this.createTabDetail(owner, container.getAnnotations(), this.createGenericTabUrl(link), defaultEncoding);
        } else {
            if (link.startsWith("source.")) {
                owner.checkPermission(Item.WORKSPACE);
                FileAnnotation annotation = container.getAnnotation(StringUtils.substringAfter((String)link, (String)"source."));
                if (annotation.isInConsoleLog()) {
                    LineRange lines = annotation.getLineRanges().iterator().next();
                    return new ConsoleDetail(owner, lines.getStart(), lines.getEnd());
                }
                return new SourceDetail(owner, annotation, defaultEncoding);
            }
            if (link.startsWith("category.")) {
                DefaultAnnotationContainer category = container.getCategory(this.createHashCode(link, "category."));
                detail = this.createAttributeDetail(owner, category, displayName, Messages.CategoryDetail_header(), defaultEncoding);
            } else if (link.startsWith("type.")) {
                DefaultAnnotationContainer type = container.getType(this.createHashCode(link, "type."));
                detail = this.createAttributeDetail(owner, type, displayName, Messages.TypeDetail_header(), defaultEncoding);
            } else if (link.startsWith("author.")) {
                detail = new AuthorDetail((Run<?, ?>)owner, this, container.getAuthor(this.createHashCode(link, "author.")), defaultEncoding, displayName);
            }
        }
        if (detail != null) {
            this.attachLabelProvider(detail);
        }
        return detail;
    }
}

