/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.views;

import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.plugins.analysis.util.Compatibility;
import hudson.plugins.analysis.util.model.AnnotationContainer;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.analysis.views.DetailFactory;
import hudson.plugins.analysis.views.PrioritiesDetail;
import javax.annotation.Nonnull;

public class PriorityDetailFactory {
    private final DetailFactory detailFactory;

    public PriorityDetailFactory(DetailFactory detailFactory) {
        this.detailFactory = detailFactory;
    }

    public boolean isPriority(String value) {
        for (Priority priority : Priority.values()) {
            if (!priority.toString().equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }

    public PrioritiesDetail create(String priority, @Nonnull Run<?, ?> owner, AnnotationContainer container, String defaultEncoding, String header) {
        if (owner instanceof AbstractBuild && Compatibility.isOverridden(PriorityDetailFactory.class, this.getClass(), "create", String.class, AbstractBuild.class, AnnotationContainer.class, String.class, String.class)) {
            return this.create(priority, (AbstractBuild)owner, container, defaultEncoding, header);
        }
        if (Priority.HIGH.toString().equalsIgnoreCase(priority)) {
            return this.createPrioritiesDetail(Priority.HIGH, owner, container, defaultEncoding, header);
        }
        if (Priority.NORMAL.toString().equalsIgnoreCase(priority)) {
            return this.createPrioritiesDetail(Priority.NORMAL, owner, container, defaultEncoding, header);
        }
        if (Priority.LOW.toString().equalsIgnoreCase(priority)) {
            return this.createPrioritiesDetail(Priority.LOW, owner, container, defaultEncoding, header);
        }
        throw new IllegalArgumentException("Wrong priority provided: " + priority);
    }

    protected PrioritiesDetail createPrioritiesDetail(Priority priority, @Nonnull Run<?, ?> owner, AnnotationContainer container, String defaultEncoding, String header) {
        if (owner instanceof AbstractBuild && Compatibility.isOverridden(PriorityDetailFactory.class, this.getClass(), "createPrioritiesDetail", Priority.class, AbstractBuild.class, AnnotationContainer.class, String.class, String.class)) {
            return this.createPrioritiesDetail(priority, (AbstractBuild)owner, container, defaultEncoding, header);
        }
        return new PrioritiesDetail(owner, this.detailFactory, container.getAnnotations(priority), priority, defaultEncoding, header);
    }

    @Deprecated
    public PrioritiesDetail create(String priority, AbstractBuild<?, ?> owner, AnnotationContainer container, String defaultEncoding, String header) {
        return this.create(priority, (Run<?, ?>)owner, container, defaultEncoding, header);
    }

    @Deprecated
    protected PrioritiesDetail createPrioritiesDetail(Priority priority, AbstractBuild<?, ?> owner, AnnotationContainer container, String defaultEncoding, String header) {
        return this.createPrioritiesDetail(priority, (Run<?, ?>)owner, container, defaultEncoding, header);
    }
}

