/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.views;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Job;
import hudson.plugins.analysis.Messages;
import hudson.plugins.analysis.core.AbstractProjectAction;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.util.HtmlPrinter;
import hudson.plugins.analysis.util.model.Priority;
import hudson.views.ListViewColumn;

public abstract class WarningsCountColumn<T extends AbstractProjectAction<?>>
extends ListViewColumn {
    private static final String NO_RESULT = "-";

    public String getUrl(Job<?, ?> project) {
        T action = this.getProjectAction(project);
        if (action == null) {
            return null;
        }
        return project.getUrl() + ((AbstractProjectAction)action).getUrlName();
    }

    public boolean hasUrl(Job<?, ?> project) {
        String numberOfAnnotations = this.getNumberOfAnnotations(project);
        return !NO_RESULT.equals(numberOfAnnotations) && !"0".equals(numberOfAnnotations);
    }

    public String getNumberOfAnnotations(Job<?, ?> project) {
        T action = this.getProjectAction(project);
        if (action != null && ((AbstractProjectAction)action).hasValidResults()) {
            return String.valueOf(this.getResult(action).getNumberOfAnnotations());
        }
        return NO_RESULT;
    }

    private T getProjectAction(Job<?, ?> project) {
        return (T)((AbstractProjectAction)project.getAction(this.getProjectAction()));
    }

    @SuppressFBWarnings(value={"NP"})
    private BuildResult getResult(T action) {
        return ((AbstractProjectAction)action).getLastAction().getResult();
    }

    protected abstract Class<T> getProjectAction();

    public String getDetails(Job<?, ?> project) {
        BuildResult result;
        HtmlPrinter printer = new HtmlPrinter();
        printer.append("<table>");
        T action = this.getProjectAction(project);
        if (action != null && ((AbstractProjectAction)action).hasValidResults()) {
            result = this.getResult(action);
            if (result.isSuccessfulTouched()) {
                printer.append(printer.line(Messages.ResultAction_Status() + result.getResultIcon()));
            }
            if (result.getNumberOfNewWarnings() > 0) {
                this.print(printer, Messages.NewWarningsDetail_Name(), result.getNumberOfNewWarnings());
            }
        } else {
            return Messages.Column_NoResults();
        }
        this.print(printer, Priority.HIGH, result.getNumberOfHighPriorityWarnings());
        this.print(printer, Priority.NORMAL, result.getNumberOfNormalPriorityWarnings());
        this.print(printer, Priority.LOW, result.getNumberOfLowPriorityWarnings());
        printer.append("</table>");
        return printer.toString();
    }

    private void print(HtmlPrinter printer, Priority priority, int count) {
        this.print(printer, priority.getLocalizedString(), count);
    }

    private void print(HtmlPrinter printer, String label, int count) {
        printer.append(printer.line(label + ": " + count));
    }
}

