/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.util.EventListener;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import javax.jmdns.ServiceTypeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListenerStatus<T extends EventListener> {
    public static final boolean SYNCHONEOUS = true;
    public static final boolean ASYNCHONEOUS = false;
    private final T _listener;
    private final boolean _synch;

    public ListenerStatus(T listener, boolean synch) {
        this._listener = listener;
        this._synch = synch;
    }

    public T getListener() {
        return this._listener;
    }

    public boolean isSynchronous() {
        return this._synch;
    }

    public int hashCode() {
        return this.getListener().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ListenerStatus && this.getListener().equals(((ListenerStatus)obj).getListener());
    }

    public String toString() {
        return "[Status for " + this.getListener().toString() + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ServiceTypeListenerStatus
    extends ListenerStatus<ServiceTypeListener> {
        private static Logger logger = Logger.getLogger(ServiceTypeListenerStatus.class.getName());
        private final ConcurrentMap<String, String> _addedTypes = new ConcurrentHashMap<String, String>(32);

        public ServiceTypeListenerStatus(ServiceTypeListener listener, boolean synch) {
            super(listener, synch);
        }

        void serviceTypeAdded(ServiceEvent event) {
            if (null == this._addedTypes.putIfAbsent(event.getType(), event.getType())) {
                ((ServiceTypeListener)this.getListener()).serviceTypeAdded(event);
            } else {
                logger.finest("Service Type Added called for a service type already added: " + event);
            }
        }

        void subTypeForServiceTypeAdded(ServiceEvent event) {
            if (null == this._addedTypes.putIfAbsent(event.getType(), event.getType())) {
                ((ServiceTypeListener)this.getListener()).subTypeForServiceTypeAdded(event);
            } else {
                logger.finest("Service Sub Type Added called for a service sub type already added: " + event);
            }
        }

        @Override
        public String toString() {
            StringBuilder aLog = new StringBuilder(2048);
            aLog.append("[Status for ");
            aLog.append(((ServiceTypeListener)this.getListener()).toString());
            if (this._addedTypes.isEmpty()) {
                aLog.append(" no type event ");
            } else {
                aLog.append(" (");
                for (String type : this._addedTypes.keySet()) {
                    aLog.append(type + ", ");
                }
                aLog.append(") ");
            }
            aLog.append("]");
            return aLog.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ServiceListenerStatus
    extends ListenerStatus<ServiceListener> {
        private static Logger logger = Logger.getLogger(ServiceListenerStatus.class.getName());
        private final ConcurrentMap<String, ServiceInfo> _addedServices = new ConcurrentHashMap<String, ServiceInfo>(32);

        public ServiceListenerStatus(ServiceListener listener, boolean synch) {
            super(listener, synch);
        }

        void serviceAdded(ServiceEvent event) {
            String qualifiedName = event.getName() + "." + event.getType();
            if (null == this._addedServices.putIfAbsent(qualifiedName, event.getInfo().clone())) {
                ((ServiceListener)this.getListener()).serviceAdded(event);
                ServiceInfo info = event.getInfo();
                if (info != null && info.hasData()) {
                    ((ServiceListener)this.getListener()).serviceResolved(event);
                }
            } else {
                logger.finer("Service Added called for a service already added: " + event);
            }
        }

        void serviceRemoved(ServiceEvent event) {
            String qualifiedName = event.getName() + "." + event.getType();
            if (this._addedServices.remove(qualifiedName, this._addedServices.get(qualifiedName))) {
                ((ServiceListener)this.getListener()).serviceRemoved(event);
            } else {
                logger.finer("Service Removed called for a service already removed: " + event);
            }
        }

        synchronized void serviceResolved(ServiceEvent event) {
            ServiceInfo info = event.getInfo();
            if (info != null && info.hasData()) {
                String qualifiedName = event.getName() + "." + event.getType();
                ServiceInfo previousServiceInfo = (ServiceInfo)this._addedServices.get(qualifiedName);
                if (!ServiceListenerStatus._sameInfo(info, previousServiceInfo)) {
                    if (null == previousServiceInfo) {
                        if (null == this._addedServices.putIfAbsent(qualifiedName, info.clone())) {
                            ((ServiceListener)this.getListener()).serviceResolved(event);
                        }
                    } else if (this._addedServices.replace(qualifiedName, previousServiceInfo, info.clone())) {
                        ((ServiceListener)this.getListener()).serviceResolved(event);
                    }
                } else {
                    logger.finer("Service Resolved called for a service already resolved: " + event);
                }
            } else {
                logger.warning("Service Resolved called for an unresolved event: " + event);
            }
        }

        private static final boolean _sameInfo(ServiceInfo info, ServiceInfo lastInfo) {
            byte[] lastText;
            if (info == null) {
                return false;
            }
            if (lastInfo == null) {
                return false;
            }
            if (!info.equals(lastInfo)) {
                return false;
            }
            byte[] text = info.getTextBytes();
            if (text.length != (lastText = lastInfo.getTextBytes()).length) {
                return false;
            }
            for (int i = 0; i < text.length; ++i) {
                if (text[i] == lastText[i]) continue;
                return false;
            }
            return true;
        }

        @Override
        public String toString() {
            StringBuilder aLog = new StringBuilder(2048);
            aLog.append("[Status for ");
            aLog.append(((ServiceListener)this.getListener()).toString());
            if (this._addedServices.isEmpty()) {
                aLog.append(" no type event ");
            } else {
                aLog.append(" (");
                for (String service : this._addedServices.keySet()) {
                    aLog.append(service + ", ");
                }
                aLog.append(") ");
            }
            aLog.append("]");
            return aLog.toString();
        }
    }
}

