/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.owasp.html.Strings;

class CssGrammar {
    private static final Pattern CSS_TOKEN;

    CssGrammar() {
    }

    static Matcher lex(String css) {
        return CSS_TOKEN.matcher(css);
    }

    static void asPropertyGroup(String css, PropertyHandler handler) {
        Matcher m = CssGrammar.lex(css);
        block5: while (m.find()) {
            if (m.start(1) < 0 || css.charAt(m.start(1)) == '#') continue;
            String name = m.group(0);
            while (m.find()) {
                if (m.start(1) >= 0) {
                    if (css.charAt(m.start(1)) == '#') continue block5;
                    name = m.group(0);
                    continue;
                }
                if (m.start(2) >= 0) continue block5;
                if (m.start(3) + 1 != m.end(3)) continue;
                if (':' != css.charAt(m.start(3))) continue block5;
            }
            handler.startProperty(Strings.toLowerCase(CssGrammar.cssContent(name)));
            block7: while (m.find()) {
                if (m.start(1) >= 0) {
                    handler.identifierOrHash(m.group());
                    continue;
                }
                if (m.start(2) >= 0) {
                    handler.quantity(m.group());
                    continue;
                }
                if (m.start(3) < 0) continue;
                String token = m.group(0);
                switch (token.charAt(0)) {
                    case '\"': 
                    case '\'': {
                        handler.quotedString(token);
                        continue block7;
                    }
                    case 'U': 
                    case 'u': {
                        handler.url(token);
                        continue block7;
                    }
                    case ':': 
                    case ';': 
                    case '{': 
                    case '}': {
                        break block7;
                    }
                    default: {
                        handler.punctuation(token);
                        continue block7;
                    }
                }
            }
            handler.endProperty();
        }
    }

    static String cssContent(String token) {
        int esc;
        char ch0;
        int n = token.length();
        int pos = 0;
        StringBuilder sb = null;
        if (n >= 2 && ((ch0 = token.charAt(0)) == '\"' || ch0 == '\'') && ch0 == token.charAt(n - 1)) {
            pos = 1;
            sb = new StringBuilder(--n);
        }
        while ((esc = token.indexOf(92, pos)) >= 0) {
            int end = esc + 2;
            if (esc > n) break;
            if (sb == null) {
                sb = new StringBuilder(n);
            }
            sb.append(token, pos, esc);
            int codepoint = token.charAt(end - 1);
            if (CssGrammar.isHex(codepoint)) {
                char ch;
                while (end < n && CssGrammar.isHex(token.charAt(end))) {
                    ++end;
                }
                try {
                    codepoint = Integer.parseInt(token.substring(esc + 1, end), 16);
                }
                catch (RuntimeException ex) {
                    codepoint = 65533;
                }
                if (end >= n || (ch = token.charAt(end)) == ' ' || ch == '\t') {
                    // empty if block
                }
            }
            sb.appendCodePoint(codepoint);
            pos = ++end;
        }
        if (sb == null) {
            return token;
        }
        return sb.append(token, pos, n).toString();
    }

    private static boolean isHex(int codepoint) {
        return 48 <= codepoint && codepoint <= 57 || 65 <= codepoint && codepoint <= 70 || 97 <= codepoint && codepoint <= 102;
    }

    static {
        String h = "[0-9a-f]";
        String nonascii = "[\u0080-\u00ff]";
        String unicode = "(?:(?:\\\\" + h + "{1,6})(?:\r\n|[ \t\r\n\f])?)";
        String escape = "(?:" + unicode + "|\\\\[^\r\n\f0-9a-f])";
        String nmstart = "(?:[_a-z]|" + nonascii + "|" + escape + ")";
        String nmchar = "(?:[_a-z0-9-]|" + nonascii + "|" + escape + ")";
        String ident = "-?" + nmstart + nmchar + "*";
        String name = nmchar + "+";
        String hash = "#" + name;
        String string1 = "\"(?:[^\n\r\f\"\\\\]|\\\\.)*\"";
        String string2 = "'(?:[^\n\r\f'\\\\]|\\\\.)*'";
        String string = "(?:" + string1 + "|" + string2 + ")";
        String num = "(?:[0-9]*\\.[0-9]+|[0-9]+)";
        String s = "[ \t\r\n\f]";
        String w = "(?:" + s + "*)";
        String url_special_chars = "[!#$%&*-~]";
        String URL_CHARS = "(?:" + url_special_chars + "|" + nonascii + "|" + escape + ")*";
        String url = "url\\(" + w + "(" + string + "|" + URL_CHARS + ")" + w + "\\)";
        String comment = "/\\*(?:\\**[^*])*\\*+/";
        String unit = "(?:em|ex|px|cm|mm|in|pt|pc|deg|rad|grad|ms|s|hz|khz|%)";
        String quantity = num + w + "(?:" + unit + "|" + ident + ")?";
        String punc = "<!--|-->|~=|\\|=|[\\{\\}\\+>,:;()\\[\\]\\./]";
        CSS_TOKEN = Pattern.compile("((?!url\\b)" + ident + "|" + hash + ")" + "|([+-]?" + quantity + ")" + "|" + comment + "|(" + string + "|" + url + "|" + punc + ")" + "|(?:" + s + "+)|", 2);
    }

    static interface PropertyHandler {
        public void startProperty(String var1);

        public void quantity(String var1);

        public void identifierOrHash(String var1);

        public void quotedString(String var1);

        public void url(String var1);

        public void punctuation(String var1);

        public void endProperty();
    }
}

