/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import org.owasp.html.AbstractTokenStream;
import org.owasp.html.HtmlLexer;
import org.owasp.html.HtmlTextEscapingMode;
import org.owasp.html.HtmlToken;
import org.owasp.html.HtmlTokenType;

final class HtmlInputSplitter
extends AbstractTokenStream {
    private final String input;
    private int offset;
    private boolean inTag;
    private boolean inEscapeExemptBlock;
    private String escapeExemptTagName = null;
    private HtmlTextEscapingMode textEscapingMode;
    private HtmlToken lastNonIgnorable = null;

    public HtmlInputSplitter(String input) {
        this.input = input;
    }

    protected HtmlToken produce() {
        HtmlToken token = this.parseToken();
        if (null == token) {
            return null;
        }
        if (this.inEscapeExemptBlock) {
            if (token.type != HtmlTokenType.SERVERCODE) {
                token = HtmlInputSplitter.reclassify(token, this.textEscapingMode == HtmlTextEscapingMode.RCDATA ? HtmlTokenType.TEXT : HtmlTokenType.UNESCAPED);
            }
        } else {
            switch (token.type) {
                case TAGBEGIN: {
                    String canonTagName = this.canonicalName(token.start + 1, token.end);
                    if (!HtmlTextEscapingMode.isTagFollowedByLiteralContent(canonTagName)) break;
                    this.escapeExemptTagName = canonTagName;
                    this.textEscapingMode = HtmlTextEscapingMode.getModeForTag(canonTagName);
                    break;
                }
                case TAGEND: {
                    this.inEscapeExemptBlock = null != this.escapeExemptTagName;
                    break;
                }
            }
        }
        return token;
    }

    /*
     * Unable to fully structure code
     */
    private HtmlToken parseToken() {
        block84: {
            block86: {
                block87: {
                    block85: {
                        start = this.offset;
                        limit = this.input.length();
                        if (start == limit) {
                            return null;
                        }
                        ch = this.input.charAt(start);
                        if (!this.inTag) break block85;
                        if ('>' == ch) {
                            type = HtmlTokenType.TAGEND;
                            this.inTag = false;
                        } else if ('/' == ch) {
                            if (end != limit && '>' == this.input.charAt(end)) {
                                type = HtmlTokenType.TAGEND;
                                this.inTag = false;
                                ++end;
                            } else {
                                type = HtmlTokenType.TEXT;
                            }
                        } else if ('=' == ch) {
                            type = HtmlTokenType.TEXT;
                        } else if ('\"' == ch || '\'' == ch) {
                            type = HtmlTokenType.QSTRING;
                            delim = ch;
                            for (end = start + 1; end < limit; ++end) {
                                if (this.input.charAt(end) != delim) continue;
                                ++end;
                                break block84;
                            }
                        } else if (!Character.isWhitespace(ch)) {
                            type = HtmlTokenType.TEXT;
                            while (end < limit) {
                                ch = this.input.charAt(end);
                                if ((this.lastNonIgnorable == null || !this.lastNonIgnorable.tokenInContextMatches(this.input, "=")) && '/' == ch && end + 1 < limit && '>' == this.input.charAt(end + 1) || '>' == ch || '=' == ch || Character.isWhitespace(ch)) break block84;
                                if (('\"' == ch || '\'' == ch) && end + 1 < limit && ((ch2 = this.input.charAt(end + 1)) >= '\u0000' && Character.isWhitespace(ch2) || ch2 == '>' || ch2 == '/')) {
                                    ++end;
                                    break block84;
                                }
                                ++end;
                            }
                        } else {
                            type = HtmlTokenType.IGNORABLE;
                            while (end < limit && Character.isWhitespace(this.input.charAt(end))) {
                                ++end;
                            }
                        }
                        break block84;
                    }
                    if (ch != '<') break block86;
                    if (end != limit) break block87;
                    type = HtmlTokenType.TEXT;
                    break block84;
                }
                ch = this.input.charAt(end);
                type = null;
                state = null;
                switch (ch) {
                    case '/': {
                        state = State.SLASH;
                        ++end;
                        break;
                    }
                    case '!': {
                        if (!this.inEscapeExemptBlock) {
                            state = State.BANG;
                        } else if (HtmlTextEscapingMode.allowsEscapingTextSpan(this.escapeExemptTagName)) {
                            state = State.UNESCAPED_LT_BANG;
                        }
                        ++end;
                        break;
                    }
                    case '?': {
                        if (!this.inEscapeExemptBlock) {
                            state = State.APP_DIRECTIVE;
                        }
                        ++end;
                        break;
                    }
                    case '%': {
                        state = State.SERVER_CODE;
                        ++end;
                        break;
                    }
                    default: {
                        if (this.isIdentStart(ch) && !this.inEscapeExemptBlock) {
                            state = State.TAGNAME;
                            ++end;
                            break;
                        }
                        if ('<' == ch) {
                            type = HtmlTokenType.TEXT;
                            break;
                        }
                        ++end;
                    }
                }
                if (null == state) break block84;
                block36: while (end < limit) {
                    ch = this.input.charAt(end);
                    switch (1.$SwitchMap$org$owasp$html$HtmlInputSplitter$State[state.ordinal()]) {
                        case 1: {
                            if (Character.isWhitespace(ch) || '>' == ch || '/' == ch || '<' == ch) {
                                if (this.inEscapeExemptBlock && '/' == this.input.charAt(start + 1) && this.textEscapingMode != HtmlTextEscapingMode.PLAIN_TEXT && this.canonicalName(start + 2, end).equals(this.escapeExemptTagName)) {
                                    this.inEscapeExemptBlock = false;
                                    this.escapeExemptTagName = null;
                                    this.textEscapingMode = null;
                                }
                                type = HtmlTokenType.TAGBEGIN;
                                this.inTag = this.inEscapeExemptBlock == false;
                                state = State.DONE;
                                break block36;
                            }
                            ** GOTO lbl190
                        }
                        case 2: {
                            if (!Character.isLetter(ch)) ** GOTO lbl105
                            state = State.TAGNAME;
                            ** GOTO lbl190
lbl105:
                            // 1 sources

                            if ('<' == ch) {
                                type = HtmlTokenType.TEXT;
                                break block36;
                            }
                            ++end;
                            break block36;
                        }
                        case 3: {
                            state = '-' == ch ? State.BANG_DASH : State.DIRECTIVE;
                            ** GOTO lbl190
                        }
                        case 4: {
                            state = '-' == ch ? State.COMMENT : State.DIRECTIVE;
                            ** GOTO lbl190
                        }
                        case 5: {
                            if ('-' == ch) {
                                state = State.COMMENT_DASH;
                            }
                            ** GOTO lbl190
                        }
                        case 6: {
                            state = '-' == ch ? State.COMMENT_DASH_DASH : State.COMMENT_DASH;
                            ** GOTO lbl190
                        }
                        case 7: {
                            if ('>' == ch) {
                                state = State.DONE;
                                type = HtmlTokenType.COMMENT;
                            } else {
                                state = '-' == ch ? State.COMMENT_DASH_DASH : State.COMMENT_DASH;
                            }
                            ** GOTO lbl190
                        }
                        case 8: {
                            if ('>' == ch) {
                                type = HtmlTokenType.DIRECTIVE;
                                state = State.DONE;
                            }
                            ** GOTO lbl190
                        }
                        case 9: {
                            if ('?' == ch) {
                                state = State.APP_DIRECTIVE_QMARK;
                            }
                            ** GOTO lbl190
                        }
                        case 10: {
                            if ('>' == ch) {
                                type = HtmlTokenType.DIRECTIVE;
                                state = State.DONE;
                            } else if ('?' != ch) {
                                state = State.APP_DIRECTIVE;
                            }
                            ** GOTO lbl190
                        }
                        case 11: {
                            if ('%' == ch) {
                                state = State.SERVER_CODE_PCT;
                            }
                            ** GOTO lbl190
                        }
                        case 12: {
                            if ('>' == ch) {
                                type = HtmlTokenType.SERVERCODE;
                                state = State.DONE;
                            } else if ('%' != ch) {
                                state = State.SERVER_CODE;
                            }
                            ** GOTO lbl190
                        }
                        case 13: {
                            if ('-' == ch) {
                                state = State.UNESCAPED_LT_BANG_DASH;
                            } else {
                                type = HtmlTokenType.TEXT;
                                state = State.DONE;
                            }
                            ** GOTO lbl190
                        }
                        case 14: {
                            if ('-' == ch) {
                                state = State.ESCAPING_TEXT_SPAN_DASH_DASH;
                            } else {
                                type = HtmlTokenType.TEXT;
                                state = State.DONE;
                            }
                            ** GOTO lbl190
                        }
                        case 15: {
                            if ('-' == ch) {
                                state = State.ESCAPING_TEXT_SPAN_DASH;
                            }
                            ** GOTO lbl190
                        }
                        case 16: {
                            state = '-' == ch ? State.ESCAPING_TEXT_SPAN_DASH_DASH : State.ESCAPING_TEXT_SPAN;
                            ** GOTO lbl190
                        }
                        case 17: {
                            if ('>' == ch) {
                                type = HtmlTokenType.TEXT;
                                state = State.DONE;
                            } else if ('-' != ch) {
                                state = State.ESCAPING_TEXT_SPAN;
                            }
                            ** GOTO lbl190
                        }
                        case 18: {
                            throw new AssertionError((Object)"Unexpectedly DONE while lexing HTML token stream");
                        }
lbl190:
                        // 24 sources

                        default: {
                            ++end;
                            if (State.DONE != state) continue block36;
                            break block36;
                        }
                    }
                }
                if (end == limit) {
                    switch (1.$SwitchMap$org$owasp$html$HtmlInputSplitter$State[state.ordinal()]) {
                        case 18: {
                            break;
                        }
                        case 5: 
                        case 6: 
                        case 7: {
                            type = HtmlTokenType.COMMENT;
                            break;
                        }
                        case 8: 
                        case 9: 
                        case 10: {
                            type = HtmlTokenType.DIRECTIVE;
                            break;
                        }
                        case 11: 
                        case 12: {
                            type = HtmlTokenType.SERVERCODE;
                            break;
                        }
                        case 1: {
                            type = HtmlTokenType.TAGBEGIN;
                            break;
                        }
                        default: {
                            type = HtmlTokenType.TEXT;
                        }
                    }
                }
                break block84;
            }
            type = null;
        }
        if (null == type) {
            while (end < limit && '<' != this.input.charAt(end)) {
                ++end;
            }
            type = HtmlTokenType.TEXT;
        }
        this.offset = end;
        result = HtmlToken.instance(start, end, type);
        if (type != HtmlTokenType.IGNORABLE) {
            this.lastNonIgnorable = result;
        }
        return result;
    }

    private String canonicalName(int start, int end) {
        return HtmlLexer.canonicalName(this.input.substring(start, end));
    }

    private boolean isIdentStart(char ch) {
        return ch >= 'A' && ch <= 'z' && (ch <= 'Z' || ch >= 'a');
    }

    static HtmlToken reclassify(HtmlToken token, HtmlTokenType type) {
        return HtmlToken.instance(token.start, token.end, type);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        TAGNAME,
        SLASH,
        BANG,
        BANG_DASH,
        COMMENT,
        COMMENT_DASH,
        COMMENT_DASH_DASH,
        DIRECTIVE,
        DONE,
        APP_DIRECTIVE,
        APP_DIRECTIVE_QMARK,
        SERVER_CODE,
        SERVER_CODE_PCT,
        UNESCAPED_LT_BANG,
        UNESCAPED_LT_BANG_DASH,
        ESCAPING_TEXT_SPAN,
        ESCAPING_TEXT_SPAN_DASH,
        ESCAPING_TEXT_SPAN_DASH_DASH;

    }
}

