/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import org.owasp.html.HtmlEntities;
import org.owasp.html.HtmlLexer;
import org.owasp.html.HtmlStreamEventReceiver;
import org.owasp.html.HtmlToken;
import org.owasp.html.HtmlTokenType;
import org.owasp.html.TCB;
import org.owasp.html.TagBalancingHtmlStreamEventReceiver;

public final class HtmlSanitizer {
    /*
     * Enabled aggressive block sorting
     */
    public static void sanitize(@Nullable String html, Policy policy) {
        if (html == null) {
            html = "";
        }
        TagBalancingHtmlStreamEventReceiver balancer = new TagBalancingHtmlStreamEventReceiver(policy);
        balancer.setNestingLimit(256);
        balancer.openDocument();
        HtmlLexer lexer = new HtmlLexer(html);
        LinkedList attrs = Lists.newLinkedList();
        block10: while (true) {
            if (!lexer.hasNext()) {
                balancer.closeDocument();
                return;
            }
            HtmlToken token = lexer.next();
            switch (token.type) {
                case TEXT: {
                    balancer.text(HtmlSanitizer.decodeHtml(html.substring(token.start, token.end)));
                    break;
                }
                case UNESCAPED: {
                    balancer.text(html.substring(token.start, token.end));
                    break;
                }
                case TAGBEGIN: {
                    if (html.charAt(token.start + 1) == '/') {
                        balancer.closeTag(HtmlLexer.canonicalName(html.substring(token.start + 2, token.end)));
                        while (lexer.hasNext() && lexer.next().type != HtmlTokenType.TAGEND) {
                        }
                        continue block10;
                    } else {
                        attrs.clear();
                        boolean attrsReadyForName = true;
                        block12: while (lexer.hasNext()) {
                            HtmlToken tagBodyToken = lexer.next();
                            switch (tagBodyToken.type) {
                                case ATTRNAME: {
                                    if (!attrsReadyForName) {
                                        attrs.add(attrs.getLast());
                                    } else {
                                        attrsReadyForName = false;
                                    }
                                    attrs.add(HtmlLexer.canonicalName(html.substring(tagBodyToken.start, tagBodyToken.end)));
                                    break;
                                }
                                case ATTRVALUE: {
                                    attrs.add(HtmlSanitizer.decodeHtml(HtmlSanitizer.stripQuotes(html.substring(tagBodyToken.start, tagBodyToken.end))));
                                    attrsReadyForName = true;
                                    break;
                                }
                                case TAGEND: {
                                    break block12;
                                }
                            }
                        }
                        if (!attrsReadyForName) {
                            attrs.add(attrs.getLast());
                        }
                        balancer.openTag(HtmlLexer.canonicalName(html.substring(token.start + 1, token.end)), attrs);
                        continue block10;
                    }
                }
            }
        }
    }

    private static String stripQuotes(String encodedAttributeValue) {
        char last;
        int n = encodedAttributeValue.length();
        if (n > 0 && ((last = encodedAttributeValue.charAt(n - 1)) == '\"' || last == '\'')) {
            int start = 0;
            if (n != 1 && last == encodedAttributeValue.charAt(0)) {
                start = 1;
            }
            return encodedAttributeValue.substring(start, n - 1);
        }
        return encodedAttributeValue;
    }

    @VisibleForTesting
    static String decodeHtml(String s) {
        int end;
        int amp = s.indexOf(38);
        if (amp < 0) {
            return s;
        }
        int pos = 0;
        int n = s.length();
        StringBuilder sb = new StringBuilder(n);
        do {
            long endAndCodepoint = HtmlEntities.decodeEntityAt(s, amp, n);
            end = (int)(endAndCodepoint >>> 32);
            int codepoint = (int)endAndCodepoint;
            sb.append(s, pos, amp).appendCodePoint(codepoint);
            pos = end;
        } while ((amp = s.indexOf(38, end)) >= 0);
        return sb.append(s, pos, n).toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @TCB
    public static interface Policy
    extends HtmlStreamEventReceiver {
        @Override
        public void openTag(String var1, List<String> var2);

        @Override
        public void closeTag(String var1);

        @Override
        public void text(String var1);
    }
}

