/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import org.owasp.html.ElementAndAttributePolicies;
import org.owasp.html.ElementAndAttributePolicyBasedSanitizerPolicy;
import org.owasp.html.Handler;
import org.owasp.html.HtmlSanitizer;
import org.owasp.html.HtmlStreamEventReceiver;
import org.owasp.html.HtmlStreamRenderer;
import org.owasp.html.StylingPolicy;
import org.owasp.html.TCB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
@Immutable
@TCB
public final class PolicyFactory
implements Function<HtmlStreamEventReceiver, HtmlSanitizer.Policy> {
    private final ImmutableMap<String, ElementAndAttributePolicies> policies;
    private final boolean allowStyling;

    PolicyFactory(ImmutableMap<String, ElementAndAttributePolicies> policies, boolean allowStyling) {
        this.policies = policies;
        this.allowStyling = allowStyling;
    }

    public HtmlSanitizer.Policy apply(HtmlStreamEventReceiver out) {
        if (this.allowStyling) {
            return new StylingPolicy(out, this.policies);
        }
        return new ElementAndAttributePolicyBasedSanitizerPolicy(out, this.policies);
    }

    public String sanitize(@Nullable String html) {
        if (html == null) {
            return "";
        }
        StringBuilder out = new StringBuilder(html.length());
        HtmlSanitizer.sanitize(html, this.apply(HtmlStreamRenderer.create(out, Handler.DO_NOTHING)));
        return out.toString();
    }

    public PolicyFactory and(PolicyFactory f) {
        String elName;
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (Map.Entry e : this.policies.entrySet()) {
            elName = (String)e.getKey();
            ElementAndAttributePolicies p = (ElementAndAttributePolicies)e.getValue();
            ElementAndAttributePolicies q = (ElementAndAttributePolicies)f.policies.get((Object)elName);
            if (q != null) {
                p = p.and(q);
            }
            b.put((Object)elName, (Object)p);
        }
        for (Map.Entry e : f.policies.entrySet()) {
            elName = (String)e.getKey();
            if (this.policies.containsKey((Object)elName)) continue;
            b.put((Object)elName, e.getValue());
        }
        return new PolicyFactory((ImmutableMap<String, ElementAndAttributePolicies>)b.build(), this.allowStyling || f.allowStyling);
    }
}

