/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.redmine;

import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.plugins.redmine.MetricsAction;
import hudson.plugins.redmine.MetricsResult;
import hudson.util.Graph;
import hudson.util.RunList;
import hudson.util.ShiftedCategoryAxis;
import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.RectangleInsets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetricsGraph
extends Graph {
    private AbstractProject<?, ?> project;

    private DefaultCategoryDataset createDataset() {
        ArrayList<MetricsAction> actions = new ArrayList<MetricsAction>();
        RunList builds = this.project.getBuilds();
        for (Run run : builds) {
            MetricsAction action = (MetricsAction)run.getAction(MetricsAction.class);
            if (action == null) continue;
            actions.add(action);
        }
        Collections.reverse(actions);
        HashSet<String> statusSet = new HashSet<String>();
        DefaultCategoryDataset ds = new DefaultCategoryDataset();
        for (MetricsAction action : actions) {
            String buildNum = "#" + action.getBuild().getNumber();
            boolean addedValue = false;
            List<MetricsResult> metricsList = action.getMetricsList();
            for (MetricsResult result : metricsList) {
                statusSet.add(result.getStatus());
                ds.addValue((double)result.getCount(), (Comparable)((Object)result.getStatus()), (Comparable)((Object)buildNum));
                addedValue = true;
            }
            if (addedValue) continue;
            for (String status : statusSet) {
                ds.addValue(0.0, (Comparable)((Object)status), (Comparable)((Object)buildNum));
            }
        }
        return ds;
    }

    public MetricsGraph(AbstractProject<?, ?> project) {
        super(Calendar.getInstance(), 640, 480);
        this.project = project;
    }

    protected JFreeChart createGraph() {
        DefaultCategoryDataset dataset = this.createDataset();
        JFreeChart chart = ChartFactory.createStackedAreaChart((String)"Ticket", (String)"BuildNum", (String)"Count", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setAutoRange(true);
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
        return chart;
    }
}

