/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.redmine;

import com.taskadapter.redmineapi.RedmineException;
import com.taskadapter.redmineapi.RedmineManager;
import com.taskadapter.redmineapi.bean.Issue;
import com.taskadapter.redmineapi.bean.Project;
import com.taskadapter.redmineapi.bean.Version;
import hudson.plugins.redmine.MetricsException;
import hudson.plugins.redmine.MetricsResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedmineMetricsCalculator {
    private String url;
    private String apiKey;
    private String projectName;
    private String versions;
    private String ignoreTicketTracker;
    private String ignoreTicketStatus;

    public RedmineMetricsCalculator(String url, String apiKey, String projectName, String versions, String ignoreTicketTracker, String ignoreTicketStatus) {
        this.url = url;
        this.apiKey = apiKey;
        this.projectName = projectName;
        this.versions = versions;
        this.ignoreTicketTracker = ignoreTicketTracker;
        this.ignoreTicketStatus = ignoreTicketStatus;
    }

    public List<MetricsResult> calc() throws MetricsException {
        ArrayList<MetricsResult> result = new ArrayList<MetricsResult>();
        try {
            RedmineManager manager = new RedmineManager(this.url, this.apiKey);
            Project proj = this.getProject(manager);
            List<String> versionsList = this.getVersionsString(manager, proj);
            HashMap<String, Integer> tmpCalcMap = new HashMap<String, Integer>();
            for (String string : versionsList) {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("project_id", proj.getId().toString());
                params.put("fixed_version_id", string);
                params.put("status_id", "*");
                for (Issue issue : manager.getIssues(params)) {
                    if (!this.isTargetTracker(issue) || !this.isTargetStatus(issue)) continue;
                    String status = issue.getStatusName();
                    if (!tmpCalcMap.containsKey(status)) {
                        tmpCalcMap.put(status, 0);
                    }
                    Integer count = (Integer)tmpCalcMap.get(status);
                    tmpCalcMap.put(status, count + 1);
                }
            }
            for (Map.Entry entry : tmpCalcMap.entrySet()) {
                result.add(new MetricsResult((String)entry.getKey(), (Integer)entry.getValue()));
            }
        }
        catch (RedmineException e) {
            throw new MetricsException(e);
        }
        return result;
    }

    private boolean isTargetTracker(Issue issue) {
        if (this.ignoreTicketTracker == null || this.ignoreTicketTracker.isEmpty()) {
            return true;
        }
        return !ArrayUtils.contains((Object[])this.ignoreTicketTracker.split(","), (Object)issue.getTracker().getName());
    }

    private boolean isTargetStatus(Issue issue) {
        if (this.ignoreTicketStatus == null || this.ignoreTicketStatus.isEmpty()) {
            return true;
        }
        return !ArrayUtils.contains((Object[])this.ignoreTicketStatus.split(","), (Object)issue.getStatusName());
    }

    private Project getProject(RedmineManager manager) throws RedmineException {
        List projects = manager.getProjects();
        for (Project proj : projects) {
            if (!this.projectName.equalsIgnoreCase(proj.getIdentifier())) continue;
            return proj;
        }
        for (Project proj : projects) {
            if (!this.projectName.equals(proj.getName())) continue;
            return proj;
        }
        throw new RedmineException("No such project. projectName=" + this.projectName);
    }

    private List<String> getVersionsString(RedmineManager manager, Project proj) throws RedmineException {
        String[] versionStrings;
        List allVersions = manager.getVersions(proj.getId().intValue());
        if (this.versions.isEmpty()) {
            return this.allVersionsWithNull(allVersions);
        }
        ArrayList<String> vs = new ArrayList<String>();
        for (String string : versionStrings = this.versions.split(",")) {
            for (Version v : allVersions) {
                if (!string.trim().equals(v.getName())) continue;
                vs.add(String.valueOf(v.getId()));
            }
        }
        return vs;
    }

    private List<String> allVersionsWithNull(List<Version> versionList) {
        ArrayList<String> vs = new ArrayList<String>();
        vs.add("!*");
        for (Version v : versionList) {
            vs.add(String.valueOf(v.getId()));
        }
        return vs;
    }
}

