/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.redmine;

import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.plugins.redmine.Messages;
import hudson.plugins.redmine.MetricsAction;
import hudson.plugins.redmine.MetricsException;
import hudson.plugins.redmine.MetricsProjectAction;
import hudson.plugins.redmine.MetricsResult;
import hudson.plugins.redmine.RedmineMetricsCalculator;
import hudson.plugins.redmine.RedmineProjectProperty;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedmineMetricsPublisher
extends Publisher {
    private Secret apiKey;
    private String targetVersion;
    private String ignoreTicketTracker;
    private String ignoreTicketStatus;

    @DataBoundConstructor
    public RedmineMetricsPublisher(String apiKey, String targetVersion, String ignoreTicketTracker, String ignoreTicketStatus) {
        this.apiKey = Secret.fromString((String)Util.fixEmptyAndTrim((String)apiKey));
        this.targetVersion = targetVersion;
        this.ignoreTicketTracker = ignoreTicketTracker;
        this.ignoreTicketStatus = ignoreTicketStatus;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        RedmineProjectProperty rpp = (RedmineProjectProperty)build.getProject().getProperty(RedmineProjectProperty.class);
        if (rpp == null || rpp.getRedmineWebsite() == null) {
            return false;
        }
        PrintStream logger = listener.getLogger();
        RedmineMetricsCalculator calculator = new RedmineMetricsCalculator(rpp.getRedmineWebsite().baseUrl, this.apiKey.getPlainText(), rpp.projectName, this.targetVersion, this.ignoreTicketTracker, this.ignoreTicketStatus);
        try {
            List<MetricsResult> metricsList = calculator.calc();
            MetricsAction metricsAction = new MetricsAction(build, metricsList);
            build.addAction((Action)metricsAction);
        }
        catch (MetricsException e) {
            logger.println(e);
            return false;
        }
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public Secret getApiKey() {
        return this.apiKey;
    }

    public String getTargetVersion() {
        return this.targetVersion;
    }

    public String getIgnoreTicketTracker() {
        return this.ignoreTicketTracker;
    }

    public String getIgnoreTicketStatus() {
        return this.ignoreTicketStatus;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new MetricsProjectAction(project);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public FormValidation doCheckUrl(@QueryParameter String url) {
            if (url.length() == 0) {
                return FormValidation.error((String)Messages.error_require_redmine_url());
            }
            try {
                new URL(url);
            }
            catch (MalformedURLException e) {
                return FormValidation.error((String)Messages.error_invalid_redmine_url());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckApiKey(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.error_require_api_key());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckProjectName(@QueryParameter String projectName) {
            if (projectName.length() == 0) {
                return FormValidation.error((String)Messages.error_require_project_name());
            }
            return FormValidation.ok();
        }

        public String getDisplayName() {
            return Messages.aggregate_redmine_ticket_metrics();
        }
    }
}

