/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.redmine;

import com.google.common.collect.Sets;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.plugins.redmine.RedmineLinkAction;
import hudson.plugins.redmine.RedmineWebsiteConfig;
import hudson.util.CopyOnWriteList;
import hudson.util.FormValidation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedmineProjectProperty
extends JobProperty<AbstractProject<?, ?>> {
    private final String redmineWebsiteName;
    public final String projectName;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public RedmineProjectProperty(String redmineWebsiteName, String projectName) {
        this.redmineWebsiteName = redmineWebsiteName;
        this.projectName = projectName;
    }

    public Collection<? extends Action> getJobActions(AbstractProject<?, ?> job) {
        return Collections.singletonList(new RedmineLinkAction(this));
    }

    public RedmineWebsiteConfig getRedmineWebsite() {
        if (this.redmineWebsiteName == null) {
            return null;
        }
        RedmineWebsiteConfig foundRedmine = null;
        for (RedmineWebsiteConfig redmineConfig : DESCRIPTOR.getRedmineWebsites()) {
            if (!redmineConfig.name.equals(this.redmineWebsiteName)) continue;
            foundRedmine = redmineConfig;
            break;
        }
        return foundRedmine;
    }

    public JobPropertyDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        private final CopyOnWriteList<RedmineWebsiteConfig> redmineWebsites = new CopyOnWriteList();

        public DescriptorImpl() {
            super(RedmineProjectProperty.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return AbstractProject.class.isAssignableFrom(jobType);
        }

        public String getDisplayName() {
            return "Associated Redmine website";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            List redmineSites = req.bindJSONToList(RedmineWebsiteConfig.class, formData.get("redmineWebsites"));
            CollectionUtils.filter((Collection)redmineSites, (Predicate)new Predicate(){

                public boolean evaluate(Object object) {
                    return StringUtils.isNotBlank((String)((RedmineWebsiteConfig)((Object)object)).name) && StringUtils.isNotBlank((String)((RedmineWebsiteConfig)((Object)object)).baseUrl);
                }
            });
            CollectionUtils.filter((Collection)redmineSites, (Predicate)new Predicate(){
                Set<String> redmineNames = Sets.newHashSet();

                public boolean evaluate(Object object) {
                    String examinedName = ((RedmineWebsiteConfig)((Object)object)).name;
                    if (this.redmineNames.contains(examinedName)) {
                        return false;
                    }
                    this.redmineNames.add(examinedName);
                    return true;
                }
            });
            this.redmineWebsites.replaceBy((Collection)redmineSites);
            this.save();
            return super.configure(req, formData);
        }

        public JobProperty<?> newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            JSONObject redmineJson;
            if (formData.containsKey((Object)"redmine") && !StringUtils.isBlank((String)(redmineJson = formData.getJSONObject("redmine")).optString("redmineWebsiteName")) && !StringUtils.isBlank((String)redmineJson.optString("projectName"))) {
                return (JobProperty)req.bindJSON(RedmineProjectProperty.class, redmineJson);
            }
            return null;
        }

        public List<RedmineWebsiteConfig> getRedmineWebsites() {
            return this.redmineWebsites.getView();
        }

        public FormValidation doCheckProjectName(@QueryParameter String projectName) {
            if (projectName == null || projectName.trim().length() < 1) {
                return FormValidation.error((String)"Project name can't be empty!");
            }
            return FormValidation.ok();
        }
    }
}

