/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.redmine;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.plugins.redmine.RedmineProjectProperty;
import hudson.plugins.redmine.VersionUtil;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SubversionChangeLogSet;
import hudson.scm.SubversionRepositoryBrowser;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedmineRepositoryBrowser
extends SubversionRepositoryBrowser {
    private final String repositoryId;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public RedmineRepositoryBrowser(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    @Deprecated
    public RedmineRepositoryBrowser() {
        this(null);
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public URL getDiffLink(SubversionChangeLogSet.Path path) throws IOException {
        if (path.getEditType() != EditType.EDIT) {
            return null;
        }
        String filePath = this.getFilePath(path.getLogEntry(), path.getValue());
        int revision = path.getLogEntry().getRevision();
        if (this.isVersionBefore090(path.getLogEntry())) {
            URL baseUrl = this.getRedmineURL(path.getLogEntry());
            String projectName = this.getProject(path.getLogEntry());
            return new URL(baseUrl, "repositories/diff/" + projectName + filePath + "?rev=" + revision);
        }
        URL baseUrl = this.getRedmineProjectURL(path.getLogEntry());
        String id = this.getRepositoryId(path.getLogEntry());
        return new URL(baseUrl, "repository" + id + "/diff" + filePath + "?rev=" + revision);
    }

    public URL getFileLink(SubversionChangeLogSet.Path path) throws IOException {
        String filePath = this.getFilePath(path.getLogEntry(), path.getValue());
        if (this.isVersionBefore090(path.getLogEntry())) {
            URL baseUrl = this.getRedmineURL(path.getLogEntry());
            String projectName = this.getProject(path.getLogEntry());
            return baseUrl == null ? null : new URL(baseUrl, "repositories/entry/" + projectName + filePath);
        }
        URL baseUrl = this.getRedmineProjectURL(path.getLogEntry());
        String id = this.getRepositoryId(path.getLogEntry());
        int revision = path.getLogEntry().getRevision();
        return baseUrl == null ? null : new URL(baseUrl, "repository" + id + "/revisions/" + revision + "/entry" + filePath);
    }

    public URL getChangeSetLink(SubversionChangeLogSet.LogEntry changeSet) throws IOException {
        if (this.isVersionBefore090(changeSet)) {
            URL baseUrl = this.getRedmineURL(changeSet);
            String projectName = this.getProject(changeSet);
            return baseUrl == null ? null : new URL(baseUrl, "repositories/revision/" + projectName + "/" + changeSet.getRevision());
        }
        URL baseUrl = this.getRedmineProjectURL(changeSet);
        String id = this.getRepositoryId(changeSet);
        return baseUrl == null ? null : new URL(baseUrl, "repository" + id + "/revisions/" + changeSet.getRevision());
    }

    public Descriptor<RepositoryBrowser<?>> getDescriptor() {
        return DESCRIPTOR;
    }

    private URL getRedmineURL(SubversionChangeLogSet.LogEntry logEntry) throws MalformedURLException {
        AbstractProject p = logEntry.getParent().build.getProject();
        RedmineProjectProperty rpp = (RedmineProjectProperty)p.getProperty(RedmineProjectProperty.class);
        if (rpp == null) {
            return null;
        }
        return new URL(rpp.getRedmineWebsite().baseUrl);
    }

    private String getProject(SubversionChangeLogSet.LogEntry logEntry) {
        AbstractProject p = logEntry.getParent().build.getProject();
        RedmineProjectProperty rpp = (RedmineProjectProperty)p.getProperty(RedmineProjectProperty.class);
        if (rpp == null) {
            return null;
        }
        return rpp.projectName;
    }

    private URL getRedmineProjectURL(SubversionChangeLogSet.LogEntry logEntry) throws MalformedURLException {
        String url;
        AbstractProject p = logEntry.getParent().build.getProject();
        RedmineProjectProperty rpp = (RedmineProjectProperty)p.getProperty(RedmineProjectProperty.class);
        if (rpp == null || rpp.getRedmineWebsite() == null) {
            url = "";
        } else {
            url = rpp.getRedmineWebsite().baseUrl;
            if (rpp.projectName != null) {
                url = url + "projects/" + rpp.projectName + "/";
            }
        }
        return new URL(url);
    }

    private String getRepositoryId(SubversionChangeLogSet.LogEntry logEntry) {
        if (this.repositoryId == null || this.repositoryId.trim().length() == 0) {
            return "";
        }
        return "/" + this.repositoryId.trim();
    }

    private String getFilePath(SubversionChangeLogSet.LogEntry logEntry, String fileFullPath) {
        AbstractProject p = logEntry.getParent().build.getProject();
        RedmineProjectProperty rpp = (RedmineProjectProperty)p.getProperty(RedmineProjectProperty.class);
        String filePath = "";
        if (VersionUtil.isVersionBefore081(rpp.getRedmineWebsite().versionNumber)) {
            String[] filePaths = fileFullPath.split("/");
            filePath = "/";
            if (filePaths.length > 2) {
                for (int i = 2; i < filePaths.length; ++i) {
                    filePath = filePath + filePaths[i];
                    if (i == filePaths.length - 1) continue;
                    filePath = filePath + "/";
                }
            }
        } else {
            filePath = fileFullPath;
        }
        return filePath;
    }

    private boolean isVersionBefore090(SubversionChangeLogSet.LogEntry logEntry) {
        SubversionChangeLogSet parent = logEntry.getParent();
        if (parent == null || parent.build == null) {
            return false;
        }
        AbstractProject p = parent.build.getProject();
        RedmineProjectProperty rpp = (RedmineProjectProperty)p.getProperty(RedmineProjectProperty.class);
        return rpp != null && VersionUtil.isVersionBefore090(rpp.getRedmineWebsite().versionNumber);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends Descriptor<RepositoryBrowser<?>> {
        public DescriptorImpl() {
            super(RedmineRepositoryBrowser.class);
        }

        public String getDisplayName() {
            return "Redmine";
        }
    }
}

