/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.redmine;

import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.plugins.redmine.Messages;
import hudson.plugins.redmine.RedmineAuthenticationException;
import hudson.plugins.redmine.RedmineUserData;
import hudson.plugins.redmine.RedmineUserDetails;
import hudson.plugins.redmine.dao.AbstractAuthDao;
import hudson.plugins.redmine.dao.MySQLAuthDao;
import hudson.plugins.redmine.dao.PostgreSQLAuthDao;
import hudson.plugins.redmine.util.CipherUtil;
import hudson.security.AbstractPasswordBasedSecurityRealm;
import hudson.security.GroupDetails;
import hudson.security.SecurityRealm;
import hudson.util.Secret;
import java.util.HashSet;
import java.util.logging.Logger;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.providers.dao.AbstractUserDetailsAuthenticationProvider;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.springframework.dao.DataAccessException;

public class RedmineSecurityRealm
extends AbstractPasswordBasedSecurityRealm {
    private static final Logger LOGGER = Logger.getLogger(RedmineSecurityRealm.class.getName());
    private final String dbms;
    private final String dbServer;
    private final String databaseName;
    private final String port;
    private final String dbUserName;
    private final Secret dbPassword;
    private final String version;
    private final String loginTable;
    private final String userField;
    private final String passField;
    private final String saltField;

    @DataBoundConstructor
    public RedmineSecurityRealm(String dbms, String dbServer, String databaseName, String port, String dbUserName, String dbPassword, String version, String loginTable, String userField, String passField, String saltField) {
        this.dbms = StringUtils.isBlank((String)dbms) ? "MySQL" : dbms;
        this.dbServer = StringUtils.isBlank((String)dbServer) ? "127.0.0.1" : dbServer;
        String string = this.databaseName = StringUtils.isBlank((String)databaseName) ? "redmine" : databaseName;
        this.port = StringUtils.isBlank((String)port) ? ("MySQL".equals(this.dbms) ? "3306" : "PostgreSQL") : port;
        this.dbUserName = dbUserName;
        this.dbPassword = Secret.fromString((String)Util.fixEmptyAndTrim((String)dbPassword));
        this.version = StringUtils.isBlank((String)version) ? "1.2.0" : version;
        this.loginTable = StringUtils.isBlank((String)loginTable) ? "users" : loginTable;
        this.userField = StringUtils.isBlank((String)userField) ? "login" : userField;
        this.passField = StringUtils.isBlank((String)passField) ? "hashed_password" : passField;
        this.saltField = StringUtils.isBlank((String)saltField) ? "salt" : saltField;
    }

    @Extension
    public static DescriptorImpl install() {
        return new DescriptorImpl();
    }

    protected UserDetails authenticate(String username, String password) throws AuthenticationException {
        AbstractAuthDao dao = null;
        try {
            dao = this.createAuthDao(this.dbms);
            LOGGER.info("Redmine DBMS      : " + this.dbms);
            LOGGER.info("DB Server         : " + this.dbServer);
            LOGGER.info("DB Port           : " + this.port);
            LOGGER.info("Database Name     : " + this.databaseName);
            dao.open(this.dbServer, this.port, this.databaseName, this.dbUserName, this.dbPassword.getPlainText());
            if (!dao.isTable(this.loginTable)) {
                throw new RedmineAuthenticationException("RedmineSecurity: Invalid Login Table");
            }
            if (!dao.isField(this.loginTable, this.userField)) {
                throw new RedmineAuthenticationException("RedmineSecurity: Invalid User Field");
            }
            RedmineUserData userData = dao.getRedmineUserData(this.loginTable, this.userField, this.passField, "1.2.0".equals(this.version) ? this.saltField : null, username);
            if (userData == null) {
                LOGGER.warning("RedmineSecurity: Invalid Username");
                throw new UsernameNotFoundException("RedmineSecurity: User not found");
            }
            String encryptedPassword = "";
            if ("1.2.0".equals(this.version)) {
                encryptedPassword = CipherUtil.encodeSHA1(userData.getSalt() + CipherUtil.encodeSHA1(password));
            } else if ("1.1.3".equals(this.version)) {
                encryptedPassword = CipherUtil.encodeSHA1(password);
            }
            LOGGER.info("Redmine Version   : " + this.version);
            LOGGER.info("User Name         : " + username);
            LOGGER.info("Encrypted Password: " + encryptedPassword);
            if (!userData.getPassword().equals(encryptedPassword)) {
                LOGGER.warning("RedmineSecurity: Invalid Password");
                throw new RedmineAuthenticationException("RedmineSecurity: Invalid Password");
            }
            UserDetails userDetails = this.getUserDetails(username, userData.getPassword());
            return userDetails;
        }
        catch (AuthenticationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RedmineAuthenticationException("RedmineSecurity: System.Exception", e);
        }
        finally {
            if (dao != null) {
                dao.close();
            }
        }
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        AbstractAuthDao dao = null;
        try {
            dao = this.createAuthDao(this.dbms);
            dao.open(this.dbServer, this.port, this.databaseName, this.dbUserName, this.dbPassword.getPlainText());
            if (!dao.isTable(this.loginTable)) {
                throw new RedmineAuthenticationException("RedmineSecurity: Invalid Login Table");
            }
            if (!dao.isField(this.loginTable, this.userField)) {
                throw new RedmineAuthenticationException("RedmineSecurity: Invalid User Field");
            }
            RedmineUserData userData = dao.getRedmineUserData(this.loginTable, this.userField, this.passField, "1.2.0".equals(this.version) ? this.saltField : null, username);
            if (userData == null) {
                LOGGER.warning("RedmineSecurity: Invalid Username");
                throw new UsernameNotFoundException("RedmineSecurity: User not found");
            }
            UserDetails userDetails = this.getUserDetails(username, userData.getPassword());
            return userDetails;
        }
        catch (AuthenticationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RedmineAuthenticationException("RedmineSecurity: System.Exception", e);
        }
        finally {
            if (dao != null) {
                dao.close();
            }
        }
    }

    private AbstractAuthDao createAuthDao(String dbms) {
        if ("MySQL".equals(dbms)) {
            return new MySQLAuthDao();
        }
        if ("PostgreSQL".equals(dbms)) {
            return new PostgreSQLAuthDao();
        }
        return null;
    }

    public GroupDetails loadGroupByGroupname(String groupname) throws UsernameNotFoundException, DataAccessException {
        throw new UsernameNotFoundException("RedmineSecurityRealm: Non-supported function");
    }

    private UserDetails getUserDetails(String username, String password) {
        HashSet<GrantedAuthority> groups = new HashSet<GrantedAuthority>();
        groups.add(SecurityRealm.AUTHENTICATED_AUTHORITY);
        return new RedmineUserDetails(username, password, true, true, true, true, groups.toArray(new GrantedAuthority[groups.size()]));
    }

    public String getDbms() {
        return this.dbms;
    }

    public String getDbServer() {
        return this.dbServer;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getPort() {
        return this.port;
    }

    public String getDbUserName() {
        return this.dbUserName;
    }

    public Secret getDbPassword() {
        return this.dbPassword;
    }

    public String getVersion() {
        return this.version;
    }

    public String getLoginTable() {
        return this.loginTable;
    }

    public String getUserField() {
        return this.userField;
    }

    public String getPassField() {
        return this.passField;
    }

    public String getSaltField() {
        return this.saltField;
    }

    class Authenticator
    extends AbstractUserDetailsAuthenticationProvider {
        Authenticator() {
        }

        protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        }

        protected UserDetails retrieveUser(String username, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
            return RedmineSecurityRealm.this.authenticate(username, authentication.getCredentials().toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends Descriptor<SecurityRealm> {
        public String getHelpFile() {
            return "/plugin/redmine/help-auth-overview.html";
        }

        public String getDisplayName() {
            return Messages.RedmineSecurityRealm_DisplayName();
        }
    }
}

