/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.redmine;

import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedmineWebsiteConfig
extends AbstractDescribableImpl<RedmineWebsiteConfig> {
    public String name;
    public String baseUrl;
    public String versionNumber;

    @DataBoundConstructor
    public RedmineWebsiteConfig(String name, String baseUrl, String versionNumber) {
        this.name = name;
        this.baseUrl = baseUrl;
        if (!this.baseUrl.endsWith("/")) {
            this.baseUrl = this.baseUrl + '/';
        }
        this.versionNumber = versionNumber;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<RedmineWebsiteConfig> {
        public String getDisplayName() {
            return "";
        }

        public FormValidation doCheckName(@QueryParameter String name) {
            if (name == null || name.trim().length() < 1) {
                return FormValidation.error((String)"Name can't be empty!");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckBaseUrl(@QueryParameter String baseUrl) {
            if (baseUrl == null || baseUrl.trim().length() < 1) {
                return FormValidation.error((String)"Url can't be empty!");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckVersionNumber(@QueryParameter String versionNumber) {
            if (versionNumber == null || versionNumber.trim().length() < 1) {
                return FormValidation.ok();
            }
            if (versionNumber.split("\\.").length != 3) {
                return FormValidation.error((String)"Version number must be X.Y.Z form!");
            }
            return FormValidation.ok();
        }
    }
}

