/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.redmine.dao;

import hudson.plugins.redmine.RedmineAuthenticationException;
import hudson.plugins.redmine.RedmineUserData;
import hudson.plugins.redmine.dao.AbstractAuthDao;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.lang.StringUtils;

public class MySQLAuthDao
extends AbstractAuthDao {
    public void open(String dbServer, String port, String databaseName, String dbUserName, String dbPassword) throws RedmineAuthenticationException {
        try {
            String connectionString = String.format("jdbc:mysql://%s:%s/%s", dbServer, port, databaseName);
            Class.forName("com.mysql.jdbc.Driver").newInstance();
            this.conn = DriverManager.getConnection(connectionString, dbUserName, dbPassword);
        }
        catch (SQLException e) {
            throw new RedmineAuthenticationException("RedmineSecurity: Connection Error", e);
        }
        catch (Exception e) {
            throw new RedmineAuthenticationException("RedmineSecurity: Connection Error", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isTable(String table) throws RedmineAuthenticationException {
        PreparedStatement state = null;
        ResultSet results = null;
        try {
            String query = "SHOW TABLES";
            state = this.conn.prepareStatement(query);
            results = state.executeQuery();
            if (results == null) {
                boolean bl = false;
                return bl;
            }
            while (results.next()) {
                if (!results.getString(1).equals(table)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (RedmineAuthenticationException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new RedmineAuthenticationException("RedmineSecurity: Table Check Error", e);
        }
        catch (Exception e) {
            throw new RedmineAuthenticationException("RedmineSecurity: Table Check Error", e);
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (Exception exception) {}
            }
            if (state != null) {
                try {
                    state.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isField(String table, String field) throws RedmineAuthenticationException {
        Statement state = null;
        ResultSet results = null;
        try {
            String query = String.format("SHOW FIELDS FROM %s", table);
            state = this.conn.prepareStatement(query);
            results = state.executeQuery();
            if (results == null) {
                boolean bl = false;
                return bl;
            }
            while (results.next()) {
                if (!results.getString(1).equals(field)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (RedmineAuthenticationException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new RedmineAuthenticationException("RedmineSecurity: Field Check Error", e);
        }
        catch (Exception e) {
            throw new RedmineAuthenticationException("RedmineSecurity: Field Check Error", e);
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (Exception exception) {}
            }
            if (state != null) {
                try {
                    state.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RedmineUserData getRedmineUserData(String loginTable, String userField, String passField, String saltField, String username) throws RedmineAuthenticationException {
        Statement state = null;
        ResultSet results = null;
        try {
            String query = String.format("SELECT * FROM %s WHERE %s = ?", loginTable, userField);
            state = this.conn.prepareStatement(query);
            state.setString(1, username);
            results = state.executeQuery();
            if (results == null) {
                RedmineUserData redmineUserData = null;
                return redmineUserData;
            }
            if (results.next()) {
                RedmineUserData userData = new RedmineUserData();
                userData.setUsername(results.getString(userField));
                userData.setPassword(results.getString(passField));
                if (!StringUtils.isBlank((String)saltField)) {
                    userData.setSalt(results.getString(saltField));
                }
                RedmineUserData redmineUserData = userData;
                return redmineUserData;
            }
            RedmineUserData redmineUserData = null;
            return redmineUserData;
        }
        catch (RedmineAuthenticationException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new RedmineAuthenticationException("RedmineSecurity: Query Error", e);
        }
        catch (Exception e) {
            throw new RedmineAuthenticationException("RedmineSecurity: Query Error", e);
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (Exception exception) {}
            }
            if (state != null) {
                try {
                    state.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

