/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.annotation_indexer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hudson.annotation_indexer.SubtypeIterator;

public class Index {
    private static final Logger LOGGER = Logger.getLogger(Index.class.getName());

    public static <T extends AnnotatedElement> Iterable<T> list(Class<? extends Annotation> type, ClassLoader cl, final Class<T> subType) throws IOException {
        final Iterable<AnnotatedElement> base = Index.list(type, cl);
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new SubtypeIterator(base.iterator(), subType);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterable<AnnotatedElement> list(final Class<? extends Annotation> type, final ClassLoader cl) throws IOException {
        final TreeSet<String> ids = new TreeSet<String>();
        Enumeration<URL> res = cl.getResources("META-INF/annotations/" + type.getName());
        while (res.hasMoreElements()) {
            URL url = res.nextElement();
            InputStream is = url.openStream();
            try {
                String line;
                BufferedReader r = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((line = r.readLine()) != null) {
                    ids.add(line);
                }
            }
            finally {
                is.close();
            }
        }
        return new Iterable<AnnotatedElement>(){

            @Override
            public Iterator<AnnotatedElement> iterator() {
                return new Iterator<AnnotatedElement>(){
                    private AnnotatedElement next;
                    private final Iterator<String> iditr;
                    private final List<AnnotatedElement> lookaheads;
                    {
                        this.iditr = ids.iterator();
                        this.lookaheads = new LinkedList<AnnotatedElement>();
                    }

                    @Override
                    public boolean hasNext() {
                        this.fetch();
                        return this.next != null;
                    }

                    @Override
                    public AnnotatedElement next() {
                        this.fetch();
                        AnnotatedElement r = this.next;
                        this.next = null;
                        return r;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    private void fetch() {
                        while (this.next == null) {
                            if (!this.lookaheads.isEmpty()) {
                                this.next = this.lookaheads.remove(0);
                                return;
                            }
                            if (!this.iditr.hasNext()) {
                                return;
                            }
                            String name = this.iditr.next();
                            try {
                                Class<?> c = cl.loadClass(name);
                                if (c.isAnnotationPresent(type)) {
                                    this.lookaheads.add(c);
                                }
                                this.listAnnotatedElements(c.getDeclaredMethods());
                                this.listAnnotatedElements(c.getDeclaredFields());
                                this.listAnnotatedElements(c.getDeclaredConstructors());
                            }
                            catch (ClassNotFoundException e) {
                                LOGGER.log(Level.FINE, "Failed to load: " + name, e);
                            }
                            catch (LinkageError x) {
                                LOGGER.log(Level.WARNING, "Failed to load " + name, x);
                            }
                        }
                    }

                    private void listAnnotatedElements(AnnotatedElement[] elements) {
                        for (AnnotatedElement m : elements) {
                            if (!m.isAnnotationPresent(type)) continue;
                            this.lookaheads.add(m);
                        }
                    }
                };
            }
        };
    }

    private Index() {
    }
}

