/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.groovy;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.plugins.groovy.ScriptSource;
import java.io.IOException;
import org.kohsuke.stapler.DataBoundConstructor;

public class FileScriptSource
extends ScriptSource {
    private String scriptFile;

    @DataBoundConstructor
    public FileScriptSource(String scriptFile) {
        this.scriptFile = scriptFile;
    }

    @Override
    public FilePath getScriptFile(FilePath projectWorkspace, AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        EnvVars env = build.getEnvironment((TaskListener)listener);
        String expandedScriptdFile = env.expand(this.scriptFile);
        return new FilePath(projectWorkspace, expandedScriptdFile);
    }

    public String getScriptFile() {
        return this.scriptFile;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileScriptSource that = (FileScriptSource)o;
        return this.scriptFile != null ? this.scriptFile.equals(that.scriptFile) : that.scriptFile == null;
    }

    public int hashCode() {
        return this.scriptFile != null ? this.scriptFile.hashCode() : 0;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ScriptSource> {
        public String getDisplayName() {
            return "Groovy script file";
        }
    }
}

