/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.modules.launchd_slave_installer;

import hudson.FilePath;
import hudson.util.ArgumentListBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.modules.launchd_slave_installer.Messages;
import org.jenkinsci.modules.slave_installer.AbstractUnixSlaveInstaller;
import org.jenkinsci.modules.slave_installer.InstallationException;
import org.jenkinsci.modules.slave_installer.LaunchConfiguration;
import org.jenkinsci.modules.slave_installer.Prompter;
import org.jvnet.localizer.Localizable;

public class LaunchdSlaveInstaller
extends AbstractUnixSlaveInstaller {
    private final String instanceId;
    private transient File tmpDir;

    public LaunchdSlaveInstaller(String instanceId) {
        this.instanceId = instanceId;
    }

    public Localizable getConfirmationText() {
        return Messages._LaunchdSlaveInstaller_ConfirmationText();
    }

    public void install(LaunchConfiguration params, Prompter prompter) throws InstallationException, IOException, InterruptedException {
        this.tmpDir = File.createTempFile("jenkins", "tmp");
        this.tmpDir.delete();
        this.tmpDir.mkdirs();
        File sudo = this.copyResourceIntoExecutableFile("cocoasudo");
        File installSh = this.copyResourceIntoExecutableFile("install.sh");
        File slaveJar = params.getJarFile();
        String plist = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("jenkins-slave.plist"));
        plist = plist.replace("{username}", this.getCurrentUnixUserName()).replace("{instanceId}", this.instanceId).replace("{args}", this.toArgStrings(params.buildRunnerArguments()));
        File plistFile = File.createTempFile("jenkins-slave", "plist");
        FileUtils.writeStringToFile((File)plistFile, (String)plist);
        ArgumentListBuilder args = new ArgumentListBuilder().add(sudo).add("--prompt=Jenkins requires your password to register a slave agent as a start-up service").add(installSh).add(plistFile).add(slaveJar).add(this.instanceId);
        final String[] cmds = args.toCommandArray();
        Runtime.getRuntime().addShutdownHook(new Thread("service starter"){

            public void run() {
                try {
                    Process p = new ProcessBuilder(cmds).redirectErrorStream(true).start();
                    p.getOutputStream().close();
                    this.consume(p.getInputStream());
                    int r = p.waitFor();
                    if (r != 0) {
                        LaunchdSlaveInstaller.this.reportError("Failed to install as a service: " + r);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }

            private void consume(InputStream in) throws IOException {
                byte[] buf = new byte[1024];
                while (in.read(buf) >= 0) {
                }
            }
        });
        System.exit(0);
    }

    private String toArgStrings(ArgumentListBuilder args) {
        StringBuilder buf = new StringBuilder();
        for (String s : args.toList()) {
            buf.append("      <string>").append(s).append("</string>\n");
        }
        return buf.toString();
    }

    private File copyResourceIntoExecutableFile(String resourceName) throws IOException, InterruptedException {
        File f = new File(this.tmpDir, resourceName);
        FileUtils.copyURLToFile((URL)((Object)((Object)this)).getClass().getResource(resourceName), (File)f);
        new FilePath(f).chmod(493);
        return f;
    }
}

