/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials;

import com.cloudbees.plugins.credentials.ContextInPath;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsSelectHelper;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.CredentialsStoreAction;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import hudson.Functions;
import hudson.RestrictedSince;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ModelObject;
import hudson.model.User;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jenkins.model.Jenkins;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.lang.StringUtils;
import org.jenkins.ui.icon.IconSpec;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public abstract class CredentialsDescriptor
extends Descriptor<Credentials>
implements IconSpec {
    private final transient Map<String, FormValidation.CheckMethod> enhancedCheckMethods = new ConcurrentHashMap<String, FormValidation.CheckMethod>();

    protected CredentialsDescriptor(Class<? extends Credentials> clazz) {
        super(clazz);
    }

    protected CredentialsDescriptor() {
    }

    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.1.5")
    public ListBoxModel doFillScopeItems(@ContextInPath ModelObject context) {
        ListBoxModel m = new ListBoxModel();
        Set<CredentialsScope> scopes = CredentialsProvider.lookupScopes(context);
        if (scopes != null) {
            for (CredentialsScope scope : scopes) {
                m.add(scope.getDisplayName(), scope.toString());
            }
        }
        return m;
    }

    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.1.5")
    public boolean isScopeRelevant() {
        for (Ancestor ancestor = Stapler.getCurrentRequest().findAncestor(Object.class); ancestor != null; ancestor = ancestor.getPrev()) {
            ModelObject context;
            Set<CredentialsScope> scopes;
            if (!(ancestor.getObject() instanceof ModelObject) || (scopes = CredentialsProvider.lookupScopes(context = CredentialsDescriptor.unwrapContext((ModelObject)ancestor.getObject()))) == null) continue;
            return scopes.size() > 1;
        }
        return false;
    }

    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.1.5")
    public boolean isScopeRelevant(ModelObject object) {
        Set<CredentialsScope> scopes = CredentialsProvider.lookupScopes(object);
        return scopes != null && scopes.size() > 1;
    }

    @Restricted(value={NoExternalUse.class})
    public boolean isScopeRelevant(@CheckForNull CredentialsStore store) {
        Set<CredentialsScope> scopes = store == null ? null : store.getScopes();
        return scopes != null && scopes.size() > 1;
    }

    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.1.5")
    public boolean isScopeRelevant(CredentialsStoreAction.DomainWrapper wrapper) {
        if (wrapper != null) {
            return this.isScopeRelevant(wrapper.getStore().getContext());
        }
        CredentialsStoreAction action = (CredentialsStoreAction)Stapler.getCurrentRequest().findAncestorObject(CredentialsStoreAction.class);
        if (action != null) {
            return this.isScopeRelevant(action.getStore().getContext());
        }
        return this.isScopeRelevant();
    }

    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.1.5")
    public boolean isScopeRelevant(CredentialsStoreAction.CredentialsWrapper wrapper) {
        if (wrapper != null) {
            return this.isScopeRelevant(wrapper.getStore().getContext());
        }
        CredentialsStoreAction action = (CredentialsStoreAction)Stapler.getCurrentRequest().findAncestorObject(CredentialsStoreAction.class);
        if (action != null) {
            return this.isScopeRelevant(action.getStore().getContext());
        }
        return this.isScopeRelevant();
    }

    @Restricted(value={NoExternalUse.class})
    public boolean isScopeRelevant(CredentialsSelectHelper.WrappedCredentialsStore wrapper) {
        if (wrapper != null) {
            return this.isScopeRelevant(wrapper.getStore().getContext());
        }
        CredentialsStoreAction action = (CredentialsStoreAction)Stapler.getCurrentRequest().findAncestorObject(CredentialsStoreAction.class);
        if (action != null) {
            return this.isScopeRelevant(action.getStore().getContext());
        }
        return this.isScopeRelevant();
    }

    public String getCredentialsPage() {
        return this.getViewPage(this.clazz, "credentials.jelly");
    }

    public String getIconClassName() {
        return "icon-credentials-credential";
    }

    public boolean isApplicable(CredentialsProvider provider) {
        return true;
    }

    @NonNull
    public static ModelObject unwrapContext(@NonNull ModelObject context) {
        if (context instanceof CredentialsSelectHelper.WrappedCredentialsStore) {
            return ((CredentialsSelectHelper.WrappedCredentialsStore)context).getStore().getContext();
        }
        if (context instanceof CredentialsStoreAction.CredentialsWrapper) {
            return ((CredentialsStoreAction.CredentialsWrapper)context).getStore().getContext();
        }
        if (context instanceof CredentialsStoreAction.DomainWrapper) {
            return ((CredentialsStoreAction.DomainWrapper)context).getStore().getContext();
        }
        return context;
    }

    @CheckForNull
    public static ModelObject lookupContext(String provider, String token) {
        for (CredentialsSelectHelper.ContextResolver r : ExtensionList.lookup(CredentialsSelectHelper.ContextResolver.class)) {
            if (!r.getClass().getName().equals(provider)) continue;
            return r.getContext(token);
        }
        return null;
    }

    @CheckForNull
    public static <T extends ModelObject> T findContextInPath(@NonNull Class<T> type) {
        return CredentialsDescriptor.findContextInPath(Stapler.getCurrentRequest(), type);
    }

    @CheckForNull
    public static <T extends ModelObject> T findContextInPath(@NonNull StaplerRequest request, @NonNull Class<T> type) {
        List ancestors = request.getAncestors();
        for (int i = ancestors.size() - 1; i >= 0; --i) {
            Ancestor a = (Ancestor)ancestors.get(i);
            Object o = a.getObject();
            if (o instanceof CredentialsSelectHelper.WrappedCredentialsStore) {
                o = ((CredentialsSelectHelper.WrappedCredentialsStore)o).getStore().getContext();
            } else if (o instanceof CredentialsStoreAction.CredentialsWrapper) {
                o = ((CredentialsStoreAction.CredentialsWrapper)((Object)o)).getStore().getContext();
            } else if (o instanceof CredentialsStoreAction.DomainWrapper) {
                o = ((CredentialsStoreAction.DomainWrapper)((Object)o)).getStore().getContext();
            } else if (o instanceof Descriptor && i == 1) {
                String referer = request.getReferer();
                String rootPath = request.getRootPath();
                if (referer != null && rootPath != null && referer.startsWith(rootPath)) {
                    String path = URI.create(referer.substring(rootPath.length())).getPath().substring(1);
                    ArrayList<String> pathSegments = new ArrayList<String>(Arrays.asList(StringUtils.split((String)path, (String)"/")));
                    while (!pathSegments.isEmpty() && StringUtils.isBlank((String)((String)pathSegments.get(0)))) {
                        pathSegments.remove(0);
                    }
                    if (pathSegments.size() >= 2) {
                        String firstSegment = (String)pathSegments.get(0);
                        if ("user".equals(firstSegment)) {
                            User user = User.get((String)((String)pathSegments.get(1)));
                            if (type.isInstance(user) && CredentialsProvider.hasStores((ModelObject)user)) {
                                return (T)((ModelObject)type.cast(user));
                            }
                        } else if ("job".equals(firstSegment) || "item".equals(firstSegment) || "view".equals(firstSegment)) {
                            int index = 0;
                            while (index < pathSegments.size()) {
                                String segment = (String)pathSegments.get(index);
                                if ("view".equals(segment)) {
                                    pathSegments.remove(index);
                                    if (index >= pathSegments.size()) continue;
                                    pathSegments.remove(index);
                                    continue;
                                }
                                if ("job".equals(segment) || "item".equals(segment)) {
                                    pathSegments.remove(index);
                                    ++index;
                                    continue;
                                }
                                while (index < pathSegments.size()) {
                                    pathSegments.remove(index);
                                }
                            }
                            Jenkins jenkins = Jenkins.getActiveInstance();
                            while (!pathSegments.isEmpty()) {
                                String fullName = StringUtils.join(pathSegments, (String)"/");
                                Item item = jenkins.getItemByFullName(fullName);
                                if (item != null && type.isInstance(item) && CredentialsProvider.hasStores((ModelObject)item)) {
                                    return (T)((ModelObject)type.cast(item));
                                }
                                pathSegments.remove(pathSegments.size() - 1);
                            }
                        }
                    }
                }
            }
            if (!type.isInstance(o) || !(o instanceof ModelObject) || !CredentialsProvider.hasStores((ModelObject)o)) continue;
            return (T)((ModelObject)type.cast(o));
        }
        return null;
    }

    public FormValidation.CheckMethod getCheckMethod(String fieldName) {
        FormValidation.CheckMethod method = this.enhancedCheckMethods.get(fieldName);
        if (method == null) {
            method = new EnhancedCheckMethod(this, fieldName);
            this.enhancedCheckMethods.put(fieldName, method);
        }
        return method;
    }

    public void calcFillSettings(String field, Map<String, Object> attributes) {
        if (attributes.containsKey("fillUrl")) {
            super.calcFillSettings(field, attributes);
            return;
        }
        super.calcFillSettings(field, attributes);
        if (attributes.containsKey("fillUrl")) {
            try {
                JellyContext jelly = Functions.getCurrentJellyContext();
                Object it = jelly.findVariable("it");
                if (it instanceof CredentialsStore) {
                    ModelObject context = ((CredentialsStore)it).getContext();
                    for (CredentialsSelectHelper.ContextResolver r : ExtensionList.lookup(CredentialsSelectHelper.ContextResolver.class)) {
                        String fillUrl;
                        String token = r.getToken(context);
                        if (token == null || (fillUrl = (String)attributes.get("fillUrl")) == null) continue;
                        fillUrl = fillUrl.indexOf(63) != -1 ? fillUrl + '&' : fillUrl + '?';
                        attributes.put("fillUrl", fillUrl + "$provider=" + URLEncoder.encode(r.getClass().getName(), "UTF-8") + "&$token=" + URLEncoder.encode(token, "UTF-8"));
                    }
                }
            }
            catch (AssertionError assertionError) {
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    public void calcAutoCompleteSettings(String field, Map<String, Object> attributes) {
        if (attributes.containsKey("autoCompleteUrl")) {
            super.calcAutoCompleteSettings(field, attributes);
            return;
        }
        super.calcAutoCompleteSettings(field, attributes);
        if (attributes.containsKey("autoCompleteUrl")) {
            try {
                JellyContext jelly = Functions.getCurrentJellyContext();
                Object it = jelly.findVariable("it");
                if (it instanceof CredentialsStore) {
                    ModelObject context = ((CredentialsStore)it).getContext();
                    for (CredentialsSelectHelper.ContextResolver r : ExtensionList.lookup(CredentialsSelectHelper.ContextResolver.class)) {
                        String autoCompleteUrl;
                        String token = r.getToken(context);
                        if (token == null || (autoCompleteUrl = (String)attributes.get("autoCompleteUrl")) == null) continue;
                        autoCompleteUrl = autoCompleteUrl.indexOf(63) != -1 ? autoCompleteUrl + '&' : autoCompleteUrl + '?';
                        attributes.put("autoCompleteUrl", autoCompleteUrl + "$provider=" + URLEncoder.encode(r.getClass().getName(), "UTF-8") + "&$token=" + URLEncoder.encode(token, "UTF-8"));
                    }
                }
            }
            catch (AssertionError assertionError) {
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static class EnhancedCheckMethod
    extends FormValidation.CheckMethod {
        public EnhancedCheckMethod(Descriptor descriptor, String fieldName) {
            super(descriptor, fieldName);
        }

        public String toCheckUrl() {
            String checkUrl = super.toCheckUrl();
            if (checkUrl == null) {
                return null;
            }
            try {
                JellyContext jelly = Functions.getCurrentJellyContext();
                Object it = jelly.findVariable("it");
                if (it instanceof CredentialsStore) {
                    ModelObject context = ((CredentialsStore)it).getContext();
                    for (CredentialsSelectHelper.ContextResolver r : ExtensionList.lookup(CredentialsSelectHelper.ContextResolver.class)) {
                        String token = r.getToken(context);
                        if (token == null) continue;
                        checkUrl = checkUrl.endsWith(".toString()") ? StringUtils.removeEnd((String)checkUrl, (String)".toString()") : checkUrl + "+qs(this).addThis()";
                        return checkUrl + ".append('$provider=" + Functions.jsStringEscape((String)URLEncoder.encode(r.getClass().getName(), "UTF-8")) + "').append('$token=" + Functions.jsStringEscape((String)URLEncoder.encode(token, "UTF-8")) + "').toString()";
                    }
                }
            }
            catch (AssertionError assertionError) {
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            return checkUrl;
        }
    }
}

