/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.actions;

import com.google.common.collect.Maps;
import com.google.common.primitives.Primitives;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.collections.CollectionUtils;
import org.jenkinsci.plugins.structs.describable.DescribableModel;
import org.jenkinsci.plugins.structs.describable.UninstantiatedDescribable;
import org.jenkinsci.plugins.workflow.actions.PersistentAction;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graph.StepNode;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;

public abstract class ArgumentsAction
implements PersistentAction {
    private static final Logger LOGGER = Logger.getLogger(ArgumentsAction.class.getName());
    protected static final int MAX_RETAINED_LENGTH = Integer.getInteger(ArgumentsAction.class.getName() + ".maxRetainedLength", 1024);

    public static boolean isOversized(@CheckForNull Object o, int maxElements) {
        if (maxElements <= 0) {
            return false;
        }
        if (o == null || Primitives.isWrapperType(o.getClass()) || o.getClass().isEnum()) {
            return false;
        }
        if (o instanceof CharSequence) {
            return ((CharSequence)o).length() > maxElements;
        }
        return (o instanceof Map || o instanceof Collection || o.getClass().isArray()) && CollectionUtils.size((Object)o) > maxElements;
    }

    protected static boolean isOversized(@CheckForNull Object o) {
        return ArgumentsAction.isOversized(o, MAX_RETAINED_LENGTH);
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return null;
    }

    @Nonnull
    public Map<String, Object> getArguments() {
        Map<String, Object> args = this.getArgumentsInternal();
        if (args.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(args);
    }

    @Nonnull
    public static Map<String, Object> getArguments(@Nonnull FlowNode n) {
        ArgumentsAction aa = n.getPersistentAction(ArgumentsAction.class);
        return aa != null ? aa.getArguments() : Collections.emptyMap();
    }

    @Nonnull
    public Map<String, Object> getFilteredArguments() {
        Map<String, Object> internalArgs = this.getArgumentsInternal();
        if (internalArgs.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap filteredArguments = Maps.newHashMapWithExpectedSize((int)internalArgs.size());
        for (Map.Entry<String, Object> entry : internalArgs.entrySet()) {
            if (entry.getValue() == null || entry.getValue() instanceof NotStoredReason) continue;
            filteredArguments.put(entry.getKey(), entry.getValue());
        }
        return filteredArguments;
    }

    @Nonnull
    public static Map<String, Object> getFilteredArguments(@Nonnull FlowNode n) {
        ArgumentsAction act = n.getPersistentAction(ArgumentsAction.class);
        return act != null ? act.getFilteredArguments() : Collections.EMPTY_MAP;
    }

    @CheckForNull
    public static String getStepArgumentsAsString(@Nonnull FlowNode n) {
        StepDescriptor descriptor;
        if (n instanceof StepNode && (descriptor = ((StepNode)((Object)n)).getDescriptor()) != null) {
            Map<String, Object> filteredArgs = ArgumentsAction.getFilteredArguments(n);
            return descriptor.argumentsToString(filteredArgs);
        }
        return null;
    }

    @Nonnull
    protected abstract Map<String, Object> getArgumentsInternal();

    @CheckForNull
    public Object getArgumentValue(@Nonnull String argumentName) {
        Object val = this.getArgumentValueOrReason(argumentName);
        return val instanceof NotStoredReason ? null : val;
    }

    @CheckForNull
    public Object getArgumentValueOrReason(@Nonnull String argumentName) {
        Object ob = this.getArgumentsInternal().get(argumentName);
        if (ob instanceof Map) {
            return Collections.unmodifiableMap((Map)ob);
        }
        if (ob instanceof Set) {
            return Collections.unmodifiableSet((Set)ob);
        }
        if (ob instanceof List) {
            return Collections.unmodifiableList((List)ob);
        }
        if (ob instanceof Collection) {
            return Collections.unmodifiableCollection((Collection)ob);
        }
        return ob;
    }

    static boolean checkArgumentsLackPlaceholders(@Nonnull Map<String, Object> namedArgs) {
        for (Object ob : namedArgs.values()) {
            if (!(ob instanceof NotStoredReason)) continue;
            return false;
        }
        return true;
    }

    public boolean isUnmodifiedArguments() {
        return ArgumentsAction.checkArgumentsLackPlaceholders(this.getArgumentsInternal());
    }

    @Nonnull
    public static Map<String, ?> getResolvedArguments(@Nonnull FlowNode n) {
        StepDescriptor d;
        ArgumentsAction aa = n.getPersistentAction(ArgumentsAction.class);
        if (aa == null) {
            return Collections.emptyMap();
        }
        Map<String, Object> args = aa.getArgumentsInternal();
        if (n instanceof StepNode && (d = ((StepNode)((Object)n)).getDescriptor()) != null) {
            try {
                return ArgumentsAction.resolve(DescribableModel.of((Class)d.clazz), args).getArguments();
            }
            catch (Exception x) {
                LOGGER.log(Level.FINE, "could not resolve " + args + " for " + d.clazz.getName(), x);
            }
        }
        return args;
    }

    private static <S extends Step> UninstantiatedDescribable resolve(DescribableModel<S> model, Map<String, Object> arguments) throws Exception {
        return model.uninstantiate2(model.instantiate(arguments));
    }

    public static enum NotStoredReason {
        MASKED_VALUE,
        OVERSIZE_VALUE,
        UNSERIALIZABLE;

    }
}

