/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.actions;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.actions.PersistentAction;
import org.jenkinsci.plugins.workflow.graph.FlowNode;

public class TagsAction
implements PersistentAction {
    private static final String displayName = "Tags";
    private static final String urlSuffix = "tags";
    private LinkedHashMap<String, String> tags = new LinkedHashMap();

    public void addTag(@CheckForNull String tag, @CheckForNull String value) {
        if (tag != null && value != null && !tag.isEmpty() && !value.isEmpty()) {
            this.tags.put(tag, value);
        }
    }

    public boolean removeTag(@CheckForNull String tag) {
        if (tag == null || tag.isEmpty()) {
            return false;
        }
        return this.tags.remove(tag) != null;
    }

    @CheckForNull
    public String getTagValue(@CheckForNull String tag) {
        if (tag == null || tag.isEmpty()) {
            return null;
        }
        return this.tags.get(tag);
    }

    @Nonnull
    public Map<String, String> getTags() {
        return Collections.unmodifiableMap(this.tags);
    }

    @Nonnull
    public static Map<String, String> getTags(@Nonnull FlowNode node) {
        TagsAction tagAction = node.getAction(TagsAction.class);
        return tagAction == null ? Collections.emptyMap() : tagAction.getTags();
    }

    @CheckForNull
    public static String getTagValue(@Nonnull FlowNode node, @CheckForNull String tag) {
        if (tag == null || tag.isEmpty()) {
            return null;
        }
        TagsAction tagAction = node.getAction(TagsAction.class);
        return tagAction == null ? null : tagAction.getTagValue(tag);
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return displayName;
    }

    public String getUrlName() {
        return urlSuffix;
    }
}

