/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.flow;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.org.apache.tools.tar.TarInputStream;
import hudson.util.DirScanner;
import hudson.util.io.ArchiverFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.ArtifactManager;
import jenkins.model.Jenkins;
import jenkins.util.BuildListenerAdapter;
import jenkins.util.VirtualFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.tools.tar.TarEntry;
import org.jenkinsci.plugins.workflow.flow.FlowCopier;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class StashManager {
    private static final String SUFFIX = ".tar.gz";

    @Deprecated
    public static void stash(@Nonnull Run<?, ?> build, @Nonnull String name, @Nonnull FilePath workspace, @Nonnull TaskListener listener, @CheckForNull String includes, @CheckForNull String excludes) throws IOException, InterruptedException {
        StashManager.stash(build, name, workspace, listener, includes, excludes, true, false);
    }

    @Deprecated
    public static void stash(@Nonnull Run<?, ?> build, @Nonnull String name, @Nonnull FilePath workspace, @Nonnull TaskListener listener, @CheckForNull String includes, @CheckForNull String excludes, boolean useDefaultExcludes) throws IOException, InterruptedException {
        StashManager.stash(build, name, workspace, listener, includes, excludes, useDefaultExcludes, false);
    }

    @Deprecated
    public static void stash(@Nonnull Run<?, ?> build, @Nonnull String name, @Nonnull FilePath workspace, @Nonnull TaskListener listener, @CheckForNull String includes, @CheckForNull String excludes, boolean useDefaultExcludes, boolean allowEmpty) throws IOException, InterruptedException {
        StashManager.stash(build, name, workspace, StashManager.launcherFor(workspace, listener), StashManager.envFor(build, workspace, listener), listener, includes, excludes, useDefaultExcludes, allowEmpty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"}, justification="fine if mkdirs returns false")
    public static void stash(@Nonnull Run<?, ?> build, @Nonnull String name, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull EnvVars env, @Nonnull TaskListener listener, @CheckForNull String includes, @CheckForNull String excludes, boolean useDefaultExcludes, boolean allowEmpty) throws IOException, InterruptedException {
        Jenkins.checkGoodName((String)name);
        StashAwareArtifactManager saam = StashManager.stashAwareArtifactManager(build);
        if (saam != null) {
            saam.stash(name, workspace, launcher, env, listener, includes, excludes, useDefaultExcludes, allowEmpty);
            return;
        }
        File storage = StashManager.storage(build, name);
        storage.getParentFile().mkdirs();
        if (storage.isFile()) {
            listener.getLogger().println("Warning: overwriting stash \u2018" + name + "\u2019");
        }
        try (FileOutputStream os = new FileOutputStream(storage);){
            int count = workspace.archive(ArchiverFactory.TARGZ, (OutputStream)os, (DirScanner)new DirScanner.Glob(Util.fixEmpty((String)includes) == null ? "**" : includes, excludes, useDefaultExcludes));
            if (count == 0 && !allowEmpty) {
                throw new AbortException("No files included in stash");
            }
            listener.getLogger().println("Stashed " + count + " file(s)");
        }
    }

    @Deprecated
    public static void unstash(@Nonnull Run<?, ?> build, @Nonnull String name, @Nonnull FilePath workspace, @Nonnull TaskListener listener) throws IOException, InterruptedException {
        StashManager.unstash(build, name, workspace, StashManager.launcherFor(workspace, listener), StashManager.envFor(build, workspace, listener), listener);
    }

    public static void unstash(@Nonnull Run<?, ?> build, @Nonnull String name, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull EnvVars env, @Nonnull TaskListener listener) throws IOException, InterruptedException {
        Jenkins.checkGoodName((String)name);
        StashAwareArtifactManager saam = StashManager.stashAwareArtifactManager(build);
        if (saam != null) {
            saam.unstash(name, workspace, launcher, env, listener);
            return;
        }
        File storage = StashManager.storage(build, name);
        if (!storage.isFile()) {
            throw new AbortException("No such saved stash \u2018" + name + "\u2019");
        }
        new FilePath(storage).untar(workspace, FilePath.TarCompression.GZIP);
    }

    @Deprecated
    public static void clearAll(@Nonnull Run<?, ?> build) throws IOException {
        try {
            StashManager.clearAll(build, TaskListener.NULL);
        }
        catch (InterruptedException x) {
            throw new IOException(x);
        }
    }

    public static void clearAll(@Nonnull Run<?, ?> build, @Nonnull TaskListener listener) throws IOException, InterruptedException {
        StashAwareArtifactManager saam = StashManager.stashAwareArtifactManager(build);
        if (saam != null) {
            saam.clearAllStashes(listener);
            return;
        }
        Util.deleteRecursive((File)StashManager.storage(build));
    }

    @Deprecated
    public static void maybeClearAll(@Nonnull Run<?, ?> build) throws IOException {
        try {
            StashManager.maybeClearAll(build, TaskListener.NULL);
        }
        catch (InterruptedException x) {
            throw new IOException(x);
        }
    }

    public static void maybeClearAll(@Nonnull Run<?, ?> build, @Nonnull TaskListener listener) throws IOException, InterruptedException {
        for (StashBehavior behavior : ExtensionList.lookup(StashBehavior.class)) {
            if (behavior.shouldClearAll(build)) continue;
            return;
        }
        StashManager.clearAll(build, listener);
    }

    @Deprecated
    public static void copyAll(@Nonnull Run<?, ?> from, @Nonnull Run<?, ?> to) throws IOException {
        File fromStorage = StashManager.storage(from);
        if (!fromStorage.isDirectory()) {
            return;
        }
        FileUtils.copyDirectory((File)fromStorage, (File)StashManager.storage(to));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Restricted(value={DoNotUse.class})
    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"}, justification="test code")
    public static Map<String, Map<String, String>> stashesOf(@Nonnull Run<?, ?> build) throws IOException {
        TreeMap<String, Map<String, String>> result = new TreeMap<String, Map<String, String>>();
        File[] kids = StashManager.storage(build).listFiles();
        if (kids != null) {
            for (File kid : kids) {
                String n = kid.getName();
                if (!n.endsWith(SUFFIX)) continue;
                TreeMap<String, String> unpacked = new TreeMap<String, String>();
                result.put(n.substring(0, n.length() - SUFFIX.length()), unpacked);
                try (FileInputStream is = new FileInputStream(kid);){
                    TarEntry te;
                    InputStream wrapped = FilePath.TarCompression.GZIP.extract((InputStream)is);
                    TarInputStream tis = new TarInputStream(wrapped);
                    while ((te = tis.getNextEntry()) != null) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        IOUtils.copy((InputStream)tis, (OutputStream)baos);
                        unpacked.put(te.getName(), baos.toString());
                    }
                }
            }
        }
        return result;
    }

    @Nonnull
    private static File storage(@Nonnull Run<?, ?> build) throws IOException {
        assert (StashManager.stashAwareArtifactManager(build) == null);
        return new File(build.getRootDir(), "stashes");
    }

    @Nonnull
    private static File storage(@Nonnull Run<?, ?> build, @Nonnull String name) throws IOException {
        File dir = StashManager.storage(build);
        File f = new File(dir, name + SUFFIX);
        if (!f.getParentFile().equals(dir)) {
            throw new IllegalArgumentException();
        }
        return f;
    }

    private StashManager() {
    }

    @CheckForNull
    private static StashAwareArtifactManager stashAwareArtifactManager(@Nonnull Run<?, ?> build) throws IOException {
        ArtifactManager am = build.pickArtifactManager();
        return am instanceof StashAwareArtifactManager ? (StashAwareArtifactManager)am : null;
    }

    @Deprecated
    @Nonnull
    private static Launcher launcherFor(@Nonnull FilePath workspace, @Nonnull TaskListener listener) {
        Computer c = workspace.toComputer();
        if (c != null) {
            Node n = c.getNode();
            if (n != null) {
                return n.createLauncher(listener);
            }
            listener.error(c.getDisplayName() + " seems to be offline");
            return new Launcher.LocalLauncher(listener);
        }
        listener.error(workspace + " seems to be offline");
        return new Launcher.LocalLauncher(listener);
    }

    @Deprecated
    @Nonnull
    private static EnvVars envFor(@Nonnull Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull TaskListener listener) throws IOException, InterruptedException {
        Computer c = workspace.toComputer();
        if (c != null) {
            EnvVars e = c.getEnvironment();
            e.putAll((Map)c.buildEnvironment(listener));
            e.putAll((Map)build.getEnvironment(listener));
            return e;
        }
        listener.error(workspace + " seems to be offline");
        return new EnvVars();
    }

    @Restricted(value={NoExternalUse.class})
    @Extension
    public static class CopyStashesAndArtifacts
    extends FlowCopier.ByRun {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copy(Run<?, ?> original, Run<?, ?> copy, TaskListener listener) throws IOException, InterruptedException {
            StashAwareArtifactManager saam = StashManager.stashAwareArtifactManager(original);
            if (saam != null) {
                saam.copyAllArtifactsAndStashes(copy, listener);
                return;
            }
            VirtualFile srcroot = original.getArtifactManager().root();
            FilePath dstDir = this.createTmpDir();
            try {
                HashMap<String, String> files = new HashMap<String, String>();
                for (String path : srcroot.list("**/*", null, false)) {
                    files.put(path, path);
                    InputStream in = srcroot.child(path).open();
                    try {
                        dstDir.child(path).copyFrom(in);
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)in);
                    }
                }
                if (!files.isEmpty()) {
                    listener.getLogger().println("Copying " + files.size() + " artifact(s) from " + original.getDisplayName());
                    copy.getArtifactManager().archive(dstDir, (Launcher)new Launcher.LocalLauncher(listener), (BuildListener)new BuildListenerAdapter(listener), files);
                }
            }
            finally {
                dstDir.deleteRecursive();
            }
            StashManager.copyAll(original, copy);
        }

        private FilePath createTmpDir() throws IOException {
            File dir = File.createTempFile("artifact", "copy");
            if (!dir.delete() || !dir.mkdirs()) {
                throw new IOException("Failed to create temporary directory " + dir.getPath());
            }
            return new FilePath(dir);
        }
    }

    @Restricted(value={Beta.class})
    public static interface StashAwareArtifactManager {
        public void stash(@Nonnull String var1, @Nonnull FilePath var2, @Nonnull Launcher var3, @Nonnull EnvVars var4, @Nonnull TaskListener var5, @CheckForNull String var6, @CheckForNull String var7, boolean var8, boolean var9) throws IOException, InterruptedException;

        public void unstash(@Nonnull String var1, @Nonnull FilePath var2, @Nonnull Launcher var3, @Nonnull EnvVars var4, @Nonnull TaskListener var5) throws IOException, InterruptedException;

        public void clearAllStashes(@Nonnull TaskListener var1) throws IOException, InterruptedException;

        public void copyAllArtifactsAndStashes(@Nonnull Run<?, ?> var1, @Nonnull TaskListener var2) throws IOException, InterruptedException;
    }

    public static abstract class StashBehavior
    implements ExtensionPoint {
        public boolean shouldClearAll(@Nonnull Run<?, ?> build) {
            return true;
        }
    }
}

