/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.graphanalysis;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graphanalysis.Filterator;
import org.jenkinsci.plugins.workflow.graphanalysis.FilteratorImpl;
import org.jenkinsci.plugins.workflow.graphanalysis.FlowNodeVisitor;

@NotThreadSafe
public abstract class AbstractFlowScanner
implements Iterable<FlowNode>,
Filterator<FlowNode> {
    protected FlowNode myCurrent;
    protected FlowNode myNext;
    protected Collection<FlowNode> myBlackList = Collections.EMPTY_SET;
    protected static final int MAX_LIST_CHECK_SIZE = 5;

    @Nonnull
    protected Collection<FlowNode> convertToFastCheckable(@CheckForNull Collection<FlowNode> nodeCollection) {
        if (nodeCollection == null || nodeCollection.size() == 0) {
            return Collections.EMPTY_SET;
        }
        if (nodeCollection.size() == 1) {
            return Collections.singleton(nodeCollection.iterator().next());
        }
        if (nodeCollection instanceof HashSet) {
            return nodeCollection;
        }
        return nodeCollection.size() > 5 ? new HashSet(nodeCollection) : nodeCollection;
    }

    public boolean setup(@CheckForNull Collection<FlowNode> heads, @CheckForNull Collection<FlowNode> blackList) {
        if (heads == null || heads.size() == 0) {
            return false;
        }
        Collection<FlowNode> fastEndNodes = this.convertToFastCheckable(blackList);
        LinkedHashSet<FlowNode> filteredHeads = new LinkedHashSet<FlowNode>(heads);
        filteredHeads.removeAll(fastEndNodes);
        if (filteredHeads.size() == 0) {
            return false;
        }
        this.reset();
        this.myBlackList = fastEndNodes;
        this.setHeads(filteredHeads);
        return true;
    }

    public boolean setup(@CheckForNull Collection<FlowNode> heads) {
        if (heads == null) {
            return false;
        }
        return this.setup(heads, (Collection<FlowNode>)Collections.EMPTY_SET);
    }

    public boolean setup(@CheckForNull FlowNode head, @CheckForNull Collection<FlowNode> blackList) {
        if (head == null) {
            return false;
        }
        return this.setup(Collections.singleton(head), blackList);
    }

    public boolean setup(@CheckForNull FlowNode head) {
        if (head == null) {
            return false;
        }
        return this.setup(Collections.singleton(head), (Collection<FlowNode>)Collections.EMPTY_SET);
    }

    protected abstract void reset();

    protected abstract void setHeads(@Nonnull Collection<FlowNode> var1);

    @CheckForNull
    protected abstract FlowNode next(@Nonnull FlowNode var1, @Nonnull Collection<FlowNode> var2);

    @Override
    public boolean hasNext() {
        return this.myNext != null;
    }

    @Override
    public FlowNode next() {
        if (this.myNext == null) {
            throw new NoSuchElementException();
        }
        this.myCurrent = this.myNext;
        this.myNext = this.next(this.myCurrent, this.myBlackList);
        return this.myCurrent;
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException("FlowGraphs are immutable, so FlowScanners can't remove nodes");
    }

    @Override
    @Nonnull
    public Iterator<FlowNode> iterator() {
        return this;
    }

    @Override
    @Nonnull
    public Filterator<FlowNode> filter(@Nonnull Predicate<FlowNode> filterCondition) {
        return new FilteratorImpl<FlowNode>(this, filterCondition);
    }

    @CheckForNull
    public FlowNode findFirstMatch(@CheckForNull Collection<FlowNode> heads, @CheckForNull Collection<FlowNode> blackListNodes, Predicate<FlowNode> matchCondition) {
        if (!this.setup(heads, blackListNodes)) {
            return null;
        }
        for (FlowNode f : this) {
            if (!matchCondition.apply((Object)f)) continue;
            return f;
        }
        return null;
    }

    @CheckForNull
    public FlowNode findFirstMatch(@CheckForNull Collection<FlowNode> heads, @Nonnull Predicate<FlowNode> matchPredicate) {
        return this.findFirstMatch(heads, null, matchPredicate);
    }

    @CheckForNull
    public FlowNode findFirstMatch(@CheckForNull FlowNode head, @Nonnull Predicate<FlowNode> matchPredicate) {
        return this.findFirstMatch(Collections.singleton(head), null, matchPredicate);
    }

    @CheckForNull
    public FlowNode findFirstMatch(@CheckForNull FlowExecution exec, @Nonnull Predicate<FlowNode> matchPredicate) {
        if (exec != null && exec.getCurrentHeads() != null && !exec.getCurrentHeads().isEmpty()) {
            return this.findFirstMatch(exec.getCurrentHeads(), null, matchPredicate);
        }
        return null;
    }

    @Nonnull
    public List<FlowNode> filteredNodes(@CheckForNull Collection<FlowNode> heads, @CheckForNull Collection<FlowNode> blackList, Predicate<FlowNode> matchCondition) {
        if (!this.setup(heads, blackList)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<FlowNode> nodes = new ArrayList<FlowNode>();
        for (FlowNode f : this) {
            if (!matchCondition.apply((Object)f)) continue;
            nodes.add(f);
        }
        return nodes;
    }

    @Nonnull
    public List<FlowNode> allNodes(@CheckForNull Collection<FlowNode> heads) {
        if (!this.setup(heads)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<FlowNode> nodes = new ArrayList<FlowNode>();
        for (FlowNode f : this) {
            nodes.add(f);
        }
        return nodes;
    }

    @Nonnull
    public List<FlowNode> allNodes(@CheckForNull FlowExecution exec) {
        return exec == null ? Collections.EMPTY_LIST : this.allNodes(exec.getCurrentHeads());
    }

    @Nonnull
    public List<FlowNode> filteredNodes(@CheckForNull Collection<FlowNode> heads, @Nonnull Predicate<FlowNode> matchPredicate) {
        return this.filteredNodes(heads, null, matchPredicate);
    }

    @Nonnull
    public List<FlowNode> filteredNodes(@CheckForNull FlowNode head, @Nonnull Predicate<FlowNode> matchPredicate) {
        return this.filteredNodes(Collections.singleton(head), null, matchPredicate);
    }

    @Nonnull
    public List<FlowNode> filteredNodes(@CheckForNull FlowExecution exec, @Nonnull Predicate<FlowNode> matchPredicate) {
        if (exec == null) {
            return Collections.emptyList();
        }
        return this.filteredNodes(exec.getCurrentHeads(), null, matchPredicate);
    }

    public void visitAll(@CheckForNull Collection<FlowNode> heads, @CheckForNull Collection<FlowNode> blackList, @Nonnull FlowNodeVisitor visitor) {
        FlowNode f;
        boolean canContinue;
        if (!this.setup(heads, blackList)) {
            return;
        }
        Iterator<FlowNode> iterator = this.iterator();
        while (iterator.hasNext() && (canContinue = visitor.visit(f = iterator.next()))) {
        }
    }

    public void visitAll(@CheckForNull Collection<FlowNode> heads, @Nonnull FlowNodeVisitor visitor) {
        this.visitAll(heads, null, visitor);
    }
}

