/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.graphanalysis;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.jenkinsci.plugins.workflow.graph.BlockEndNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graphanalysis.LinearScanner;

@NotThreadSafe
public class LinearBlockHoppingScanner
extends LinearScanner {
    private static final Logger LOGGER = Logger.getLogger(LinearBlockHoppingScanner.class.getName());

    @Override
    public boolean setup(@CheckForNull Collection<FlowNode> heads, @CheckForNull Collection<FlowNode> blackList) {
        boolean possiblyStartable = super.setup(heads, blackList);
        return possiblyStartable && this.myCurrent != null;
    }

    @Override
    protected void setHeads(@Nonnull Collection<FlowNode> heads) {
        Iterator<FlowNode> it = heads.iterator();
        if (it.hasNext()) {
            this.myNext = this.myCurrent = this.jumpBlockScan(it.next(), this.myBlackList);
            if (it.hasNext()) {
                LOGGER.log(Level.WARNING, null, new IllegalArgumentException("Multiple heads not supported for linear scanners"));
            }
        }
    }

    @CheckForNull
    protected FlowNode jumpBlockScan(@CheckForNull FlowNode node, @Nonnull Collection<FlowNode> blacklistNodes) {
        FlowNode candidate = node;
        while (candidate != null && candidate instanceof BlockEndNode) {
            if (blacklistNodes.contains((Object)(candidate = ((BlockEndNode)candidate).getStartNode()))) {
                return null;
            }
            List<FlowNode> parents = candidate.getParents();
            if (parents == null || parents.size() == 0) {
                return null;
            }
            boolean foundNode = false;
            for (FlowNode f : parents) {
                if (blacklistNodes.contains((Object)f)) continue;
                candidate = f;
                foundNode = true;
                break;
            }
            if (foundNode) continue;
            return null;
        }
        return candidate;
    }

    @Override
    protected FlowNode next(@Nonnull FlowNode current, @Nonnull Collection<FlowNode> blackList) {
        if (current == null) {
            return null;
        }
        List<FlowNode> parents = current.getParents();
        if (parents != null && parents.size() > 0) {
            for (FlowNode f : parents) {
                if (blackList.contains((Object)f)) continue;
                return f instanceof BlockEndNode ? this.jumpBlockScan(f, blackList) : f;
            }
        }
        return null;
    }
}

