/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.job;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.BulkChange;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.FilePath;
import hudson.Functions;
import hudson.Launcher;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Action;
import hudson.model.BallColor;
import hudson.model.BuildAuthorizationToken;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.DescriptorVisibilityFilter;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.RunMap;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.model.TopLevelItemDescriptor;
import hudson.model.listeners.SCMListener;
import hudson.model.queue.CauseOfBlockage;
import hudson.model.queue.QueueTaskFuture;
import hudson.model.queue.SubTask;
import hudson.scm.PollingResult;
import hudson.scm.SCM;
import hudson.scm.SCMRevisionState;
import hudson.search.SearchIndexBuilder;
import hudson.security.ACL;
import hudson.security.Permission;
import hudson.slaves.WorkspaceList;
import hudson.triggers.SCMTrigger;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.AlternativeUiTextProvider;
import hudson.util.DescribableList;
import hudson.widgets.HistoryWidget;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.servlet.ServletException;
import jenkins.model.BlockedBecauseOfBuildInProgress;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.model.lazy.LazyBuildMixIn;
import jenkins.triggers.SCMTriggerItem;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.workflow.flow.BlockableResume;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinitionDescriptor;
import org.jenkinsci.plugins.workflow.job.Messages;
import org.jenkinsci.plugins.workflow.job.WorkflowJobProperty;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.job.properties.DisableConcurrentBuildsJobProperty;
import org.jenkinsci.plugins.workflow.job.properties.DisableResumeJobProperty;
import org.jenkinsci.plugins.workflow.job.properties.PipelineTriggersJobProperty;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;

public final class WorkflowJob
extends Job<WorkflowJob, WorkflowRun>
implements LazyBuildMixIn.LazyLoadingJob<WorkflowJob, WorkflowRun>,
ParameterizedJobMixIn.ParameterizedJob<WorkflowJob, WorkflowRun>,
TopLevelItem,
Queue.FlyweightTask,
SCMTriggerItem,
BlockableResume {
    private static final Logger LOGGER = Logger.getLogger(WorkflowJob.class.getName());
    private FlowDefinition definition;
    private DescribableList<Trigger<?>, TriggerDescriptor> triggers = new DescribableList((Saveable)this);
    private volatile Integer quietPeriod;
    private BuildAuthorizationToken authToken;
    private transient LazyBuildMixIn<WorkflowJob, WorkflowRun> buildMixIn = this.createBuildMixIn();
    @CheckForNull
    private Boolean concurrentBuild;
    private volatile transient Map<String, SCMRevisionState> pollingBaselines;
    private volatile boolean disabled;
    @Deprecated
    public static final Permission ABORT = CANCEL;

    public WorkflowJob(ItemGroup parent, String name) {
        super(parent, name);
    }

    public void onCreatedFromScratch() {
        super.onCreatedFromScratch();
        this.buildMixIn.onCreatedFromScratch();
    }

    public void onLoad(ItemGroup<? extends Item> parent, String name) throws IOException {
        super.onLoad(parent, name);
        if (this.buildMixIn == null) {
            this.buildMixIn = this.createBuildMixIn();
        }
        this.buildMixIn.onLoad(parent, name);
        if (this.triggers != null && !this.triggers.isEmpty()) {
            this.setTriggers(this.triggers.toList());
        }
        if (this.concurrentBuild != null) {
            this.setConcurrentBuild(this.concurrentBuild);
        }
        this.getTriggersJobProperty().stopTriggers();
        this.getTriggersJobProperty().startTriggers(Items.currentlyUpdatingByXml());
    }

    private LazyBuildMixIn<WorkflowJob, WorkflowRun> createBuildMixIn() {
        return new LazyBuildMixIn<WorkflowJob, WorkflowRun>(){

            protected WorkflowJob asJob() {
                return WorkflowJob.this;
            }

            protected Class<WorkflowRun> getBuildClass() {
                return WorkflowRun.class;
            }
        };
    }

    public FlowDefinition getDefinition() {
        return this.definition;
    }

    public void setDefinition(FlowDefinition definition) {
        this.definition = definition;
        try {
            this.save();
        }
        catch (IOException x) {
            LOGGER.log(Level.WARNING, "could not save " + (Object)((Object)this), x);
        }
    }

    protected void submit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, Descriptor.FormException {
        super.submit(req, rsp);
        JSONObject json = req.getSubmittedForm();
        this.definition = (FlowDefinition)req.bindJSON(FlowDefinition.class, json.getJSONObject("definition"));
        this.authToken = BuildAuthorizationToken.create((StaplerRequest)req);
        this.quietPeriod = req.getParameter("hasCustomQuietPeriod") != null ? Integer.valueOf(Integer.parseInt(req.getParameter("quiet_period"))) : null;
        this.makeDisabled(json.optBoolean("disable"));
        this.getTriggersJobProperty().stopTriggers();
        this.getTriggersJobProperty().startTriggers(Items.currentlyUpdatingByXml());
    }

    public void addProperty(JobProperty jobProp) throws IOException {
        super.addProperty(jobProp);
        if (jobProp instanceof PipelineTriggersJobProperty) {
            this.getTriggersJobProperty().stopTriggers();
            this.getTriggersJobProperty().startTriggers(Items.currentlyUpdatingByXml());
        }
    }

    public boolean isBuildable() {
        for (JobProperty property : this.properties) {
            Boolean buildable;
            if (!(property instanceof WorkflowJobProperty) || (buildable = ((WorkflowJobProperty)property).isBuildable()) == null) continue;
            return buildable;
        }
        return super.isBuildable();
    }

    protected RunMap<WorkflowRun> _getRuns() {
        return this.buildMixIn._getRuns();
    }

    public LazyBuildMixIn<WorkflowJob, WorkflowRun> getLazyBuildMixIn() {
        return this.buildMixIn;
    }

    protected void removeRun(WorkflowRun run) {
        this.buildMixIn.removeRun((Run)run);
    }

    @Deprecated
    public WorkflowRun getBuild(String id) {
        return (WorkflowRun)this.buildMixIn.getBuild(id);
    }

    public WorkflowRun getBuildByNumber(int n) {
        return (WorkflowRun)this.buildMixIn.getBuildByNumber(n);
    }

    public WorkflowRun getFirstBuild() {
        return (WorkflowRun)this.buildMixIn.getFirstBuild();
    }

    public WorkflowRun getLastBuild() {
        return (WorkflowRun)this.buildMixIn.getLastBuild();
    }

    public WorkflowRun getNearestBuild(int n) {
        return (WorkflowRun)this.buildMixIn.getNearestBuild(n);
    }

    public WorkflowRun getNearestOldBuild(int n) {
        return (WorkflowRun)this.buildMixIn.getNearestOldBuild(n);
    }

    protected HistoryWidget createHistoryWidget() {
        return this.buildMixIn.createHistoryWidget();
    }

    @CheckForNull
    public QueueTaskFuture<WorkflowRun> scheduleBuild2(int quietPeriod, Action ... actions) {
        return super.scheduleBuild2(quietPeriod, actions);
    }

    protected SearchIndexBuilder makeSearchIndex() {
        return this.getParameterizedJobMixIn().extendSearchIndex(super.makeSearchIndex());
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    @Restricted(value={DoNotUse.class})
    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean supportsMakeDisabled() {
        return true;
    }

    public BallColor getIconColor() {
        if (this.isDisabled()) {
            return this.isBuilding() ? BallColor.DISABLED_ANIME : BallColor.DISABLED;
        }
        return super.getIconColor();
    }

    public BuildAuthorizationToken getAuthToken() {
        return this.authToken;
    }

    public int getQuietPeriod() {
        return this.quietPeriod != null ? this.quietPeriod.intValue() : Jenkins.getActiveInstance().getQuietPeriod();
    }

    @Restricted(value={DoNotUse.class})
    public boolean getHasCustomQuietPeriod() {
        return this.quietPeriod != null;
    }

    public void setQuietPeriod(Integer seconds) throws IOException {
        this.quietPeriod = seconds;
        this.save();
    }

    public boolean isBuildBlocked() {
        return this.getCauseOfBlockage() != null;
    }

    @Deprecated
    public String getWhyBlocked() {
        CauseOfBlockage c = this.getCauseOfBlockage();
        return c != null ? c.getShortDescription() : null;
    }

    public CauseOfBlockage getCauseOfBlockage() {
        WorkflowRun lastBuild;
        if (this.isLogUpdated() && !this.isConcurrentBuild() && (lastBuild = this.getLastBuild()) != null) {
            return new BlockedBecauseOfBuildInProgress((Run)lastBuild);
        }
        return null;
    }

    @Exported
    public boolean isConcurrentBuild() {
        return this.getProperty(DisableConcurrentBuildsJobProperty.class) == null;
    }

    @Exported
    public boolean isResumeBlocked() {
        return this.getProperty(DisableResumeJobProperty.class) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResumeBlocked(boolean resumeBlocked) {
        block6: {
            try {
                boolean previousState = this.isResumeBlocked();
                if (resumeBlocked == previousState) break block6;
                BulkChange bc = new BulkChange((Saveable)this);
                try {
                    this.removeProperty(DisableResumeJobProperty.class);
                    if (resumeBlocked) {
                        this.addProperty((JobProperty)new DisableResumeJobProperty());
                    }
                    bc.commit();
                }
                finally {
                    bc.abort();
                }
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, "Error persisting resume property statue", ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConcurrentBuild(boolean b) throws IOException {
        boolean propertyExists;
        this.concurrentBuild = null;
        boolean bl = propertyExists = this.getProperty(DisableConcurrentBuildsJobProperty.class) != null;
        if (propertyExists == b) {
            BulkChange bc = new BulkChange((Saveable)this);
            try {
                this.removeProperty(DisableConcurrentBuildsJobProperty.class);
                if (!b) {
                    this.addProperty((JobProperty)new DisableConcurrentBuildsJobProperty());
                }
                bc.commit();
            }
            finally {
                bc.abort();
            }
        }
    }

    public ACL getACL() {
        ACL acl = super.getACL();
        for (JobProperty property : this.properties) {
            if (!(property instanceof WorkflowJobProperty)) continue;
            acl = ((WorkflowJobProperty)property).decorateACL(acl);
        }
        return acl;
    }

    public void checkAbortPermission() {
        this.checkPermission(CANCEL);
    }

    public boolean hasAbortPermission() {
        return this.hasPermission(CANCEL);
    }

    public Collection<? extends SubTask> getSubTasks() {
        ArrayList<WorkflowJob> subTasks = new ArrayList<WorkflowJob>();
        subTasks.add(this);
        for (JobProperty p : this.properties) {
            subTasks.addAll(p.getSubTasks());
        }
        return subTasks;
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="TODO 1.653+ switch to Jenkins.getInstanceOrNull")
    public Label getAssignedLabel() {
        Jenkins j = Jenkins.getInstance();
        if (j == null) {
            return null;
        }
        return j.getSelfLabel();
    }

    public Node getLastBuiltOn() {
        return Jenkins.getInstance();
    }

    public Object getSameNodeConstraint() {
        return this;
    }

    public String getPronoun() {
        return AlternativeUiTextProvider.get((AlternativeUiTextProvider.Message)PRONOUN, (Object)((Object)this), (String)"Pipeline");
    }

    public TopLevelItemDescriptor getDescriptor() {
        return (DescriptorImpl)Jenkins.getActiveInstance().getDescriptorOrDie(WorkflowJob.class);
    }

    public Map<TriggerDescriptor, Trigger<?>> getTriggers() {
        return this.getTriggersJobProperty().getTriggersMap();
    }

    public PipelineTriggersJobProperty getTriggersJobProperty() {
        PipelineTriggersJobProperty triggerProp = (PipelineTriggersJobProperty)this.getProperty(PipelineTriggersJobProperty.class);
        if (triggerProp == null) {
            triggerProp = new PipelineTriggersJobProperty(new ArrayList<Trigger>());
        }
        return triggerProp;
    }

    @Restricted(value={NoExternalUse.class})
    public void addTriggersJobPropertyWithoutStart(PipelineTriggersJobProperty prop) throws IOException {
        super.addProperty((JobProperty)prop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTriggers(List<Trigger<?>> inputTriggers) throws IOException {
        this.triggers = null;
        BulkChange bc = new BulkChange((Saveable)this);
        try {
            PipelineTriggersJobProperty originalProp = this.getTriggersJobProperty();
            this.removeProperty(PipelineTriggersJobProperty.class);
            PipelineTriggersJobProperty triggerProp = new PipelineTriggersJobProperty(null);
            triggerProp.setTriggers(inputTriggers);
            this.addProperty(triggerProp);
            bc.commit();
            originalProp.stopTriggers();
        }
        finally {
            bc.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTrigger(Trigger trigger) throws IOException {
        BulkChange bc = new BulkChange((Saveable)this);
        try {
            PipelineTriggersJobProperty originalProp = this.getTriggersJobProperty();
            Trigger old = originalProp.getTriggerForDescriptor(trigger.getDescriptor());
            if (old != null) {
                originalProp.removeTrigger(old);
                old.stop();
            }
            originalProp.addTrigger(trigger);
            this.removeProperty(PipelineTriggersJobProperty.class);
            this.addProperty(originalProp);
            bc.commit();
        }
        finally {
            bc.abort();
        }
    }

    public void removeProperty(JobProperty jobProperty) throws IOException {
        if (jobProperty instanceof PipelineTriggersJobProperty) {
            ((PipelineTriggersJobProperty)jobProperty).stopTriggers();
        }
        super.removeProperty(jobProperty);
    }

    public void addAction(Action a) {
        super.getActions().add(a);
    }

    public void replaceAction(Action a) {
        ArrayList<Action> old = new ArrayList<Action>(1);
        List current = super.getActions();
        for (Action a2 : current) {
            if (a2.getClass() != a.getClass()) continue;
            old.add(a2);
        }
        current.removeAll(old);
        this.addAction(a);
    }

    public Item asItem() {
        return this;
    }

    public SCMTrigger getSCMTrigger() {
        for (Trigger<?> t : this.getTriggersJobProperty().getTriggers()) {
            if (!(t instanceof SCMTrigger)) continue;
            return (SCMTrigger)t;
        }
        return null;
    }

    public Collection<? extends SCM> getSCMs() {
        WorkflowRun b = (WorkflowRun)this.getLastSuccessfulBuild();
        if (b == null) {
            b = (WorkflowRun)this.getLastCompletedBuild();
        }
        if (b == null) {
            return Collections.emptySet();
        }
        LinkedHashMap<String, SCM> scms = new LinkedHashMap<String, SCM>();
        for (WorkflowRun.SCMCheckout co : b.checkouts(null)) {
            scms.put(co.scm.getKey(), co.scm);
        }
        return scms.values();
    }

    @CheckForNull
    public SCM getTypicalSCM() {
        SCM typical = null;
        for (SCM sCM : this.getSCMs()) {
            if (typical == null) {
                typical = sCM;
                continue;
            }
            if (typical.getDescriptor() == sCM.getDescriptor()) continue;
            return null;
        }
        return typical;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="TODO 1.653+ switch to Jenkins.getInstanceOrNull")
    public PollingResult poll(TaskListener listener) {
        if (!this.isBuildable()) {
            listener.getLogger().println("Build disabled");
            return PollingResult.NO_CHANGES;
        }
        WorkflowRun lastBuild = this.getLastBuild();
        if (lastBuild == null) {
            listener.getLogger().println("no previous build to compare to");
            return Queue.getInstance().contains((Queue.Task)this) ? PollingResult.NO_CHANGES : PollingResult.BUILD_NOW;
        }
        WorkflowRun perhapsCompleteBuild = (WorkflowRun)this.getLastSuccessfulBuild();
        if (perhapsCompleteBuild == null) {
            perhapsCompleteBuild = lastBuild;
        }
        if (this.pollingBaselines == null) {
            this.pollingBaselines = new ConcurrentHashMap<String, SCMRevisionState>();
        }
        PollingResult result = PollingResult.NO_CHANGES;
        for (WorkflowRun.SCMCheckout co : perhapsCompleteBuild.checkouts(listener)) {
            if (!co.scm.supportsPolling()) {
                listener.getLogger().println("polling not supported from " + co.workspace + " on " + co.node);
                continue;
            }
            String key = co.scm.getKey();
            SCMRevisionState pollingBaseline = this.pollingBaselines.get(key);
            if (pollingBaseline == null) {
                pollingBaseline = co.pollingBaseline;
            }
            if (pollingBaseline == null) {
                listener.getLogger().println("no polling baseline in " + co.workspace + " on " + co.node);
                continue;
            }
            try {
                PollingResult r;
                WorkspaceList.Lease lease;
                Launcher launcher;
                FilePath workspace;
                if (co.scm.requiresWorkspaceForPolling()) {
                    Jenkins j = Jenkins.getInstance();
                    if (j == null) {
                        listener.error("Jenkins is shutting down");
                        continue;
                    }
                    Computer c = j.getComputer(co.node);
                    if (c == null) {
                        listener.error("no such computer " + co.node);
                        continue;
                    }
                    workspace = new FilePath(c.getChannel(), co.workspace);
                    launcher = workspace.createLauncher(listener).decorateByEnv(this.getEnvironment(c.getNode(), listener));
                    lease = c.getWorkspaceList().acquire(workspace, !this.isConcurrentBuild());
                } else {
                    workspace = null;
                    launcher = null;
                    lease = null;
                }
                try {
                    r = co.scm.compareRemoteRevisionWith((Job)this, launcher, workspace, listener, pollingBaseline);
                    if (r.remote != null) {
                        this.pollingBaselines.put(key, r.remote);
                    }
                }
                finally {
                    if (lease != null) {
                        lease.release();
                    }
                }
                if (r.change.compareTo((Enum)result.change) <= 0) continue;
                result = r;
            }
            catch (AbortException x) {
                listener.error("polling failed in " + co.workspace + " on " + co.node + ": " + x.getMessage());
            }
            catch (Exception x) {
                listener.error("polling failed in " + co.workspace + " on " + co.node).println(Functions.printThrowable((Throwable)x).trim());
            }
        }
        return result;
    }

    protected void performDelete() throws IOException, InterruptedException {
        this.makeDisabled(true);
        super.performDelete();
    }

    @Initializer(before=InitMilestone.EXTENSIONS_AUGMENTED)
    public static void alias() {
        Items.XSTREAM2.alias("flow-definition", WorkflowJob.class);
        WorkflowRun.alias();
    }

    @Extension(ordinal=1.0)
    public static final class DescriptorImpl
    extends TopLevelItemDescriptor {
        public String getDisplayName() {
            return Messages.WorkflowJob_DisplayName();
        }

        public TopLevelItem newInstance(ItemGroup parent, String name) {
            return new WorkflowJob(parent, name);
        }

        public String getCategoryId() {
            return "standalone-projects";
        }

        public String getDescription() {
            return Messages.WorkflowJob_Description();
        }

        public String getIconFilePathPattern() {
            return "plugin/workflow-job/images/:size/pipelinejob.png";
        }

        @Restricted(value={DoNotUse.class})
        public Collection<FlowDefinitionDescriptor> getDefinitionDescriptors(WorkflowJob context) {
            return DescriptorVisibilityFilter.apply((Object)((Object)context), (Iterable)ExtensionList.lookup(FlowDefinitionDescriptor.class));
        }
    }

    @Extension
    public static final class SCMListenerImpl
    extends SCMListener {
        public void onCheckout(Run<?, ?> build, SCM scm, FilePath workspace, TaskListener listener, File changelogFile, SCMRevisionState pollingBaseline) throws Exception {
            if (build instanceof WorkflowRun && pollingBaseline != null) {
                WorkflowJob job = (WorkflowJob)((WorkflowRun)build).getParent();
                if (job.pollingBaselines == null) {
                    job.pollingBaselines = new ConcurrentHashMap();
                }
                job.pollingBaselines.put(scm.getKey(), pollingBaseline);
            }
        }
    }
}

