/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.job;

import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.BulkChange;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Functions;
import hudson.XmlFile;
import hudson.console.AnnotatedLargeText;
import hudson.console.LineTransformationOutputStream;
import hudson.console.ModelHyperlinkNote;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Executor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.StreamBuildListener;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.model.listeners.RunListener;
import hudson.model.listeners.SCMListener;
import hudson.model.listeners.SaveableListener;
import hudson.remoting.Callable;
import hudson.scm.ChangeLogSet;
import hudson.scm.SCM;
import hudson.scm.SCMRevisionState;
import hudson.security.ACL;
import hudson.slaves.NodeProperty;
import hudson.util.DaemonThreadFactory;
import hudson.util.Iterators;
import hudson.util.NamingThreadFactory;
import hudson.util.NullStream;
import hudson.util.PersistedList;
import hudson.util.XStream2;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import jenkins.model.CauseOfInterruption;
import jenkins.model.Jenkins;
import jenkins.model.lazy.BuildReference;
import jenkins.model.lazy.LazyBuildMixIn;
import jenkins.model.queue.AsynchronousExecution;
import jenkins.scm.RunWithSCM;
import jenkins.security.NotReallyRoleSensitiveCallable;
import jenkins.util.Timer;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.workflow.FilePathUtils;
import org.jenkinsci.plugins.workflow.actions.LogAction;
import org.jenkinsci.plugins.workflow.actions.ThreadNameAction;
import org.jenkinsci.plugins.workflow.actions.TimingAction;
import org.jenkinsci.plugins.workflow.flow.BlockableResume;
import org.jenkinsci.plugins.workflow.flow.DurabilityHintProvider;
import org.jenkinsci.plugins.workflow.flow.FlowCopier;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDurabilityHint;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionList;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionListener;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.flow.GraphListener;
import org.jenkinsci.plugins.workflow.flow.StashManager;
import org.jenkinsci.plugins.workflow.graph.BlockEndNode;
import org.jenkinsci.plugins.workflow.graph.BlockStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowEndNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.job.AfterRestartTask;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.console.WorkflowConsoleLogger;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.support.PipelineIOUtils;
import org.jenkinsci.plugins.workflow.support.concurrent.Futures;
import org.jenkinsci.plugins.workflow.support.concurrent.WithThreadName;
import org.jenkinsci.plugins.workflow.support.steps.input.POSTHyperlinkNote;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.interceptor.RequirePOST;

@SuppressFBWarnings(value={"RC_REF_COMPARISON_BAD_PRACTICE_BOOLEAN"}, justification="For Boolean comparison, this is for deserializing handle null completion states from legacy builds")
public final class WorkflowRun
extends Run<WorkflowJob, WorkflowRun>
implements FlowExecutionOwner.Executable,
LazyBuildMixIn.LazyLoadingRun<WorkflowJob, WorkflowRun>,
RunWithSCM<WorkflowJob, WorkflowRun> {
    private static final Logger LOGGER = Logger.getLogger(WorkflowRun.class.getName());
    @CheckForNull
    volatile FlowExecution execution;
    @CheckForNull
    private volatile transient SettableFuture<FlowExecution> executionPromise = SettableFuture.create();
    private final transient LazyBuildMixIn.RunMixIn<WorkflowJob, WorkflowRun> runMixIn = new LazyBuildMixIn.RunMixIn<WorkflowJob, WorkflowRun>(){

        protected WorkflowRun asRun() {
            return WorkflowRun.this;
        }
    };
    private transient StreamBuildListener listener;
    private transient boolean allowTerm;
    private transient boolean allowKill;
    volatile transient boolean executionLoaded = false;
    private volatile Set<String> culprits;
    Boolean completed;
    private transient Object logCopyGuard = new Object();
    Map<String, Long> logsToCopy;
    @CheckForNull
    private List<SCMCheckout> checkouts;
    private transient List<ChangeLogSet<? extends ChangeLogSet.Entry>> changeSets;
    private transient boolean firstTime;
    static final StreamBuildListener NULL_LISTENER = new StreamBuildListener((OutputStream)new NullStream());
    private static ScheduledExecutorService copyLogsExecutorService;
    @GuardedBy(value="logCopyGuard")
    private volatile transient Cache<FlowNode, Optional<String>> branchNameCache;
    private static final Map<String, WorkflowRun> LOADING_RUNS;

    private synchronized Object getLogCopyGuard() {
        if (this.logCopyGuard == null) {
            this.logCopyGuard = new Object();
        }
        return this.logCopyGuard;
    }

    StreamBuildListener getListener() {
        if (this.listener == null) {
            try {
                FileOutputStream logger = new FileOutputStream(this.getLogFile(), true);
                this.listener = new StreamBuildListener((OutputStream)logger, Charset.defaultCharset());
            }
            catch (FileNotFoundException fnf) {
                LOGGER.log(Level.WARNING, "Error trying to open build log file for writing, output will be lost: " + this.getLogFile(), fnf);
                return NULL_LISTENER;
            }
        }
        return this.listener;
    }

    public WorkflowRun(WorkflowJob job) throws IOException {
        super((Job)job);
        this.firstTime = true;
        this.checkouts = new PersistedList((Saveable)this);
    }

    public WorkflowRun(WorkflowJob job, File dir) throws IOException {
        super((Job)job, dir);
    }

    public LazyBuildMixIn.RunMixIn<WorkflowJob, WorkflowRun> getRunMixIn() {
        return this.runMixIn;
    }

    protected BuildReference<WorkflowRun> createReference() {
        return this.getRunMixIn().createReference();
    }

    protected void dropLinks() {
        this.getRunMixIn().dropLinks();
    }

    @Exported
    public WorkflowRun getPreviousBuild() {
        return (WorkflowRun)this.getRunMixIn().getPreviousBuild();
    }

    @Exported
    public WorkflowRun getNextBuild() {
        return (WorkflowRun)this.getRunMixIn().getNextBuild();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (!this.firstTime) {
            throw this.sleep();
        }
        try {
            this.onStartBuilding();
            StreamBuildListener myListener = this.getListener();
            myListener.started(this.getCauses());
            Authentication auth = Jenkins.getAuthentication();
            if (!auth.equals(ACL.SYSTEM)) {
                String name = auth.getName();
                if (!auth.equals(Jenkins.ANONYMOUS)) {
                    name = ModelHyperlinkNote.encodeTo((User)User.get((String)name));
                }
                myListener.getLogger().println("Running as " + name);
            }
            RunListener.fireStarted((Run)this, (TaskListener)myListener);
            this.updateSymlinks((TaskListener)myListener);
            FlowDefinition definition = ((WorkflowJob)this.getParent()).getDefinition();
            if (definition == null) {
                throw new AbortException("No flow definition, cannot run");
            }
            Owner owner = new Owner(this);
            FlowExecution newExecution = definition.create((FlowExecutionOwner)owner, (TaskListener)myListener, this.getAllActions());
            boolean loggedHintOverride = false;
            if (newExecution instanceof BlockableResume) {
                boolean blockResume = ((WorkflowJob)this.getParent()).isResumeBlocked();
                ((BlockableResume)newExecution).setResumeBlocked(blockResume);
                if (blockResume) {
                    this.listener.getLogger().println("Resume disabled by user, switching to high-performance, low-durability mode.");
                    loggedHintOverride = true;
                }
            }
            if (!loggedHintOverride) {
                myListener.getLogger().println("Running in Durability level: " + DurabilityHintProvider.suggestedFor((Item)this.project));
            }
            this.save();
            Object blockResume = this.getLogCopyGuard();
            synchronized (blockResume) {
                FlowExecutionList.get().register((FlowExecutionOwner)owner);
                newExecution.addListener((GraphListener)new GraphL());
                this.completed = Boolean.FALSE;
                this.logsToCopy = new ConcurrentSkipListMap<String, Long>();
                this.executionLoaded = true;
                this.execution = newExecution;
            }
            SettableFuture<FlowExecution> exec = this.getSettableExecutionPromise();
            if (!exec.isDone()) {
                exec.set((Object)newExecution);
            }
            newExecution.start();
            FlowExecutionListener.fireRunning((FlowExecution)newExecution);
        }
        catch (Throwable x) {
            block16: {
                this.execution = null;
                this.executionLoaded = true;
                this.finish(Result.FAILURE, x);
                try {
                    SettableFuture<FlowExecution> exec = this.getSettableExecutionPromise();
                    if (!exec.isDone()) {
                        exec.setException(x);
                    }
                }
                catch (Error e) {
                    if (e == x) break block16;
                    throw e;
                }
            }
            return;
        }
        throw this.sleep();
    }

    private static synchronized ScheduledExecutorService copyLogsExecutorService() {
        if (copyLogsExecutorService == null) {
            copyLogsExecutorService = new ScheduledThreadPoolExecutor(5, (ThreadFactory)new NamingThreadFactory((ThreadFactory)new DaemonThreadFactory(), "WorkflowRun.copyLogs"));
        }
        return copyLogsExecutorService;
    }

    private AsynchronousExecution sleep() {
        final AsynchronousExecution asynchronousExecution = new AsynchronousExecution(){

            public void interrupt(boolean forShutdown) {
                if (forShutdown) {
                    return;
                }
                Timer.get().submit(new Runnable(){

                    @Override
                    public void run() {
                        FlowExecution fetchedExecution = WorkflowRun.this.execution;
                        if (fetchedExecution == null) {
                            return;
                        }
                        Executor executor = this.getExecutor();
                        if (executor == null) {
                            LOGGER.log(Level.WARNING, "Lost executor for {0}", (Object)WorkflowRun.this);
                            return;
                        }
                        try {
                            Collection causes = executor.getCausesOfInterruption();
                            fetchedExecution.interrupt(executor.abortResult(), causes.toArray(new CauseOfInterruption[causes.size()]));
                        }
                        catch (Exception x) {
                            LOGGER.log(Level.WARNING, null, x);
                        }
                        executor.recordCauseOfInterruption((Run)WorkflowRun.this, (TaskListener)WorkflowRun.this.getListener());
                        WorkflowRun.this.printLater(StopState.TERM, "Click here to forcibly terminate running steps");
                    }
                });
            }

            public boolean blocksRestart() {
                FlowExecution exec = WorkflowRun.this.getExecution();
                return exec != null && exec.blocksRestart();
            }

            public boolean displayCell() {
                return this.blocksRestart();
            }
        };
        final AtomicReference copyLogsTask = new AtomicReference();
        copyLogsTask.set(WorkflowRun.copyLogsExecutorService().scheduleAtFixedRate(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = WorkflowRun.this.getLogCopyGuard();
                synchronized (object) {
                    if (WorkflowRun.this.completed == null) {
                        return;
                    }
                    if (WorkflowRun.this.completed.booleanValue()) {
                        asynchronousExecution.completed(null);
                        ((ScheduledFuture)copyLogsTask.get()).cancel(false);
                        return;
                    }
                    Jenkins jenkins = Jenkins.getInstance();
                    if (jenkins == null || jenkins.isTerminating()) {
                        LOGGER.log(Level.FINE, "shutting down, breaking waitForCompletion on {0}", this);
                        WorkflowRun.this.getListener().closeQuietly();
                        WorkflowRun.this.listener = NULL_LISTENER;
                        return;
                    }
                    try (WithThreadName naming = new WithThreadName(" (" + (Object)((Object)WorkflowRun.this) + ")");){
                        WorkflowRun.this.copyLogs();
                    }
                }
            }
        }, 1L, 1L, TimeUnit.SECONDS));
        return asynchronousExecution;
    }

    private void printLater(final StopState state, final String message) {
        Timer.get().schedule(new Runnable(){

            @Override
            public void run() {
                if (!WorkflowRun.this.isInProgress()) {
                    return;
                }
                switch (state) {
                    case TERM: {
                        WorkflowRun.this.allowTerm = true;
                        break;
                    }
                    case KILL: {
                        WorkflowRun.this.allowKill = true;
                    }
                }
                WorkflowRun.this.getListener().getLogger().println(POSTHyperlinkNote.encodeTo((String)("/" + WorkflowRun.this.getUrl() + state.url()), (String)message));
            }
        }, 15L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequirePOST
    public void doTerm() {
        this.checkPermission(Item.CANCEL);
        if (!this.isInProgress() || this.execution == null) {
            return;
        }
        FlowInterruptedException x = new FlowInterruptedException(Result.ABORTED, new CauseOfInterruption[0]);
        FlowExecution exec = this.getExecution();
        if (exec == null) {
            Object object = this.getLogCopyGuard();
            synchronized (object) {
                boolean modified = false;
                if (this.result == null) {
                    this.setResult(Result.FAILURE);
                    modified = true;
                }
                if (this.completed != Boolean.TRUE) {
                    this.completed = true;
                    modified = true;
                }
                if (modified) {
                    this.saveWithoutFailing();
                }
                return;
            }
        }
        Futures.addCallback((ListenableFuture)exec.getCurrentExecutions(true), (FutureCallback)new FutureCallback<List<StepExecution>>((Throwable)x){
            final /* synthetic */ Throwable val$x;
            {
                this.val$x = throwable;
            }

            public void onSuccess(List<StepExecution> l) {
                for (StepExecution e : Iterators.reverse(l)) {
                    StepContext context = e.getContext();
                    context.onFailure(this.val$x);
                    try {
                        FlowNode n = (FlowNode)context.get(FlowNode.class);
                        if (n == null) continue;
                        WorkflowRun.this.getListener().getLogger().println("Terminating " + n.getDisplayFunctionName());
                    }
                    catch (Exception x) {
                        LOGGER.log(Level.FINE, null, x);
                    }
                }
            }

            public void onFailure(Throwable t) {
            }
        });
        this.printLater(StopState.KILL, "Click here to forcibly kill entire build");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequirePOST
    public void doKill() {
        this.checkPermission(Item.CANCEL);
        if (!this.isBuilding() || this.execution == null) {
            return;
        }
        Object object = this.getLogCopyGuard();
        synchronized (object) {
            this.getListener().getLogger().println("Hard kill!");
        }
        object = this;
        synchronized (object) {
            this.execution = null;
            this.executionLoaded = true;
        }
        FlowInterruptedException suddenDeath = new FlowInterruptedException(Result.ABORTED, new CauseOfInterruption[0]);
        this.finish(Result.ABORTED, (Throwable)suddenDeath);
        this.getSettableExecutionPromise().setException((Throwable)suddenDeath);
    }

    public EnvVars getEnvironment(TaskListener listener) throws IOException, InterruptedException {
        ParametersAction a;
        EnvVars env = super.getEnvironment(listener);
        Jenkins instance = Jenkins.getInstance();
        if (instance != null) {
            for (NodeProperty nodeProperty : instance.getGlobalNodeProperties()) {
                nodeProperty.buildEnvVars(env, listener);
            }
        }
        if ((a = (ParametersAction)this.getAction(ParametersAction.class)) != null) {
            for (ParameterValue v : a) {
                v.buildEnvironment((Run)this, env);
            }
        }
        EnvVars.resolve((Map)env);
        return env;
    }

    @Restricted(value={DoNotUse.class})
    public boolean hasAllowTerm() {
        return this.isBuilding() && this.allowTerm;
    }

    @Restricted(value={DoNotUse.class})
    public boolean hasAllowKill() {
        return this.isBuilding() && this.allowKill;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="logCopyGuard")
    private void copyLogs() {
        if (this.logsToCopy == null) {
            return;
        }
        if (this.logsToCopy instanceof LinkedHashMap) {
            this.logsToCopy = new ConcurrentSkipListMap<String, Long>(this.logsToCopy);
        }
        boolean modified = false;
        FlowExecution exec = this.getExecution();
        if (exec == null) {
            this.logsToCopy.clear();
            this.saveWithoutFailing();
            return;
        }
        for (Map.Entry<String, Long> entry : this.logsToCopy.entrySet()) {
            FlowNode node;
            String id = entry.getKey();
            try {
                node = exec.getNode(id);
            }
            catch (IOException x) {
                LOGGER.log(Level.WARNING, null, x);
                this.logsToCopy.remove(id);
                modified = true;
                continue;
            }
            if (node == null) {
                LOGGER.log(Level.WARNING, "no such node {0}", id);
                this.logsToCopy.remove(id);
                modified = true;
                continue;
            }
            LogAction la = (LogAction)node.getAction(LogAction.class);
            if (la != null) {
                AnnotatedLargeText logText = la.getLogText();
                try {
                    long old = entry.getValue();
                    String prefix = this.getBranchName(node);
                    Object logger = prefix != null ? new LogLinePrefixOutputFilter(this.getListener().getLogger(), "[" + prefix + "] ") : this.getListener().getLogger();
                    try {
                        long revised = this.writeRawLogTo((AnnotatedLargeText<?>)logText, old, (OutputStream)logger);
                        if (revised != old) {
                            this.logsToCopy.put(id, revised);
                            modified = true;
                        }
                        if (!logText.isComplete()) continue;
                        this.writeRawLogTo((AnnotatedLargeText<?>)logText, revised, (OutputStream)logger);
                        assert (!node.isRunning()) : "LargeText.complete yet " + node + " claims to still be running";
                        this.logsToCopy.remove(id);
                        modified = true;
                    }
                    finally {
                        if (prefix != null) {
                            ((LogLinePrefixOutputFilter)((Object)logger)).forceEol();
                        }
                    }
                }
                catch (IOException x) {
                    LOGGER.log(Level.WARNING, null, x);
                    this.logsToCopy.remove(id);
                    modified = true;
                }
                continue;
            }
            if (node.isRunning()) continue;
            this.logsToCopy.remove(id);
            modified = true;
        }
        if (modified && exec.getDurabilityHint().isPersistWithEveryStep()) {
            this.saveWithoutFailing();
        }
    }

    private long writeRawLogTo(AnnotatedLargeText<?> text, long start, OutputStream out) throws IOException {
        long len = text.length();
        if (start > len) {
            LOGGER.log(Level.WARNING, "JENKINS-37664: attempt to copy logs in {0} @{1} past end @{2}", new Object[]{this, start, len});
            return len;
        }
        return text.writeRawLogTo(start, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache<FlowNode, Optional<String>> getBranchNameCache() {
        if (this.branchNameCache == null) {
            Object object = this.getLogCopyGuard();
            synchronized (object) {
                if (this.branchNameCache == null) {
                    this.branchNameCache = CacheBuilder.newBuilder().weakKeys().build();
                }
            }
        }
        return this.branchNameCache;
    }

    @CheckForNull
    private String getBranchName(FlowNode node) {
        FlowNode parent;
        ThreadNameAction threadNameAction;
        Cache<FlowNode, Optional<String>> cache = this.getBranchNameCache();
        Optional output = (Optional)cache.getIfPresent((Object)node);
        if (output != null) {
            return (String)output.orNull();
        }
        if (node instanceof BlockEndNode) {
            output = Optional.fromNullable((Object)this.getBranchName((FlowNode)((BlockEndNode)node).getStartNode()));
            cache.put((Object)node, (Object)output);
            return (String)output.orNull();
        }
        if (node instanceof BlockStartNode && (threadNameAction = (ThreadNameAction)node.getPersistentAction(ThreadNameAction.class)) != null) {
            String name = threadNameAction.getThreadName();
            cache.put((Object)node, (Object)Optional.of((Object)name));
            return name;
        }
        List parents = node.getParents();
        if (!parents.isEmpty() && (output = (Optional)cache.getIfPresent((Object)(parent = (FlowNode)parents.get(0)))) != null) {
            cache.put((Object)node, (Object)output);
            return (String)output.orNull();
        }
        output = Optional.absent();
        for (BlockStartNode myNode : node.iterateEnclosingBlocks()) {
            ThreadNameAction threadNameAction2 = (ThreadNameAction)myNode.getPersistentAction(ThreadNameAction.class);
            if (threadNameAction2 == null) continue;
            output = Optional.of((Object)threadNameAction2.getThreadName());
            break;
        }
        cache.put((Object)node, (Object)output);
        return (String)output.orNull();
    }

    private String key() {
        return ((WorkflowJob)this.getParent()).getFullName() + '/' + this.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() throws IOException {
        Map<String, WorkflowRun> map = LOADING_RUNS;
        synchronized (map) {
            LOADING_RUNS.put(this.key(), this);
        }
        new XmlFile(XSTREAM, new File(this.getRootDir(), "build.xml")).unmarshal((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onLoad() {
        try {
            Map<String, WorkflowRun> map = this.getLogCopyGuard();
            synchronized (map) {
                block28: {
                    if (!this.executionLoaded) break block28;
                    LOGGER.log(Level.WARNING, "Double onLoad of build " + (Object)((Object)this));
                    return;
                }
                boolean needsToPersist = this.completed == null;
                super.onLoad();
                if (this.completed == Boolean.TRUE && this.result == null) {
                    LOGGER.log(Level.FINE, "Completed build with no result set, defaulting to failure for " + (Object)((Object)this));
                    this.setResult(Result.FAILURE);
                    needsToPersist = true;
                }
                if (this.execution != null && this.completed != Boolean.TRUE) {
                    FlowExecution fetchedExecution = this.getExecution();
                    if (fetchedExecution != null) {
                        if (this.completed == null) {
                            this.completed = fetchedExecution.isComplete();
                        }
                        if (this.completed == false == Boolean.TRUE) {
                            FlowExecutionListener.fireResumed((FlowExecution)fetchedExecution);
                            this.getListener().getLogger().println("Resuming build at " + new Date() + " after Jenkins restart");
                            Timer.get().submit(() -> Queue.getInstance().schedule((Queue.Task)new AfterRestartTask(this), 0));
                        }
                    } else {
                        this.completed = Boolean.TRUE;
                    }
                } else if (this.execution == null) {
                    this.completed = Boolean.TRUE;
                }
                if (needsToPersist && this.completed.booleanValue()) {
                    try {
                        this.save();
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.WARNING, "Error while saving build to update completed flag " + (Object)((Object)this), ex);
                    }
                }
            }
        }
        finally {
            this.checkouts(null);
            Map<String, WorkflowRun> map = LOADING_RUNS;
            synchronized (map) {
                LOADING_RUNS.remove(this.key());
                LOADING_RUNS.notifyAll();
            }
        }
    }

    public void setResult(Result r) {
        if (this.result == null || r.isWorseThan(this.result)) {
            this.result = r;
            LOGGER.log(Level.FINE, (Object)((Object)this) + " in " + this.getRootDir() + ": result is set to " + r, LOGGER.isLoggable(Level.FINER) ? new Exception() : null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish(@Nonnull Result r, @CheckForNull Throwable t) {
        boolean nullListener = false;
        Object object = this.getLogCopyGuard();
        synchronized (object) {
            nullListener = this.listener == null;
            this.setResult(r);
            this.completed = Boolean.TRUE;
            this.duration = Math.max(0L, System.currentTimeMillis() - this.getStartTimeInMillis());
        }
        this.logsToCopy = null;
        this.branchNameCache = null;
        try {
            LOGGER.log(Level.INFO, "{0} completed: {1}", new Object[]{this.toString(), this.getResult()});
            if (nullListener) {
                LOGGER.log(Level.WARNING, (Object)((Object)this) + " failed to start", t);
            } else {
                RunListener.fireCompleted((Run)this, (TaskListener)this.getListener());
                if (t instanceof AbortException) {
                    this.getListener().error(t.getMessage());
                } else if (t instanceof FlowInterruptedException) {
                    ((FlowInterruptedException)t).handle((Run)this, (TaskListener)this.getListener());
                } else if (t != null) {
                    Functions.printStackTrace((Throwable)t, (PrintStream)this.getListener().getLogger());
                }
                this.getListener().finished(this.getResult());
                this.getListener().closeQuietly();
            }
            this.logsToCopy = null;
            this.saveWithoutFailing();
            Timer.get().submit(() -> {
                try {
                    ((WorkflowJob)this.getParent()).logRotate();
                }
                catch (Exception x) {
                    LOGGER.log(Level.WARNING, "failed to perform log rotation after " + (Object)((Object)this), x);
                }
            });
            this.onEndBuilding();
        }
        finally {
            FlowExecutionList.get().unregister((FlowExecutionOwner)new Owner(this));
        }
        try {
            StashManager.maybeClearAll((Run)this);
        }
        catch (IOException x) {
            LOGGER.log(Level.WARNING, "failed to clean up stashes from " + (Object)((Object)this), x);
        }
        FlowExecution exec = this.getExecution();
        if (exec != null) {
            FlowExecutionListener.fireCompleted((FlowExecution)exec);
        }
    }

    public void deleteArtifacts() throws IOException {
        super.deleteArtifacts();
        StashManager.clearAll((Run)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public FlowExecution getExecution() {
        if (this.executionLoaded || this.execution == null) {
            return this.execution;
        }
        WorkflowRun workflowRun = this;
        synchronized (workflowRun) {
            FlowExecution fetchedExecution = this.execution;
            if (this.executionLoaded || fetchedExecution == null) {
                return fetchedExecution;
            }
            try {
                SettableFuture<FlowExecution> settablePromise;
                if (fetchedExecution instanceof BlockableResume) {
                    BlockableResume blockableExecution = (BlockableResume)fetchedExecution;
                    boolean parentBlocked = ((WorkflowJob)this.getParent()).isResumeBlocked();
                    if (parentBlocked != blockableExecution.isResumeBlocked()) {
                        blockableExecution.setResumeBlocked(parentBlocked);
                    }
                }
                FailOnLoadListener finishListener = null;
                if (this.completed != Boolean.TRUE) {
                    finishListener = new FailOnLoadListener();
                    fetchedExecution.addListener((GraphListener)finishListener);
                }
                fetchedExecution.onLoad((FlowExecutionOwner)new Owner(this));
                if (this.completed != Boolean.TRUE) {
                    fetchedExecution.removeListener((GraphListener)finishListener);
                    fetchedExecution.addListener((GraphListener)new GraphL());
                }
                if (!(settablePromise = this.getSettableExecutionPromise()).isDone()) {
                    settablePromise.set((Object)fetchedExecution);
                }
                this.executionLoaded = true;
                return fetchedExecution;
            }
            catch (Exception x) {
                if (this.result == null) {
                    this.setResult(Result.FAILURE);
                }
                LOGGER.log(Level.WARNING, "Nulling out FlowExecution due to error in build " + (Object)((Object)this), x);
                this.execution = null;
                this.executionLoaded = true;
                this.saveWithoutFailing();
                return null;
            }
        }
    }

    @Nonnull
    public ListenableFuture<FlowExecution> getExecutionPromise() {
        return this.getSettableExecutionPromise();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private SettableFuture<FlowExecution> getSettableExecutionPromise() {
        SettableFuture execOut = this.executionPromise;
        if (execOut == null) {
            WorkflowRun workflowRun = this;
            synchronized (workflowRun) {
                execOut = this.executionPromise;
                if (execOut == null) {
                    this.executionPromise = execOut = SettableFuture.create();
                }
                return execOut;
            }
        }
        return execOut;
    }

    public FlowExecutionOwner asFlowExecutionOwner() {
        return new Owner(this);
    }

    public boolean hasntStartedYet() {
        return this.result == null && this.execution == null;
    }

    public boolean isBuilding() {
        return this.result == null || this.isInProgress();
    }

    @Exported
    protected boolean isInProgress() {
        if (this.completed == Boolean.TRUE) {
            return false;
        }
        FlowExecution exec = this.getExecution();
        return exec != null && !exec.isComplete();
    }

    public boolean isLogUpdated() {
        return this.isBuilding();
    }

    @Nonnull
    synchronized List<SCMCheckout> checkouts(@CheckForNull TaskListener listener) {
        if (this.checkouts == null) {
            LOGGER.log(Level.WARNING, "JENKINS-26761: no checkouts in {0}", (Object)this);
            if (listener != null) {
                listener.error("JENKINS-26761: list of SCM checkouts in " + (Object)((Object)this) + " was lost; polling will be broken");
            }
            this.checkouts = new PersistedList((Saveable)this);
        }
        return this.checkouts;
    }

    @Exported
    public synchronized List<ChangeLogSet<? extends ChangeLogSet.Entry>> getChangeSets() {
        if (this.changeSets == null) {
            this.changeSets = new ArrayList<ChangeLogSet<? extends ChangeLogSet.Entry>>();
            for (SCMCheckout co : this.checkouts(null)) {
                if (co.changelogFile == null || !co.changelogFile.isFile()) continue;
                try {
                    ChangeLogSet changeLogSet = co.scm.createChangeLogParser().parse((Run)this, co.scm.getEffectiveBrowser(), co.changelogFile);
                    if (changeLogSet.isEmptySet()) continue;
                    this.changeSets.add((ChangeLogSet<? extends ChangeLogSet.Entry>)changeLogSet);
                }
                catch (Exception x) {
                    LOGGER.log(Level.WARNING, "could not parse " + co.changelogFile, x);
                }
            }
        }
        return this.changeSets;
    }

    @CheckForNull
    public Set<String> getCulpritIds() {
        if (this.shouldCalculateCulprits()) {
            HashSet<String> tempCulpritIds = new HashSet<String>();
            for (User u : this.getCulprits()) {
                tempCulpritIds.add(u.getId());
            }
            if (this.isBuilding()) {
                return ImmutableSortedSet.copyOf(tempCulpritIds);
            }
            this.culprits = ImmutableSortedSet.copyOf(tempCulpritIds);
        }
        return this.culprits;
    }

    @Exported
    @Nonnull
    public Set<User> getCulprits() {
        return super.getCulprits();
    }

    public boolean shouldCalculateCulprits() {
        return this.isBuilding() || this.culprits == null;
    }

    @RequirePOST
    public synchronized HttpResponse doStop() {
        Executor e = this.getOneOffExecutor();
        if (e != null) {
            return e.doStop();
        }
        this.doKill();
        return HttpResponses.forwardToPreviousPage();
    }

    private void onCheckout(SCM scm, FilePath workspace, TaskListener listener, @CheckForNull File changelogFile, @CheckForNull SCMRevisionState pollingBaseline) throws Exception {
        if (changelogFile != null && changelogFile.isFile()) {
            ChangeLogSet cls = scm.createChangeLogParser().parse((Run)this, scm.getEffectiveBrowser(), changelogFile);
            if (!cls.isEmptySet()) {
                this.getChangeSets().add((ChangeLogSet<? extends ChangeLogSet.Entry>)cls);
            }
            for (SCMListener l : SCMListener.all()) {
                l.onChangeLogParsed((Run)this, scm, listener, cls);
            }
        }
        this.checkouts(listener).add(new SCMCheckout(scm, FilePathUtils.getNodeName((FilePath)workspace), workspace.getRemote(), changelogFile, pollingBaseline));
    }

    private void logNodeMessage(FlowNode node) {
        WorkflowConsoleLogger wfLogger = new WorkflowConsoleLogger((BuildListener)this.getListener());
        String prefix = this.getBranchName(node);
        if (prefix != null) {
            wfLogger.log(String.format("[%s] %s", prefix, node.getDisplayFunctionName()));
        } else {
            wfLogger.log(node.getDisplayFunctionName());
        }
        wfLogger.getLogger().flush();
    }

    static void alias() {
        Run.XSTREAM2.alias("flow-build", WorkflowRun.class);
        new XmlFile(null).getXStream().aliasType("flow-owner", Owner.class);
        Run.XSTREAM2.aliasType("flow-owner", Owner.class);
    }

    private void saveWithoutFailing() {
        try {
            this.save();
        }
        catch (Exception x) {
            LOGGER.log(Level.WARNING, "Failed to save " + (Object)((Object)this), x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        if (BulkChange.contains((Saveable)this)) {
            return;
        }
        File loc = new File(this.getRootDir(), "build.xml");
        XmlFile file = new XmlFile(XSTREAM, loc);
        boolean isAtomic = true;
        FlowExecution fetchedExecution = this.execution;
        if (fetchedExecution != null) {
            FlowDurabilityHint hint = fetchedExecution.getDurabilityHint();
            isAtomic = hint.isAtomicWrite();
        }
        WorkflowRun workflowRun = this;
        synchronized (workflowRun) {
            PipelineIOUtils.writeByXStream((Object)((Object)this), (File)loc, (XStream2)XSTREAM2, (boolean)isAtomic);
            SaveableListener.fireOnChange((Saveable)this, (XmlFile)file);
        }
    }

    static {
        LOADING_RUNS = new HashMap<String, WorkflowRun>();
    }

    @Restricted(value={DoNotUse.class})
    @Extension
    public static class Checkouts
    extends FlowCopier.ByRun {
        public void copy(Run<?, ?> original, Run<?, ?> copy, TaskListener listener) throws IOException, InterruptedException {
            if (original instanceof WorkflowRun && copy instanceof WorkflowRun) {
                ((WorkflowRun)copy).checkouts(null).addAll(((WorkflowRun)original).checkouts(null));
            }
        }
    }

    @Extension
    public static final class SCMListenerImpl
    extends SCMListener {
        public void onCheckout(Run<?, ?> build, SCM scm, FilePath workspace, TaskListener listener, File changelogFile, SCMRevisionState pollingBaseline) throws Exception {
            if (build instanceof WorkflowRun) {
                ((WorkflowRun)build).onCheckout(scm, workspace, listener, changelogFile, pollingBaseline);
            }
        }
    }

    private final class GraphL
    implements GraphListener {
        private GraphL() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNewHead(FlowNode node) {
            Object object = WorkflowRun.this.getLogCopyGuard();
            synchronized (object) {
                WorkflowRun.this.copyLogs();
                if (WorkflowRun.this.logsToCopy == null) {
                    WorkflowRun.this.logsToCopy = new HashMap<String, Long>(3);
                }
                WorkflowRun.this.logsToCopy.put(node.getId(), 0L);
            }
            if (node.getPersistentAction(TimingAction.class) == null) {
                node.addAction((Action)new TimingAction());
            }
            WorkflowRun.this.logNodeMessage(node);
            FlowExecution exec = WorkflowRun.this.getExecution();
            if (node instanceof FlowEndNode) {
                WorkflowRun.this.finish(((FlowEndNode)node).getResult(), exec != null ? exec.getCauseOfFailure() : null);
            } else if (exec != null && exec.getDurabilityHint().isPersistWithEveryStep()) {
                WorkflowRun.this.saveWithoutFailing();
            }
        }
    }

    private final class FailOnLoadListener
    implements GraphListener {
        private FailOnLoadListener() {
        }

        public void onNewHead(FlowNode node) {
            if (node instanceof FlowEndNode) {
                Timer.get().schedule(() -> {
                    Object object = WorkflowRun.this.getLogCopyGuard();
                    synchronized (object) {
                        WorkflowRun.this.finish(((FlowEndNode)node).getResult(), WorkflowRun.this.execution != null ? WorkflowRun.this.execution.getCauseOfFailure() : null);
                    }
                }, 1L, TimeUnit.SECONDS);
            }
        }
    }

    private static final class Owner
    extends FlowExecutionOwner {
        private final String job;
        private final String id;
        @CheckForNull
        private transient WorkflowRun run;
        private static final long serialVersionUID = 1L;

        Owner(WorkflowRun run) {
            this.job = ((WorkflowJob)run.getParent()).getFullName();
            this.id = run.getId();
            this.run = run;
        }

        private String key() {
            return this.job + '/' + this.id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nonnull
        private WorkflowRun run() throws IOException {
            if (this.run == null) {
                WorkflowRun candidate;
                Map map = LOADING_RUNS;
                synchronized (map) {
                    candidate = (WorkflowRun)((Object)LOADING_RUNS.get(this.key()));
                }
                if (candidate != null && ((WorkflowJob)candidate.getParent()).getFullName().equals(this.job) && candidate.getId().equals(this.id)) {
                    this.run = candidate;
                } else {
                    final Jenkins jenkins = Jenkins.getInstance();
                    if (jenkins == null) {
                        throw new IOException("Jenkins is not running");
                    }
                    WorkflowJob j = (WorkflowJob)((Object)ACL.impersonate((Authentication)ACL.SYSTEM, (Callable)new NotReallyRoleSensitiveCallable<WorkflowJob, IOException>(){

                        public WorkflowJob call() throws IOException {
                            return (WorkflowJob)jenkins.getItemByFullName(job, WorkflowJob.class);
                        }
                    }));
                    if (j == null) {
                        throw new IOException("no such WorkflowJob " + this.job);
                    }
                    this.run = (WorkflowRun)j._getRuns().getById(this.id);
                    if (this.run == null) {
                        throw new IOException("no such build " + this.id + " in " + this.job);
                    }
                }
            }
            return this.run;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FlowExecution get() throws IOException {
            WorkflowRun r = this.run();
            Map map = LOADING_RUNS;
            synchronized (map) {
                int count = 5;
                while (r.execution == null && LOADING_RUNS.containsKey(this.key()) && count-- > 0) {
                    try {
                        WithThreadName naming = new WithThreadName(": waiting for " + this.key());
                        Throwable throwable = null;
                        try {
                            LOADING_RUNS.wait(60000L);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (naming == null) continue;
                            if (throwable != null) {
                                try {
                                    naming.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            naming.close();
                        }
                    }
                    catch (InterruptedException x) {
                        LOGGER.log(Level.WARNING, "failed to wait for " + (Object)((Object)r) + " to be loaded", x);
                        break;
                    }
                }
            }
            FlowExecution exec = r.getExecution();
            if (exec != null) {
                return exec;
            }
            throw new IOException((Object)((Object)r) + " did not yet start");
        }

        public FlowExecution getOrNull() {
            try {
                WorkflowRun run = this.run();
                ListenableFuture<FlowExecution> promise = run.getExecutionPromise();
                if (promise.isDone()) {
                    return run.getExecution();
                }
            }
            catch (Exception x) {
                LOGGER.log(Level.FINE, null, x);
            }
            return null;
        }

        public File getRootDir() throws IOException {
            return this.run().getRootDir();
        }

        public Queue.Executable getExecutable() throws IOException {
            return this.run();
        }

        public String getUrl() throws IOException {
            return this.run().getUrl();
        }

        public TaskListener getListener() throws IOException {
            return this.run().getListener();
        }

        public String toString() {
            return "Owner[" + this.key() + ":" + (Object)((Object)this.run) + "]";
        }

        public boolean equals(Object o) {
            if (!(o instanceof Owner)) {
                return false;
            }
            Owner that = (Owner)((Object)o);
            return this.job.equals(that.job) && this.id.equals(that.id);
        }

        public int hashCode() {
            return this.job.hashCode() ^ this.id.hashCode();
        }
    }

    static final class SCMCheckout {
        final SCM scm;
        final String node;
        final String workspace;
        @CheckForNull
        final File changelogFile;
        @CheckForNull
        final SCMRevisionState pollingBaseline;

        SCMCheckout(SCM scm, String node, String workspace, File changelogFile, SCMRevisionState pollingBaseline) {
            this.scm = scm;
            this.node = node;
            this.workspace = workspace;
            this.changelogFile = changelogFile;
            this.pollingBaseline = pollingBaseline;
        }

        private Object readResolve() {
            if (this.scm == null) {
                throw new IllegalStateException("Unloadable scm field");
            }
            return this;
        }
    }

    private static final class LogLinePrefixOutputFilter
    extends LineTransformationOutputStream {
        private final PrintStream logger;
        private final String prefix;

        protected LogLinePrefixOutputFilter(PrintStream logger, String prefix) {
            this.logger = logger;
            this.prefix = prefix;
        }

        protected void eol(byte[] b, int len) throws IOException {
            this.logger.append(this.prefix);
            this.logger.write(b, 0, len);
        }
    }

    private static enum StopState {
        TERM,
        KILL;


        public String url() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

