/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings;

import com.google.common.collect.Lists;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.plugins.warnings.parser.ParserRegistry;
import hudson.util.ListBoxModel;
import java.util.ArrayList;
import java.util.Collection;
import org.kohsuke.stapler.DataBoundConstructor;

public class ConsoleParser
extends AbstractDescribableImpl<ConsoleParser> {
    private final String parserName;

    @DataBoundConstructor
    public ConsoleParser(String parserName) {
        this.parserName = parserName;
    }

    public String getParserName() {
        return this.parserName;
    }

    public static ConsoleParser[] filterExisting(Collection<? extends ConsoleParser> parsers) {
        ArrayList existing = Lists.newArrayList();
        for (ConsoleParser consoleParser : parsers) {
            if (!ParserRegistry.exists(consoleParser.getParserName())) continue;
            existing.add(consoleParser);
        }
        return existing.toArray(new ConsoleParser[existing.size()]);
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ConsoleParser> {
        public ListBoxModel doFillParserNameItems() {
            return ParserRegistry.getParsersAsListModel();
        }

        public String getDisplayName() {
            return "";
        }
    }
}

