/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings;

import com.google.common.collect.Lists;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractDescribableImpl;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.plugins.warnings.parser.ParserRegistry;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ParserConfiguration
extends AbstractDescribableImpl<ParserConfiguration> {
    private final String pattern;
    private final String parserName;

    @DataBoundConstructor
    public ParserConfiguration(String pattern, String parserName) {
        this.pattern = pattern;
        this.parserName = parserName;
    }

    public String getParserName() {
        return this.parserName;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String toString() {
        return String.format("%s (%s)", this.parserName, this.pattern);
    }

    public static ParserConfiguration[] filterExisting(List<? extends ParserConfiguration> parsers) {
        ArrayList existing = Lists.newArrayList();
        for (ParserConfiguration parserConfiguration : parsers) {
            if (!ParserRegistry.exists(parserConfiguration.getParserName())) continue;
            existing.add(parserConfiguration);
        }
        return existing.toArray(new ParserConfiguration[existing.size()]);
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ParserConfiguration> {
        public ListBoxModel doFillParserNameItems() {
            return ParserRegistry.getParsersAsListModel();
        }

        public String getDisplayName() {
            return "";
        }

        public FormValidation doCheckPattern(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String pattern) throws IOException {
            FormValidation required = FormValidation.validateRequired((String)pattern);
            if (required.kind == FormValidation.Kind.OK) {
                if (project == null) {
                    return required;
                }
                try {
                    FilePath workspace = project.getSomeWorkspace();
                    if (workspace != null && workspace.exists()) {
                        return FilePath.validateFileMask((FilePath)workspace, (String)pattern);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return required;
        }
    }
}

