/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import hudson.Launcher;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixRun;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.plugins.analysis.core.BuildHistory;
import hudson.plugins.analysis.core.HealthDescriptor;
import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.warnings.AggregatedWarningsResult;
import hudson.plugins.warnings.AggregatedWarningsResultAction;
import hudson.plugins.warnings.WarningsBuildHistory;
import hudson.plugins.warnings.WarningsResult;
import hudson.plugins.warnings.WarningsResultAction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WarningsAnnotationsAggregator
extends MatrixAggregator {
    private final HealthDescriptor healthDescriptor;
    private final String defaultEncoding;
    private final Map<String, ParserResult> totalsPerParser = Maps.newHashMap();
    private final boolean usePreviousBuildAsReference;
    private final boolean useStableBuildAsReference;

    public WarningsAnnotationsAggregator(MatrixBuild build, Launcher launcher, BuildListener listener, HealthDescriptor healthDescriptor, String defaultEncoding, boolean usePreviousBuildAsReference, boolean useStableBuildAsReference) {
        super(build, launcher, listener);
        this.healthDescriptor = healthDescriptor;
        this.defaultEncoding = defaultEncoding;
        this.usePreviousBuildAsReference = usePreviousBuildAsReference;
        this.useStableBuildAsReference = useStableBuildAsReference;
    }

    public boolean endRun(MatrixRun run) throws InterruptedException, IOException {
        List actions = run.getActions(WarningsResultAction.class);
        if (!actions.isEmpty()) {
            for (WarningsResultAction action : actions) {
                this.initializeParser(action.getParser());
                ParserResult aggregation = this.totalsPerParser.get(action.getParser());
                String configurationName = run.getParent().getName();
                WarningsResult result = (WarningsResult)action.getResult();
                this.addAllWarnings(aggregation, result, configurationName);
                aggregation.addModules(this.appendConfigurationNameToModule(result, configurationName));
            }
        }
        return true;
    }

    private List<String> appendConfigurationNameToModule(WarningsResult result, String configurationName) {
        ArrayList modulesByConfiguration = Lists.newArrayList();
        Collection modules = result.getModules();
        if (modules.isEmpty()) {
            modulesByConfiguration.add(configurationName);
        } else {
            for (String module : modules) {
                modulesByConfiguration.add(configurationName + " - " + module);
            }
        }
        return modulesByConfiguration;
    }

    private void addAllWarnings(ParserResult aggregation, WarningsResult result, String configurationName) {
        Set annotations = result.getAnnotations();
        for (FileAnnotation annotation : annotations) {
            annotation.setModuleName(configurationName);
        }
        aggregation.addAnnotations((Collection)annotations);
    }

    private void initializeParser(String parserName) {
        if (!this.totalsPerParser.containsKey(parserName)) {
            this.totalsPerParser.put(parserName, new ParserResult());
        }
    }

    private void createTotalsAction() {
        Object result2;
        ParserResult totals = new ParserResult();
        for (Object result2 : this.totalsPerParser.values()) {
            totals.addProject(result2);
        }
        BuildHistory history = new BuildHistory((Run)this.build, AggregatedWarningsResultAction.class, this.usePreviousBuildAsReference, this.useStableBuildAsReference);
        result2 = new AggregatedWarningsResult((Run<?, ?>)this.build, history, totals, this.defaultEncoding);
        this.build.addAction((Action)new AggregatedWarningsResultAction((Run<?, ?>)this.build, (AggregatedWarningsResult)((Object)result2)));
    }

    public boolean endBuild() throws InterruptedException, IOException {
        for (String parser : this.totalsPerParser.keySet()) {
            WarningsBuildHistory history = new WarningsBuildHistory((Run<?, ?>)this.build, parser, this.usePreviousBuildAsReference, this.useStableBuildAsReference);
            WarningsResult result = new WarningsResult((Run<?, ?>)this.build, history, this.totalsPerParser.get(parser), this.defaultEncoding, parser);
            this.build.addAction((Action)new WarningsResultAction((Run<?, ?>)this.build, this.healthDescriptor, result, parser));
        }
        this.createTotalsAction();
        return true;
    }
}

