/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings;

import com.thoughtworks.xstream.XStream;
import hudson.model.Run;
import hudson.plugins.analysis.core.BuildHistory;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.core.ResultAction;
import hudson.plugins.warnings.Messages;
import hudson.plugins.warnings.WarningsBuildHistory;
import hudson.plugins.warnings.WarningsDescriptor;
import hudson.plugins.warnings.WarningsResultAction;
import hudson.plugins.warnings.parser.ParserRegistry;
import hudson.plugins.warnings.parser.Warning;
import java.io.File;

public class WarningsResult
extends BuildResult {
    private static final String FILENAME_SUFFIX = "-warnings.xml";
    static final String ORIGINAL_COMPILER_WARNINGS_XML = "compiler-warnings.xml";
    private static final long serialVersionUID = -137460587767210579L;
    private final String group;

    public WarningsResult(Run<?, ?> build, BuildHistory history, ParserResult result, String defaultEncoding, String group) {
        this(build, history, result, defaultEncoding, group, group != null);
    }

    WarningsResult(Run<?, ?> build, BuildHistory history, ParserResult result, String defaultEncoding, String group, boolean canSerialize) {
        super(build, history, result, defaultEncoding);
        this.group = group;
        if (canSerialize) {
            this.serializeAnnotations(result.getAnnotations());
        }
    }

    protected BuildHistory createHistory(Run<?, ?> build) {
        return new WarningsBuildHistory(build, this.group, false, false);
    }

    protected void configure(XStream xstream) {
        xstream.alias("warning", Warning.class);
    }

    public String getHeader() {
        return ParserRegistry.getParser(this.group).getLinkName().toString();
    }

    public String getSummary() {
        return ParserRegistry.getParser(this.group).getLinkName() + ": " + WarningsResult.createDefaultSummary((String)this.getUrl(), (int)this.getNumberOfAnnotations(), (int)this.getNumberOfModules());
    }

    protected String createDeltaMessage() {
        return WarningsResult.createDefaultDeltaMessage((String)this.getUrl(), (int)this.getNumberOfNewWarnings(), (int)this.getNumberOfFixedWarnings());
    }

    private String getUrl() {
        return WarningsDescriptor.getResultUrl(this.group);
    }

    protected String getSerializationFileName() {
        FileChecker fileChecker = new FileChecker(this.getOwner().getRootDir());
        return this.getFileName(fileChecker, this.group == null ? 0 : ParserRegistry.getUrl(this.group));
    }

    String getFileName(FileChecker fileChecker, int groupUrl) {
        String fileName = ORIGINAL_COMPILER_WARNINGS_XML;
        if (fileChecker.canRead(fileName)) {
            return fileName;
        }
        fileName = this.createFileName(groupUrl);
        if (fileChecker.canRead(fileName)) {
            return fileName;
        }
        return this.group.replaceAll("\\W+", "") + FILENAME_SUFFIX;
    }

    String createFileName(int groupUrl) {
        return "compiler-" + groupUrl + FILENAME_SUFFIX;
    }

    public String getDisplayName() {
        if (this.group == null) {
            return Messages.Warnings_ProjectAction_Name();
        }
        return ParserRegistry.getParser(this.group).getLinkName().toString();
    }

    protected Class<? extends ResultAction<? extends BuildResult>> getResultActionType() {
        return WarningsResultAction.class;
    }

    static class FileChecker {
        private final File root;

        FileChecker(File root) {
            this.root = root;
        }

        boolean canRead(String fileName) {
            return new File(this.root, fileName).canRead();
        }
    }
}

