/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.ExtensionPoint;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.warnings.Messages;
import hudson.plugins.warnings.parser.ParsingCanceledException;
import hudson.plugins.warnings.parser.Warning;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.Collection;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jvnet.localizer.Localizable;

public abstract class AbstractWarningsParser
implements ExtensionPoint,
Serializable {
    private static final long serialVersionUID = 8466657735514387654L;
    private final Localizable parserName;
    private final Localizable linkName;
    private final Localizable trendName;
    private final String name;

    protected static Localizable localize(String string) {
        return hudson.plugins.warnings.parser.Messages._Warnings_NotLocalizedName(string);
    }

    protected AbstractWarningsParser(String parserName, String linkName, String trendName) {
        this(AbstractWarningsParser.localize(parserName), AbstractWarningsParser.localize(linkName), AbstractWarningsParser.localize(trendName));
    }

    protected AbstractWarningsParser(String parserName) {
        this(AbstractWarningsParser.localize(parserName), Messages._Warnings_ProjectAction_Name(), Messages._Warnings_Trend_Name());
    }

    protected AbstractWarningsParser(Localizable parserName, Localizable linkName, Localizable trendName) {
        this.parserName = parserName;
        this.linkName = linkName;
        this.trendName = trendName;
        this.name = parserName.toString(Locale.ENGLISH);
    }

    public abstract Collection<FileAnnotation> parse(Reader var1) throws IOException, ParsingCanceledException;

    public Localizable getParserName() {
        return this.parserName;
    }

    public Localizable getLinkName() {
        return this.linkName;
    }

    public Localizable getTrendName() {
        return this.trendName;
    }

    public String toString() {
        return this.name;
    }

    public boolean isInGroup(String group) {
        return this.name.equals(group) || this.getId().equalsIgnoreCase(group);
    }

    public String getGroup() {
        return this.name;
    }

    protected String getId() {
        return this.name;
    }

    public Warning createWarning(String fileName, int start, String category, String message) {
        return new Warning(fileName, start, this.getGroup(), category, message);
    }

    public Warning createWarning(String fileName, int start, String message) {
        return this.createWarning(fileName, start, "", message);
    }

    public Warning createWarning(String fileName, int start, String category, String message, Priority priority) {
        return new Warning(fileName, start, this.getGroup(), category, message, priority);
    }

    public Warning createWarning(String fileName, int start, String type, String category, String message, Priority priority) {
        return new Warning(fileName, start, type, category, message, priority);
    }

    public Warning createWarning(String fileName, int start, String message, Priority priority) {
        return this.createWarning(fileName, start, "", message, priority);
    }

    public String getSmallImage() {
        return "/plugin/warnings/icons/warnings-24x24.png";
    }

    public String getLargeImage() {
        return "/plugin/warnings/icons/warnings-48x48.png";
    }

    protected final int getLineNumber(String lineNumber) {
        return AbstractWarningsParser.convertLineNumber(lineNumber);
    }

    public static int convertLineNumber(String lineNumber) {
        if (StringUtils.isNotBlank((String)lineNumber)) {
            try {
                return Integer.parseInt(lineNumber);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    protected String escapeXml(String text) {
        return StringEscapeUtils.escapeXml10((String)text);
    }
}

