/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.Extension;
import hudson.plugins.warnings.parser.Messages;
import hudson.plugins.warnings.parser.RegexpLineParser;
import hudson.plugins.warnings.parser.Warning;
import java.util.regex.Matcher;

@Extension
public class AcuCobolParser
extends RegexpLineParser {
    private static final long serialVersionUID = -894639209290549425L;
    private static final String ACUCOBOL_WARNING_PATTERN = "^\\s*(\\[.*\\])?\\s*?(.*), line ([0-9]*): Warning: (.*)$";

    public AcuCobolParser() {
        super(Messages._Warnings_AcuCobol_ParserName(), Messages._Warnings_AcuCobol_LinkName(), Messages._Warnings_AcuCobol_TrendName(), ACUCOBOL_WARNING_PATTERN, true);
    }

    @Override
    protected String getId() {
        return "AcuCobol Compiler";
    }

    @Override
    protected boolean isLineInteresting(String line) {
        return line.contains("Warning");
    }

    @Override
    protected Warning createWarning(Matcher matcher) {
        String message = matcher.group(4);
        String category = this.classifyWarning(message);
        return new Warning(matcher.group(2), this.getLineNumber(matcher.group(3)), this.getGroup(), category, message);
    }
}

