/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.Extension;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.warnings.parser.Messages;
import hudson.plugins.warnings.parser.RegexpLineParser;
import hudson.plugins.warnings.parser.Warning;
import java.util.regex.Matcher;

@Extension
public class ArmccCompilerParser
extends RegexpLineParser {
    private static final long serialVersionUID = -2677728927938443703L;
    private static final String ARMCC_WARNING_PATTERN = "^\"(.+)\", line (\\d+): ([A-Z][a-z]+):\\D*(\\d+)\\D*?:\\s+(.+)$";

    public ArmccCompilerParser() {
        super(Messages._Warnings_Armcc_ParserName(), Messages._Warnings_Armcc_LinkName(), Messages._Warnings_Armcc_TrendName(), ARMCC_WARNING_PATTERN);
    }

    @Override
    protected String getId() {
        return "Armcc";
    }

    @Override
    protected Warning createWarning(Matcher matcher) {
        String fileName = matcher.group(1);
        int lineNumber = this.getLineNumber(matcher.group(2));
        String type = matcher.group(3);
        int errorCode = this.getLineNumber(matcher.group(4));
        String message = matcher.group(5);
        Priority priority = "error".equalsIgnoreCase(type) ? Priority.HIGH : Priority.NORMAL;
        return this.createWarning(fileName, lineNumber, errorCode + " - " + message, priority);
    }
}

