/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.Extension;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.warnings.parser.Messages;
import hudson.plugins.warnings.parser.RegexpLineParser;
import hudson.plugins.warnings.parser.Warning;
import java.util.regex.Matcher;

@Extension
public class ClangParser
extends RegexpLineParser {
    private static final long serialVersionUID = -3015592762345283182L;
    private static final String CLANG_WARNING_PATTERN = "^\\s*(?:\\d+%)?([^%]*?):(\\d+):(?:(\\d+):)?(?:(?:\\{\\d+:\\d+-\\d+:\\d+\\})+:)?\\s*(warning|[^\\[\\]]*error):\\s*(.*?)(?:\\[([^\\[]*)\\])?$";

    public ClangParser() {
        super(Messages._Warnings_AppleLLVMClang_ParserName(), Messages._Warnings_AppleLLVMClang_LinkName(), Messages._Warnings_AppleLLVMClang_TrendName(), CLANG_WARNING_PATTERN);
    }

    @Override
    protected Warning createWarning(Matcher matcher) {
        String message = matcher.group(5);
        if (message.matches("^-\\[.*\\].*$")) {
            return FALSE_POSITIVE;
        }
        String filename = matcher.group(1);
        int lineNumber = this.getLineNumber(matcher.group(2));
        int column = this.getLineNumber(matcher.group(3));
        String type = matcher.group(4);
        String category = matcher.group(6);
        Priority priority = type.contains("error") ? Priority.HIGH : Priority.NORMAL;
        Warning warning = category == null ? this.createWarning(filename, lineNumber, message, priority) : this.createWarning(filename, lineNumber, category, message, priority);
        warning.setColumnPosition(column);
        return warning;
    }

    @Override
    protected String getId() {
        return "Apple LLVM Compiler (Clang)";
    }
}

