/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.Extension;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.warnings.parser.Messages;
import hudson.plugins.warnings.parser.RegexpLineParser;
import hudson.plugins.warnings.parser.Warning;
import java.util.regex.Matcher;

@Extension
public class ClangTidyParser
extends RegexpLineParser {
    private static final long serialVersionUID = -3015592762345283182L;
    private static final String CLANG_TIDY_WARNING_PATTERN = "([^\\s]+):(\\d+):(\\d+): (warning|error): (.*?) \\[([^\\s]*?)\\]$";

    public ClangTidyParser() {
        super(Messages._Warnings_ClangTidy_ParserName(), Messages._Warnings_ClangTidy_LinkName(), Messages._Warnings_ClangTidy_TrendName(), CLANG_TIDY_WARNING_PATTERN);
    }

    @Override
    protected Warning createWarning(Matcher matcher) {
        String filename = matcher.group(1);
        int lineNumber = this.getLineNumber(matcher.group(2));
        int column = this.getLineNumber(matcher.group(3));
        String type = matcher.group(4);
        String message = matcher.group(5);
        String category = matcher.group(6);
        Priority priority = type.contains("error") ? Priority.HIGH : Priority.NORMAL;
        Warning warning = this.createWarning(filename, lineNumber, category, message, priority);
        warning.setColumnPosition(column);
        return warning;
    }
}

