/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.Extension;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.warnings.parser.Messages;
import hudson.plugins.warnings.parser.RegexpLineParser;
import hudson.plugins.warnings.parser.Warning;
import java.util.regex.Matcher;

@Extension
public class CppLintParser
extends RegexpLineParser {
    private static final long serialVersionUID = 1737791073711198075L;
    private static final String PATTERN = "^\\s*(.*)\\s*[(:](\\d*)\\)?:\\s*(.*)\\s*\\[(.*)\\] \\[(.*)\\]$";

    public CppLintParser() {
        super(Messages._Warnings_CppLint_ParserName(), Messages._Warnings_CppLint_LinkName(), Messages._Warnings_CppLint_TrendName(), PATTERN);
    }

    @Override
    protected Warning createWarning(Matcher matcher) {
        Priority priority = this.mapPriority(matcher.group(5));
        return this.createWarning(matcher.group(1), this.getLineNumber(matcher.group(2)), matcher.group(4), matcher.group(3), priority);
    }

    private Priority mapPriority(String priority) {
        int value = this.getLineNumber(priority);
        if (value >= 5) {
            return Priority.HIGH;
        }
        if (value >= 3) {
            return Priority.NORMAL;
        }
        return Priority.LOW;
    }
}

