/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.Extension;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.warnings.parser.Messages;
import hudson.plugins.warnings.parser.RegexpDocumentParser;
import hudson.plugins.warnings.parser.Warning;
import java.util.regex.Matcher;
import org.apache.commons.lang.StringUtils;

@Extension
public class DoxygenParser
extends RegexpDocumentParser {
    private static final long serialVersionUID = -6770174143703245309L;
    private static final String DOXYGEN_WARNING_PATTERN = "^(?:.*\\[.*\\])?\\s*(?:(?:((?:[/.]|[A-Za-z]:).+?):(-?\\d+):\\s*([Ww]arning|[Ee]rror)|<.+>:-?\\d+(?::\\s*([Ww]arning|[Ee]rror))?): (.+(?:\\n(?!\\s*(?:[Nn]otice|[Ww]arning|[Ee]rror): )[^/<\\n][^:\\n][^/\\n].+)*)|\\s*([Nn]otice|[Ww]arning|[Ee]rror): (.+))$";
    private static final int FILE_NAME_GROUP = 1;
    private static final int FILE_LINE_GROUP = 2;
    private static final int FILE_TYPE_GROUP = 3;
    private static final int FUNC_TYPE_GROUP = 4;
    private static final int LOCAL_MESSAGE_GROUP = 5;
    private static final int GLOBAL_TYPE_GROUP = 6;
    private static final int GLOBAL_MESSAGE_GROUP = 7;

    public DoxygenParser() {
        super(Messages._Warnings_Doxygen_ParserName(), Messages._Warnings_Doxygen_LinkName(), Messages._Warnings_Doxygen_TrendName(), DOXYGEN_WARNING_PATTERN, true);
    }

    @Override
    protected Warning createWarning(Matcher matcher) {
        Priority priority;
        String message;
        String fileName = "";
        int lineNumber = 0;
        if (StringUtils.isNotBlank((String)matcher.group(5))) {
            message = matcher.group(5);
            if (StringUtils.isNotBlank((String)matcher.group(1))) {
                fileName = matcher.group(1);
                lineNumber = this.getLineNumber(matcher.group(2));
                priority = this.parsePriority(matcher.group(3));
            } else {
                priority = this.parsePriority(matcher.group(4));
            }
        } else if (StringUtils.isNotBlank((String)matcher.group(7))) {
            message = matcher.group(7);
            priority = this.parsePriority(matcher.group(6));
        } else {
            message = "Unknown doxygen error.";
            priority = Priority.HIGH;
        }
        return this.createWarning(fileName, lineNumber, message, priority);
    }

    private Priority parsePriority(String warningTypeString) {
        if (StringUtils.equalsIgnoreCase((String)warningTypeString, (String)"notice")) {
            return Priority.LOW;
        }
        if (StringUtils.equalsIgnoreCase((String)warningTypeString, (String)"warning")) {
            return Priority.NORMAL;
        }
        if (StringUtils.equalsIgnoreCase((String)warningTypeString, (String)"error")) {
            return Priority.HIGH;
        }
        return Priority.HIGH;
    }
}

