/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.Extension;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.warnings.parser.Messages;
import hudson.plugins.warnings.parser.RegexpDocumentParser;
import hudson.plugins.warnings.parser.Warning;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

@Extension
public class DrMemoryParser
extends RegexpDocumentParser {
    private static final long serialVersionUID = 7195239138601238590L;
    private static final String DR_MEMORY_WARNING_PATTERN = "(?:Error #\\d+: ([\\s\\S]+?)\\r?\\n(# \\d+ [\\s\\S]*?\\r?\\n)(?=[^#])(Note: [\\s\\S]*?\\r?\\n\\r?\\n)?|Error #\\d+: ([\\s\\S]+?)\\r?\\n\\r?\\n)";
    private static final int FIRST_HEADER_GROUP = 1;
    private static final int STACK_TRACE_GROUP = 2;
    private static final int NOTES_GROUP = 3;
    private static final int SECOND_HEADER_GROUP = 4;
    private static final Pattern FILE_PATH_PATTERN = Pattern.compile("#\\s*\\d+.*?\\[(.*\\/?.*):(\\d+)\\]");
    private static final int FILE_PATH_GROUP = 1;
    private static final int LINE_NUMBER_GROUP = 2;
    private static final Pattern JENKINS_PATH_PATTERN = Pattern.compile(".*?(\\/jobs\\/.*?\\/workspace\\/|workspace\\/)");

    public DrMemoryParser() {
        super(Messages._Warnings_DrMemory_ParserName(), Messages._Warnings_DrMemory_LinkName(), Messages._Warnings_DrMemory_TrendName(), DR_MEMORY_WARNING_PATTERN, false);
    }

    @Override
    protected Warning createWarning(Matcher matcher) {
        String temp_header;
        StringBuilder messageBuilder = new StringBuilder();
        String filePath = "Nil";
        int lineNumber = 0;
        String category = "Unknown";
        Priority priority = Priority.HIGH;
        String header = "";
        if (matcher.group(4) == null) {
            String notes;
            String stackTrace;
            temp_header = matcher.group(1);
            if (temp_header != null) {
                header = temp_header.trim();
                messageBuilder.append(header);
            }
            if ((stackTrace = matcher.group(2)) != null) {
                SourceCodeLocation location = this.findOriginatingErrLocation(stackTrace.trim().split("\\r?\\n"));
                filePath = location.getFilePath();
                lineNumber = location.getLineNumber();
                stackTrace = stackTrace.trim();
                messageBuilder.append("\n");
                messageBuilder.append(stackTrace);
            }
            if ((notes = matcher.group(3)) != null) {
                notes = notes.trim();
                messageBuilder.append("\n");
                messageBuilder.append(notes);
            }
        } else {
            temp_header = matcher.group(4);
            if (temp_header != null) {
                header = temp_header.trim();
                messageBuilder.append(header);
            }
        }
        String message = messageBuilder.length() == 0 ? "Unknown Dr. Memory Error" : messageBuilder.toString().replace("\n", "<br>");
        header = header.toLowerCase();
        if (StringUtils.isNotBlank((String)header)) {
            if (header.startsWith("unaddressable access")) {
                category = "Unaddressable Access";
            } else if (header.startsWith("uninitialized read")) {
                category = "Uninitialized Read";
            } else if (header.startsWith("invalid heap argument")) {
                category = "Invalid Heap Argument";
            } else if (header.startsWith("possible leak")) {
                category = "Possible Leak";
                priority = Priority.NORMAL;
            } else if (header.startsWith("reachable leak")) {
                category = "Reachable Leak";
            } else if (header.startsWith("leak")) {
                category = "Leak";
            } else if (header.startsWith("gdi usage error")) {
                category = "GDI Usage Error";
                priority = Priority.NORMAL;
            } else if (header.startsWith("handle leak")) {
                category = "Handle Leak";
                priority = Priority.NORMAL;
            } else if (header.startsWith("warning")) {
                category = "Warning";
                priority = Priority.NORMAL;
            }
        }
        return this.createWarning(filePath, lineNumber, category, message, priority);
    }

    private SourceCodeLocation findOriginatingErrLocation(String[] stackTrace) {
        String errFilePath = "Unknown";
        int lineNumber = 0;
        for (int i = 0; i < stackTrace.length; ++i) {
            Matcher pathMatcher = FILE_PATH_PATTERN.matcher(stackTrace[i]);
            if (!pathMatcher.find()) continue;
            errFilePath = pathMatcher.group(1);
            lineNumber = Integer.valueOf(pathMatcher.group(2));
            Matcher jenkinsPathMatcher = JENKINS_PATH_PATTERN.matcher(errFilePath);
            if (jenkinsPathMatcher.find()) break;
        }
        return new SourceCodeLocation(errFilePath, lineNumber);
    }

    private static final class SourceCodeLocation {
        private final String filePath;
        private final int lineNumber;

        public SourceCodeLocation(String filePath, int lineNumber) {
            this.filePath = filePath;
            this.lineNumber = lineNumber;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }
    }
}

